/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg.common;

import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.utility.MathUtility;
import com.hankcs.hanlp.utility.Predefine;
import java.util.Map;

public class Vertex {
    public String word;
    public String realWord;
    public CoreDictionary.Attribute attribute;
    public int wordID;
    public int index;
    public Vertex from;
    public double weight;

    public void updateFrom(Vertex from) {
        double weight = from.weight + MathUtility.calculateWeight(from, this);
        if (this.from == null || this.weight > weight) {
            this.from = from;
            this.weight = weight;
        }
    }

    public Vertex(String word, String realWord, CoreDictionary.Attribute attribute) {
        this(word, realWord, attribute, attribute == null ? -1 : -attribute.totalFrequency);
    }

    public Vertex(String word, String realWord, CoreDictionary.Attribute attribute, int wordID) {
        if (attribute == null) {
            attribute = new CoreDictionary.Attribute(Nature.n, 1);
        }
        this.wordID = wordID;
        this.attribute = attribute;
        if (word == null) {
            word = this.compileRealWord(realWord, attribute);
        }
        assert (realWord.length() > 0) : "\u6784\u9020\u7a7a\u767d\u8282\u70b9\u4f1a\u5bfc\u81f4\u6b7b\u5faa\u73af\uff01";
        this.word = word;
        this.realWord = realWord;
    }

    private String compileRealWord(String realWord, CoreDictionary.Attribute attribute) {
        if (attribute.nature.length == 1) {
            Nature nature = attribute.nature[0];
            if (nature.startsWith("nr")) {
                this.wordID = CoreDictionary.NR_WORD_ID;
                return "\u672a##\u4eba";
            }
            if (nature.startsWith("ns")) {
                this.wordID = CoreDictionary.NS_WORD_ID;
                return "\u672a##\u5730";
            }
            if (nature == Nature.nx) {
                this.wordID = CoreDictionary.NX_WORD_ID;
                if (this.wordID == -1) {
                    this.wordID = CoreDictionary.X_WORD_ID;
                }
                return "\u672a##\u4e13";
            }
            if (nature.startsWith("nt") || nature == Nature.nit) {
                this.wordID = CoreDictionary.NT_WORD_ID;
                return "\u672a##\u56e2";
            }
            if (nature.startsWith('m')) {
                this.wordID = CoreDictionary.M_WORD_ID;
                this.attribute = CoreDictionary.get(CoreDictionary.M_WORD_ID);
                return "\u672a##\u6570";
            }
            if (nature.startsWith('x')) {
                this.wordID = CoreDictionary.X_WORD_ID;
                this.attribute = CoreDictionary.get(CoreDictionary.X_WORD_ID);
                return "\u672a##\u4e32";
            }
            if (nature == Nature.t) {
                this.wordID = CoreDictionary.T_WORD_ID;
                this.attribute = CoreDictionary.get(CoreDictionary.T_WORD_ID);
                return "\u672a##\u65f6";
            }
        }
        return realWord;
    }

    public Vertex(String realWord, CoreDictionary.Attribute attribute) {
        this(null, realWord, attribute);
    }

    public Vertex(String realWord, CoreDictionary.Attribute attribute, int wordID) {
        this(null, realWord, attribute, wordID);
    }

    public Vertex(Map.Entry<String, CoreDictionary.Attribute> entry) {
        this(entry.getKey(), entry.getValue());
    }

    public Vertex(String realWord) {
        this(null, realWord, CoreDictionary.get(realWord));
    }

    public Vertex(char realWord, CoreDictionary.Attribute attribute) {
        this(String.valueOf(realWord), attribute);
    }

    public String getRealWord() {
        return this.realWord;
    }

    public Vertex getFrom() {
        return this.from;
    }

    public void setFrom(Vertex from) {
        this.from = from;
    }

    public CoreDictionary.Attribute getAttribute() {
        return this.attribute;
    }

    public boolean confirmNature(Nature nature) {
        if (this.attribute.nature.length == 1 && this.attribute.nature[0] == nature) {
            return true;
        }
        boolean result = true;
        int frequency = this.attribute.getNatureFrequency(nature);
        if (frequency == 0) {
            frequency = 1000;
            result = false;
        }
        this.attribute = new CoreDictionary.Attribute(nature, frequency);
        return result;
    }

    public boolean confirmNature(Nature nature, boolean updateWord) {
        switch (nature.firstChar()) {
            case 'm': {
                this.word = "\u672a##\u6570";
                break;
            }
            case 't': {
                this.word = "\u672a##\u65f6";
                break;
            }
            default: {
                Predefine.logger.warning("\u6ca1\u6709\u4e0e" + nature + "\u5bf9\u5e94\u7684case");
            }
        }
        return this.confirmNature(nature);
    }

    public Nature getNature() {
        if (this.attribute.nature.length == 1) {
            return this.attribute.nature[0];
        }
        return null;
    }

    public Nature guessNature() {
        return this.attribute.nature[0];
    }

    public boolean hasNature(Nature nature) {
        return this.attribute.getNatureFrequency(nature) > 0;
    }

    public Vertex copy() {
        return new Vertex(this.word, this.realWord, this.attribute);
    }

    public Vertex setWord(String word) {
        this.word = word;
        return this;
    }

    public Vertex setRealWord(String realWord) {
        this.realWord = realWord;
        return this;
    }

    public static Vertex newNumberInstance(String realWord) {
        return new Vertex("\u672a##\u6570", realWord, new CoreDictionary.Attribute(Nature.m, 1000));
    }

    public static Vertex newAddressInstance(String realWord) {
        return new Vertex("\u672a##\u5730", realWord, new CoreDictionary.Attribute(Nature.ns, 1000));
    }

    public static Vertex newPunctuationInstance(String realWord) {
        return new Vertex(realWord, new CoreDictionary.Attribute(Nature.w, 1000));
    }

    public static Vertex newPersonInstance(String realWord) {
        return Vertex.newPersonInstance(realWord, 1000);
    }

    public static Vertex newTranslatedPersonInstance(String realWord, int frequency) {
        return new Vertex("\u672a##\u4eba", realWord, new CoreDictionary.Attribute(Nature.nrf, frequency));
    }

    public static Vertex newJapanesePersonInstance(String realWord, int frequency) {
        return new Vertex("\u672a##\u4eba", realWord, new CoreDictionary.Attribute(Nature.nrj, frequency));
    }

    public static Vertex newPersonInstance(String realWord, int frequency) {
        return new Vertex("\u672a##\u4eba", realWord, new CoreDictionary.Attribute(Nature.nr, frequency));
    }

    public static Vertex newPlaceInstance(String realWord, int frequency) {
        return new Vertex("\u672a##\u5730", realWord, new CoreDictionary.Attribute(Nature.ns, frequency));
    }

    public static Vertex newOrganizationInstance(String realWord, int frequency) {
        return new Vertex("\u672a##\u56e2", realWord, new CoreDictionary.Attribute(Nature.nt, frequency));
    }

    public static Vertex newTimeInstance(String realWord) {
        return new Vertex("\u672a##\u65f6", realWord, new CoreDictionary.Attribute(Nature.t, 1000));
    }

    public static Vertex newB() {
        return new Vertex("\u59cb##\u59cb", " ", new CoreDictionary.Attribute(Nature.begin, Predefine.TOTAL_FREQUENCY / 10), CoreDictionary.getWordID("\u59cb##\u59cb"));
    }

    public static Vertex newE() {
        return new Vertex("\u672b##\u672b", " ", new CoreDictionary.Attribute(Nature.end, Predefine.TOTAL_FREQUENCY / 10), CoreDictionary.getWordID("\u672b##\u672b"));
    }

    public int length() {
        return this.realWord.length();
    }

    public String toString() {
        return this.realWord;
    }
}

