/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.stc;

import java.util.Objects;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;

public class Receiver<T> {
    private final ClassNode type;
    private final boolean object;
    private final T data;

    public static <T> Receiver<T> make(ClassNode type) {
        return new Receiver<T>(type == null ? ClassHelper.OBJECT_TYPE.getPlainNodeReference() : type);
    }

    public Receiver(ClassNode type) {
        this(type, true, null);
    }

    public Receiver(ClassNode type, T data) {
        this(type, true, data);
    }

    public Receiver(ClassNode type, boolean object, T data) {
        this.type = Objects.requireNonNull(type);
        this.object = object;
        this.data = data;
    }

    public T getData() {
        return this.data;
    }

    public boolean isObject() {
        return this.object;
    }

    public ClassNode getType() {
        return this.type;
    }

    public final String toString() {
        return "Receiver{data=" + this.data + ", type=" + (this.object ? "" : "*") + this.type.toString(false) + "}";
    }
}

