/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.BundlePermission;

final class BundlePermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = 3258407326846433079L;
    private transient Map<String, BundlePermission> permissions = new HashMap<String, BundlePermission>();
    private boolean all_allowed = false;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", Hashtable.class), new ObjectStreamField("all_allowed", Boolean.TYPE)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (!(permission instanceof BundlePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        BundlePermission bundlePermission = (BundlePermission)permission;
        String string = bundlePermission.getName();
        BundlePermissionCollection bundlePermissionCollection = this;
        synchronized (bundlePermissionCollection) {
            Map<String, BundlePermission> map = this.permissions;
            BundlePermission bundlePermission2 = map.get(string);
            if (bundlePermission2 != null) {
                int n;
                int n2 = bundlePermission2.getActionsMask();
                if (n2 != (n = bundlePermission.getActionsMask())) {
                    map.put(string, new BundlePermission(string, n2 | n));
                }
            } else {
                map.put(string, bundlePermission);
            }
            if (!this.all_allowed && string.equals("*")) {
                this.all_allowed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof BundlePermission)) {
            return false;
        }
        BundlePermission bundlePermission = (BundlePermission)permission;
        String string = bundlePermission.getName();
        int n = bundlePermission.getActionsMask();
        int n2 = 0;
        BundlePermissionCollection bundlePermissionCollection = this;
        synchronized (bundlePermissionCollection) {
            int n3;
            BundlePermission bundlePermission2;
            Map<String, BundlePermission> map = this.permissions;
            if (this.all_allowed && (bundlePermission2 = map.get("*")) != null && ((n2 |= bundlePermission2.getActionsMask()) & n) == n) {
                return true;
            }
            bundlePermission2 = map.get(string);
            if (bundlePermission2 != null && ((n2 |= bundlePermission2.getActionsMask()) & n) == n) {
                return true;
            }
            int n4 = string.length() - 1;
            while ((n3 = string.lastIndexOf(".", n4)) != -1) {
                bundlePermission2 = map.get(string = string.substring(0, n3 + 1) + "*");
                if (bundlePermission2 != null && ((n2 |= bundlePermission2.getActionsMask()) & n) == n) {
                    return true;
                }
                n4 = n3 - 1;
            }
            return false;
        }
    }

    @Override
    public synchronized Enumeration<Permission> elements() {
        ArrayList<BundlePermission> arrayList = new ArrayList<BundlePermission>(this.permissions.values());
        return Collections.enumeration(arrayList);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Hashtable<String, BundlePermission> hashtable = new Hashtable<String, BundlePermission>(this.permissions);
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("permissions", hashtable);
        putField.put("all_allowed", this.all_allowed);
        objectOutputStream.writeFields();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Hashtable hashtable = (Hashtable)getField.get("permissions", null);
        this.permissions = new HashMap<String, BundlePermission>(hashtable);
        this.all_allowed = getField.get("all_allowed", false);
    }
}

