/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.blueprint.container;

import org.osgi.framework.Bundle;

public class BlueprintEvent {
    public static final int CREATING = 1;
    public static final int CREATED = 2;
    public static final int DESTROYING = 3;
    public static final int DESTROYED = 4;
    public static final int FAILURE = 5;
    public static final int GRACE_PERIOD = 6;
    public static final int WAITING = 7;
    private final int type;
    private final long timestamp;
    private final Bundle bundle;
    private final Bundle extenderBundle;
    private final String[] dependencies;
    private final Throwable cause;
    private final boolean replay;

    public BlueprintEvent(int n, Bundle bundle, Bundle bundle2) {
        this(n, bundle, bundle2, null, null);
    }

    public BlueprintEvent(int n, Bundle bundle, Bundle bundle2, String[] stringArray) {
        this(n, bundle, bundle2, stringArray, null);
    }

    public BlueprintEvent(int n, Bundle bundle, Bundle bundle2, Throwable throwable) {
        this(n, bundle, bundle2, null, throwable);
    }

    public BlueprintEvent(int n, Bundle bundle, Bundle bundle2, String[] stringArray, Throwable throwable) {
        this.type = n;
        this.timestamp = System.currentTimeMillis();
        this.bundle = bundle;
        this.extenderBundle = bundle2;
        this.dependencies = stringArray == null ? null : (String[])stringArray.clone();
        this.cause = throwable;
        this.replay = false;
        if (bundle == null) {
            throw new NullPointerException("bundle must not be null");
        }
        if (bundle2 == null) {
            throw new NullPointerException("extenderBundle must not be null");
        }
        switch (n) {
            case 6: 
            case 7: {
                if (stringArray == null) {
                    throw new NullPointerException("dependencies must not be null");
                }
                if (stringArray.length != 0) break;
                throw new IllegalArgumentException("dependencies must not be length zero");
            }
            case 5: {
                if (stringArray == null || stringArray.length != 0) break;
                throw new IllegalArgumentException("dependencies must not be length zero");
            }
            default: {
                if (stringArray == null) break;
                throw new IllegalArgumentException("dependencies must be null");
            }
        }
    }

    public BlueprintEvent(BlueprintEvent blueprintEvent, boolean bl) {
        this.type = blueprintEvent.type;
        this.timestamp = blueprintEvent.timestamp;
        this.bundle = blueprintEvent.bundle;
        this.extenderBundle = blueprintEvent.extenderBundle;
        this.dependencies = blueprintEvent.dependencies;
        this.cause = blueprintEvent.cause;
        this.replay = bl;
    }

    public int getType() {
        return this.type;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Bundle getExtenderBundle() {
        return this.extenderBundle;
    }

    public String[] getDependencies() {
        return this.dependencies == null ? null : (String[])this.dependencies.clone();
    }

    public Throwable getCause() {
        return this.cause;
    }

    public boolean isReplay() {
        return this.replay;
    }
}

