/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification.argumentmatching;

import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;
import org.mockito.internal.matchers.ContainsExtraTypeInformation;

public class ArgumentMatchingTool {
    public Integer[] getSuspiciouslyNotMatchingArgsIndexes(List<Matcher> list, Object[] objectArray) {
        if (list.size() != objectArray.length) {
            return new Integer[0];
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        int n = 0;
        for (Matcher matcher : list) {
            if (matcher instanceof ContainsExtraTypeInformation && !this.safelyMatches(matcher, objectArray[n]) && this.toStringEquals(matcher, objectArray[n]) && !((ContainsExtraTypeInformation)matcher).typeMatches(objectArray[n])) {
                linkedList.add(n);
            }
            ++n;
        }
        return linkedList.toArray(new Integer[0]);
    }

    private boolean safelyMatches(Matcher matcher, Object object) {
        try {
            return matcher.matches(object);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private boolean toStringEquals(Matcher matcher, Object object) {
        return StringDescription.toString((SelfDescribing)matcher).equals(object == null ? "null" : object.toString());
    }
}

