/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing;

import java.io.Serializable;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.invocation.DescribedInvocation;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class StubbedInvocationMatcher
extends InvocationMatcher
implements Answer,
Serializable {
    private static final long serialVersionUID = 4919105134123672727L;
    private final Queue<Answer> answers = new ConcurrentLinkedQueue<Answer>();
    private DescribedInvocation usedAt;

    public StubbedInvocationMatcher(InvocationMatcher invocationMatcher, Answer answer) {
        super(invocationMatcher.getInvocation(), invocationMatcher.getMatchers());
        this.answers.add(answer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
        Answer answer;
        Queue<Answer> queue = this.answers;
        synchronized (queue) {
            answer = this.answers.size() == 1 ? this.answers.peek() : this.answers.poll();
        }
        return answer.answer(invocationOnMock);
    }

    public void addAnswer(Answer answer) {
        this.answers.add(answer);
    }

    public void markStubUsed(DescribedInvocation describedInvocation) {
        this.usedAt = describedInvocation;
    }

    public boolean wasUsed() {
        return this.usedAt != null;
    }

    @Override
    public String toString() {
        return super.toString() + " stubbed with: " + this.answers;
    }
}

