/*
 * Decompiled with CFR 0.152.
 */
package org.mockito;

import org.mockito.Answers;
import org.mockito.InOrder;
import org.mockito.Incubating;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.MockingDetails;
import org.mockito.MockitoDebugger;
import org.mockito.ReturnValues;
import org.mockito.internal.MockitoCore;
import org.mockito.internal.creation.MockSettingsImpl;
import org.mockito.internal.debugging.MockitoDebuggerImpl;
import org.mockito.internal.stubbing.answers.AnswerReturnValuesAdapter;
import org.mockito.internal.stubbing.answers.CallsRealMethods;
import org.mockito.internal.stubbing.answers.DoesNothing;
import org.mockito.internal.stubbing.answers.Returns;
import org.mockito.internal.stubbing.answers.ThrowsException;
import org.mockito.internal.stubbing.answers.ThrowsExceptionClass;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.DeprecatedOngoingStubbing;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.stubbing.Stubber;
import org.mockito.stubbing.VoidMethodStubbable;
import org.mockito.verification.After;
import org.mockito.verification.Timeout;
import org.mockito.verification.VerificationAfterDelay;
import org.mockito.verification.VerificationMode;
import org.mockito.verification.VerificationWithTimeout;

public class Mockito
extends Matchers {
    static final MockitoCore MOCKITO_CORE = new MockitoCore();
    public static final Answer<Object> RETURNS_DEFAULTS = Answers.RETURNS_DEFAULTS.get();
    public static final Answer<Object> RETURNS_SMART_NULLS = Answers.RETURNS_SMART_NULLS.get();
    public static final Answer<Object> RETURNS_MOCKS = Answers.RETURNS_MOCKS.get();
    public static final Answer<Object> RETURNS_DEEP_STUBS = Answers.RETURNS_DEEP_STUBS.get();
    public static final Answer<Object> CALLS_REAL_METHODS = Answers.CALLS_REAL_METHODS.get();

    public static <T> T mock(Class<T> clazz) {
        return Mockito.mock(clazz, Mockito.withSettings().defaultAnswer(RETURNS_DEFAULTS));
    }

    public static <T> T mock(Class<T> clazz, String string) {
        return Mockito.mock(clazz, Mockito.withSettings().name(string).defaultAnswer(RETURNS_DEFAULTS));
    }

    public static MockingDetails mockingDetails(Object object) {
        return MOCKITO_CORE.mockingDetails(object);
    }

    @Deprecated
    public static <T> T mock(Class<T> clazz, ReturnValues returnValues) {
        return Mockito.mock(clazz, Mockito.withSettings().defaultAnswer(new AnswerReturnValuesAdapter(returnValues)));
    }

    public static <T> T mock(Class<T> clazz, Answer answer) {
        return Mockito.mock(clazz, Mockito.withSettings().defaultAnswer(answer));
    }

    public static <T> T mock(Class<T> clazz, MockSettings mockSettings) {
        return MOCKITO_CORE.mock(clazz, mockSettings);
    }

    public static <T> T spy(T t) {
        return (T)MOCKITO_CORE.mock(t.getClass(), Mockito.withSettings().spiedInstance(t).defaultAnswer(CALLS_REAL_METHODS));
    }

    @Incubating
    public static <T> T spy(Class<T> clazz) {
        return MOCKITO_CORE.mock(clazz, Mockito.withSettings().useConstructor().defaultAnswer(CALLS_REAL_METHODS));
    }

    public static <T> DeprecatedOngoingStubbing<T> stub(T t) {
        return MOCKITO_CORE.stub(t);
    }

    public static <T> OngoingStubbing<T> when(T t) {
        return MOCKITO_CORE.when(t);
    }

    public static <T> T verify(T t) {
        return MOCKITO_CORE.verify(t, Mockito.times(1));
    }

    public static <T> T verify(T t, VerificationMode verificationMode) {
        return MOCKITO_CORE.verify(t, verificationMode);
    }

    public static <T> void reset(T ... TArray) {
        MOCKITO_CORE.reset(TArray);
    }

    public static void verifyNoMoreInteractions(Object ... objectArray) {
        MOCKITO_CORE.verifyNoMoreInteractions(objectArray);
    }

    public static void verifyZeroInteractions(Object ... objectArray) {
        MOCKITO_CORE.verifyNoMoreInteractions(objectArray);
    }

    public static <T> VoidMethodStubbable<T> stubVoid(T t) {
        return MOCKITO_CORE.stubVoid(t);
    }

    public static Stubber doThrow(Throwable throwable) {
        return MOCKITO_CORE.doAnswer(new ThrowsException(throwable));
    }

    public static Stubber doThrow(Class<? extends Throwable> clazz) {
        return MOCKITO_CORE.doAnswer(new ThrowsExceptionClass(clazz));
    }

    public static Stubber doCallRealMethod() {
        return MOCKITO_CORE.doAnswer(new CallsRealMethods());
    }

    public static Stubber doAnswer(Answer answer) {
        return MOCKITO_CORE.doAnswer(answer);
    }

    public static Stubber doNothing() {
        return MOCKITO_CORE.doAnswer(new DoesNothing());
    }

    public static Stubber doReturn(Object object) {
        return MOCKITO_CORE.doAnswer(new Returns(object));
    }

    public static InOrder inOrder(Object ... objectArray) {
        return MOCKITO_CORE.inOrder(objectArray);
    }

    public static Object[] ignoreStubs(Object ... objectArray) {
        return MOCKITO_CORE.ignoreStubs(objectArray);
    }

    public static VerificationMode times(int n) {
        return VerificationModeFactory.times(n);
    }

    public static VerificationMode never() {
        return Mockito.times(0);
    }

    public static VerificationMode atLeastOnce() {
        return VerificationModeFactory.atLeastOnce();
    }

    public static VerificationMode atLeast(int n) {
        return VerificationModeFactory.atLeast(n);
    }

    public static VerificationMode atMost(int n) {
        return VerificationModeFactory.atMost(n);
    }

    public static VerificationMode calls(int n) {
        return VerificationModeFactory.calls(n);
    }

    public static VerificationMode only() {
        return VerificationModeFactory.only();
    }

    public static VerificationWithTimeout timeout(long l) {
        return new Timeout(l, VerificationModeFactory.times(1));
    }

    public static VerificationAfterDelay after(int n) {
        return new After(n, VerificationModeFactory.times(1));
    }

    public static void validateMockitoUsage() {
        MOCKITO_CORE.validateMockitoUsage();
    }

    public static MockSettings withSettings() {
        return new MockSettingsImpl().defaultAnswer(RETURNS_DEFAULTS);
    }

    @Deprecated
    static MockitoDebugger debug() {
        return new MockitoDebuggerImpl();
    }
}

