/*
 * Decompiled with CFR 0.152.
 */
package org.mockito;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.mockito.internal.matchers.Any;
import org.mockito.internal.matchers.AnyVararg;
import org.mockito.internal.matchers.Contains;
import org.mockito.internal.matchers.EndsWith;
import org.mockito.internal.matchers.Equals;
import org.mockito.internal.matchers.InstanceOf;
import org.mockito.internal.matchers.Matches;
import org.mockito.internal.matchers.NotNull;
import org.mockito.internal.matchers.Null;
import org.mockito.internal.matchers.Same;
import org.mockito.internal.matchers.StartsWith;
import org.mockito.internal.matchers.apachecommons.ReflectionEquals;
import org.mockito.internal.progress.HandyReturnValues;
import org.mockito.internal.progress.MockingProgress;
import org.mockito.internal.progress.ThreadSafeMockingProgress;

public class Matchers {
    private static final MockingProgress MOCKING_PROGRESS = new ThreadSafeMockingProgress();

    public static boolean anyBoolean() {
        return Matchers.reportMatcher(Any.ANY).returnFalse();
    }

    public static byte anyByte() {
        return Matchers.reportMatcher(Any.ANY).returnZero();
    }

    public static char anyChar() {
        return Matchers.reportMatcher(Any.ANY).returnChar();
    }

    public static int anyInt() {
        return Matchers.reportMatcher(Any.ANY).returnZero();
    }

    public static long anyLong() {
        return Matchers.reportMatcher(Any.ANY).returnZero();
    }

    public static float anyFloat() {
        return Matchers.reportMatcher(Any.ANY).returnZero();
    }

    public static double anyDouble() {
        return Matchers.reportMatcher(Any.ANY).returnZero();
    }

    public static short anyShort() {
        return Matchers.reportMatcher(Any.ANY).returnZero();
    }

    public static <T> T anyObject() {
        return Matchers.reportMatcher(Any.ANY).returnNull();
    }

    public static <T> T anyVararg() {
        return Matchers.reportMatcher(AnyVararg.ANY_VARARG).returnNull();
    }

    public static <T> T any(Class<T> clazz) {
        return (T)Matchers.reportMatcher(Any.ANY).returnFor(clazz);
    }

    public static <T> T any() {
        return Matchers.anyObject();
    }

    public static String anyString() {
        return Matchers.reportMatcher(Any.ANY).returnString();
    }

    public static List anyList() {
        return Matchers.reportMatcher(Any.ANY).returnList();
    }

    public static <T> List<T> anyListOf(Class<T> clazz) {
        return Matchers.reportMatcher(Any.ANY).returnList();
    }

    public static Set anySet() {
        return Matchers.reportMatcher(Any.ANY).returnSet();
    }

    public static <T> Set<T> anySetOf(Class<T> clazz) {
        return Matchers.reportMatcher(Any.ANY).returnSet();
    }

    public static Map anyMap() {
        return Matchers.reportMatcher(Any.ANY).returnMap();
    }

    public static <K, V> Map<K, V> anyMapOf(Class<K> clazz, Class<V> clazz2) {
        return Matchers.reportMatcher(Any.ANY).returnMap();
    }

    public static Collection anyCollection() {
        return Matchers.reportMatcher(Any.ANY).returnList();
    }

    public static <T> Collection<T> anyCollectionOf(Class<T> clazz) {
        return Matchers.reportMatcher(Any.ANY).returnList();
    }

    public static <T> T isA(Class<T> clazz) {
        return (T)Matchers.reportMatcher(new InstanceOf(clazz)).returnFor(clazz);
    }

    public static boolean eq(boolean bl) {
        return Matchers.reportMatcher(new Equals(bl)).returnFalse();
    }

    public static byte eq(byte by) {
        return Matchers.reportMatcher(new Equals(by)).returnZero();
    }

    public static char eq(char c) {
        return Matchers.reportMatcher(new Equals(Character.valueOf(c))).returnChar();
    }

    public static double eq(double d) {
        return Matchers.reportMatcher(new Equals(d)).returnZero();
    }

    public static float eq(float f) {
        return Matchers.reportMatcher(new Equals(Float.valueOf(f))).returnZero();
    }

    public static int eq(int n) {
        return Matchers.reportMatcher(new Equals(n)).returnZero();
    }

    public static long eq(long l) {
        return Matchers.reportMatcher(new Equals(l)).returnZero();
    }

    public static short eq(short s) {
        return Matchers.reportMatcher(new Equals(s)).returnZero();
    }

    public static <T> T eq(T t) {
        return Matchers.reportMatcher(new Equals(t)).returnFor(t);
    }

    public static <T> T refEq(T t, String ... stringArray) {
        return Matchers.reportMatcher(new ReflectionEquals(t, stringArray)).returnNull();
    }

    public static <T> T same(T t) {
        return Matchers.reportMatcher(new Same(t)).returnFor(t);
    }

    public static Object isNull() {
        return Matchers.reportMatcher(Null.NULL).returnNull();
    }

    public static <T> T isNull(Class<T> clazz) {
        return Matchers.reportMatcher(Null.NULL).returnNull();
    }

    public static Object notNull() {
        return Matchers.reportMatcher(NotNull.NOT_NULL).returnNull();
    }

    public static <T> T notNull(Class<T> clazz) {
        return Matchers.reportMatcher(NotNull.NOT_NULL).returnNull();
    }

    public static Object isNotNull() {
        return Matchers.notNull();
    }

    public static <T> T isNotNull(Class<T> clazz) {
        return Matchers.notNull(clazz);
    }

    public static String contains(String string) {
        return Matchers.reportMatcher(new Contains(string)).returnString();
    }

    public static String matches(String string) {
        return Matchers.reportMatcher(new Matches(string)).returnString();
    }

    public static String endsWith(String string) {
        return Matchers.reportMatcher(new EndsWith(string)).returnString();
    }

    public static String startsWith(String string) {
        return Matchers.reportMatcher(new StartsWith(string)).returnString();
    }

    public static <T> T argThat(Matcher<T> matcher) {
        return Matchers.reportMatcher(matcher).returnNull();
    }

    public static char charThat(Matcher<Character> matcher) {
        return Matchers.reportMatcher(matcher).returnChar();
    }

    public static boolean booleanThat(Matcher<Boolean> matcher) {
        return Matchers.reportMatcher(matcher).returnFalse();
    }

    public static byte byteThat(Matcher<Byte> matcher) {
        return Matchers.reportMatcher(matcher).returnZero();
    }

    public static short shortThat(Matcher<Short> matcher) {
        return Matchers.reportMatcher(matcher).returnZero();
    }

    public static int intThat(Matcher<Integer> matcher) {
        return Matchers.reportMatcher(matcher).returnZero();
    }

    public static long longThat(Matcher<Long> matcher) {
        return Matchers.reportMatcher(matcher).returnZero();
    }

    public static float floatThat(Matcher<Float> matcher) {
        return Matchers.reportMatcher(matcher).returnZero();
    }

    public static double doubleThat(Matcher<Double> matcher) {
        return Matchers.reportMatcher(matcher).returnZero();
    }

    private static HandyReturnValues reportMatcher(Matcher<?> matcher) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportMatcher(matcher);
    }
}

