/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.mock;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.java.sip.communicator.impl.protocol.mock.MockChatRoomMember;
import net.java.sip.communicator.impl.protocol.mock.MockContact;
import net.java.sip.communicator.impl.protocol.mock.MockMessage;
import net.java.sip.communicator.impl.protocol.mock.MockMultiUserChat;
import net.java.sip.communicator.impl.protocol.mock.MockProvider;
import net.java.sip.communicator.service.protocol.AbstractChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomConfigurationForm;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.ConferenceDescription;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ChatRoomLocalUserRoleListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPresenceListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPropertyChangeListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberRoleListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomPropertyChangeListener;

public class MockChatRoom
extends AbstractChatRoom {
    private MockProvider provider;
    private MockMultiUserChat parentOpSet = null;
    private String name;
    private String subject;
    private String nickname;
    private boolean joined = false;
    private List<ChatRoomMember> members = new Vector<ChatRoomMember>();
    private final List<ChatRoomMemberPresenceListener> memberPresenceListeners = new Vector<ChatRoomMemberPresenceListener>();
    private final List<ChatRoomLocalUserRoleListener> localUserRoleListeners = new Vector<ChatRoomLocalUserRoleListener>();
    private final List<ChatRoomMemberRoleListener> memberRoleListeners = new Vector<ChatRoomMemberRoleListener>();
    private final List<ChatRoomPropertyChangeListener> propertyChangeListeners = new Vector<ChatRoomPropertyChangeListener>();
    private final List<ChatRoomMessageListener> messageListeners = new Vector<ChatRoomMessageListener>();

    public MockChatRoom(MockProvider provider, MockMultiUserChat parentOpSet, String roomName) {
        this.provider = provider;
        this.name = roomName;
        this.parentOpSet = parentOpSet;
    }

    public String getName() {
        return this.name;
    }

    public void join() throws OperationFailedException {
        this.joinAs(null, null);
    }

    public void join(byte[] password) throws OperationFailedException {
        this.joinAs(null, password);
    }

    public void joinAs(String nickname) throws OperationFailedException {
        this.joinAs(nickname, null);
    }

    public void joinAs(String nickname, byte[] password) throws OperationFailedException {
        if (nickname == null) {
            nickname = this.getParentProvider().getAccountID().getUserID();
        }
        this.nickname = nickname;
        this.joined = true;
        MockContact mockContact = new MockContact(nickname, (MockProvider)this.getParentProvider());
        MockChatRoomMember newMember = new MockChatRoomMember(nickname, (ChatRoom)this, ChatRoomMemberRole.MEMBER, (Contact)mockContact, null);
        this.members.add(newMember);
        this.parentOpSet.fireLocalUserPresenceEvent((ChatRoom)this, "LocalUserJoined", null);
    }

    public boolean isJoined() {
        return this.joined;
    }

    public void leave() {
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) throws OperationFailedException {
        this.subject = subject;
    }

    public String getUserNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) throws OperationFailedException {
        this.nickname = nickname;
    }

    public void addMemberPresenceListener(ChatRoomMemberPresenceListener listener) {
        if (!this.memberPresenceListeners.contains(listener)) {
            this.memberPresenceListeners.add(listener);
        }
    }

    public void removeMemberPresenceListener(ChatRoomMemberPresenceListener listener) {
        this.memberPresenceListeners.remove(listener);
    }

    public void addLocalUserRoleListener(ChatRoomLocalUserRoleListener listener) {
        if (!this.localUserRoleListeners.contains(listener)) {
            this.localUserRoleListeners.add(listener);
        }
    }

    public void removelocalUserRoleListener(ChatRoomLocalUserRoleListener listener) {
        this.localUserRoleListeners.remove(listener);
    }

    public void addMemberRoleListener(ChatRoomMemberRoleListener listener) {
        if (!this.memberRoleListeners.contains(listener)) {
            this.memberRoleListeners.add(listener);
        }
    }

    public void removeMemberRoleListener(ChatRoomMemberRoleListener listener) {
        this.memberRoleListeners.remove(listener);
    }

    public void addPropertyChangeListener(ChatRoomPropertyChangeListener listener) {
        if (!this.propertyChangeListeners.contains(listener)) {
            this.propertyChangeListeners.add(listener);
        }
    }

    public void removePropertyChangeListener(ChatRoomPropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    public void invite(String userAddress, String reason) {
    }

    public List<ChatRoomMember> getMembers() {
        return this.members;
    }

    public int getMembersCount() {
        return this.members.size();
    }

    public void addMessageListener(ChatRoomMessageListener listener) {
        if (!this.messageListeners.contains(listener)) {
            this.messageListeners.add(listener);
        }
    }

    public void removeMessageListener(ChatRoomMessageListener listener) {
        this.messageListeners.remove(listener);
    }

    public Message createMessage(byte[] content, String contentType, String contentEncoding, String subject) {
        return new MockMessage(new String(content), contentType, contentEncoding, subject);
    }

    public Message createMessage(String messageText) {
        return new MockMessage(messageText);
    }

    public void sendMessage(Message message) throws OperationFailedException {
        ChatRoomMessageDeliveredEvent evt = new ChatRoomMessageDeliveredEvent((ChatRoom)this, new Date(), message, 1);
        for (ChatRoomMessageListener elem : this.messageListeners) {
            elem.messageDelivered(evt);
        }
    }

    public ProtocolProviderService getParentProvider() {
        return this.provider;
    }

    public Iterator<ChatRoomMember> getBanList() {
        return new Vector().iterator();
    }

    public void deliverMessage(Message msg, String from) {
        ChatRoomMember fromMember = null;
        for (ChatRoomMember elem : this.members) {
            if (!elem.getName().equals(from)) continue;
            fromMember = elem;
            break;
        }
        if (fromMember == null) {
            return;
        }
        ChatRoomMessageReceivedEvent evt = new ChatRoomMessageReceivedEvent((ChatRoom)this, fromMember, new Date(), msg, 1);
        for (ChatRoomMessageListener elem : this.messageListeners) {
            elem.messageReceived(evt);
        }
    }

    public void setUserNickname(String nickname) throws OperationFailedException {
        this.nickname = nickname;
    }

    public String getIdentifier() {
        return this.name;
    }

    public void banParticipant(ChatRoomMember chatRoomMember, String reason) throws OperationFailedException {
    }

    public void kickParticipant(ChatRoomMember chatRoomMember, String reason) throws OperationFailedException {
    }

    public ChatRoomConfigurationForm getConfigurationForm() throws OperationFailedException {
        return null;
    }

    public void addMemberPropertyChangeListener(ChatRoomMemberPropertyChangeListener listener) {
    }

    public void removeMemberPropertyChangeListener(ChatRoomMemberPropertyChangeListener listener) {
    }

    public boolean isSystem() {
        return false;
    }

    public boolean isPersistent() {
        return true;
    }

    public void grantAdmin(String address) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void grantMembership(String address) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void grantModerator(String address) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void grantOwnership(String address) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void grantVoice(String address) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void revokeAdmin(String address) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void revokeMembership(String address) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void revokeModerator(String address) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void revokeOwnership(String address) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void revokeVoice(String address) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ChatRoomMemberRole getUserRole() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setLocalUserRole(ChatRoomMemberRole role) throws OperationFailedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ConferenceDescription publishConference(ConferenceDescription cd, String name) {
        return null;
    }

    public Contact getPrivateContactByNickname(String name) {
        return null;
    }

    public void updatePrivateContactPresenceStatus(String nickname) {
    }

    public void updatePrivateContactPresenceStatus(Contact sourceContact) {
    }

    public boolean destroy(String reason, String alternateAddress) {
        return true;
    }

    public List<String> getMembersWhiteList() {
        return new ArrayList<String>();
    }

    public void setMembersWhiteList(List<String> members) {
    }
}

