/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.jibri;

import net.java.sip.communicator.impl.protocol.jabber.extensions.jibri.JibriIq;
import org.jitsi.util.StringUtils;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.xmlpull.v1.XmlPullParser;

public class JibriIqProvider
implements IQProvider {
    public IQ parseIQ(XmlPullParser parser) throws Exception {
        JibriIq iq;
        String namespace = parser.getNamespace();
        if (!"http://jitsi.org/protocol/jibri".equals(namespace)) {
            return null;
        }
        String rootElement = parser.getName();
        if ("jibri".equals(rootElement)) {
            String streamId;
            iq = new JibriIq();
            String action = parser.getAttributeValue("", "action");
            iq.setAction(JibriIq.Action.parse(action));
            String status = parser.getAttributeValue("", "status");
            iq.setStatus(JibriIq.Status.parse(status));
            String room = parser.getAttributeValue("", "room");
            if (!StringUtils.isNullOrEmpty((String)room)) {
                iq.setRoom(room);
            }
            if (!StringUtils.isNullOrEmpty((String)(streamId = parser.getAttributeValue("", "streamid")))) {
                iq.setStreamId(streamId);
            }
        } else {
            return null;
        }
        boolean done = false;
        while (!done) {
            switch (parser.next()) {
                case 2: {
                    String name = parser.getName();
                    if (!"error".equals(name)) break;
                    XMPPError error = PacketParserUtils.parseError((XmlPullParser)parser);
                    iq.setXMPPError(error);
                    break;
                }
                case 3: {
                    String name = parser.getName();
                    if (!rootElement.equals(name)) break;
                    done = true;
                    break;
                }
            }
        }
        return iq;
    }
}

