/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.GeneralDialPadDialog;
import net.java.sip.communicator.impl.gui.main.call.DTMFHandler;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.SIPCommButton;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.resources.ImageID;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.OSUtils;

public class GeneralDialPanel
extends TransparentPanel
implements MouseListener,
Skinnable {
    private final GeneralDialPadDialog dialPadDialog;
    private final JPanel dialPadPanel = new TransparentPanel((LayoutManager)new GridLayout(4, 3, GuiActivator.getResources().getSettingsInt("impl.gui.DIAL_PAD_HORIZONTAL_GAP"), GuiActivator.getResources().getSettingsInt("impl.gui.DIAL_PAD_VERTICAL_GAP")));
    private final DTMFHandler dtmfHandler;

    public GeneralDialPanel(GeneralDialPadDialog dialPadDialog, DTMFHandler dtmfHandler) {
        this.dialPadDialog = dialPadDialog;
        this.dtmfHandler = dtmfHandler;
        this.init();
    }

    private JButton createDialButton(ImageID imageID, ImageID rolloverImageID, ImageID pressedImageImageID, String name) {
        SIPCommButton button = new SIPCommButton((Image)ImageLoader.getImage(imageID), (Image)ImageLoader.getImage(rolloverImageID), (Image)ImageLoader.getImage(pressedImageImageID), null, null, null);
        button.setAlignmentY(0.0f);
        button.setOpaque(false);
        button.setName(name);
        button.addMouseListener(this);
        return button;
    }

    public void init() {
        this.dialPadPanel.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.loadSkin();
        this.add(this.dialPadPanel, "Center");
    }

    public void loadSkin() {
        this.dialPadPanel.removeAll();
        for (DTMFHandler.DTMFToneInfo info : DTMFHandler.AVAILABLE_TONES) {
            if (info.imageID == null) continue;
            JButton c = OSUtils.IS_MAC ? this.createDialButton(info.macImageID, info.macImageRolloverID, info.macImageRolloverID, info.tone.getValue()) : this.createDialButton(info.imageID, info.imageIDPressed, info.imageIDRollover, info.tone.getValue());
            this.dialPadPanel.add(c);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        JButton button = (JButton)e.getSource();
        this.dialPadDialog.dialButtonPressed(button.getName());
        this.dtmfHandler.startSendingDtmfTone(button.getName());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dtmfHandler.stopSendingDtmfTone();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        BufferedImage bgImage = ImageLoader.getImage(ImageLoader.MAIN_WINDOW_BACKGROUND);
        if (bgImage != null) {
            ResourceManagementService r = GuiActivator.getResources();
            boolean isTextureBackground = Boolean.parseBoolean(r.getSettingsString("impl.gui.IS_CONTACT_LIST_TEXTURE_BG_ENABLED"));
            int width = this.getWidth();
            int height = this.getHeight();
            if (isTextureBackground) {
                Rectangle rect = new Rectangle(0, 0, bgImage.getWidth(null), bgImage.getHeight(null));
                TexturePaint texture = new TexturePaint(bgImage, rect);
                g2.setPaint(texture);
                g2.fillRect(0, 0, width, height);
            } else {
                g.setColor(new Color(r.getColor("contactListBackground")));
                g.fillRect(0, 0, width, height);
                g2.drawImage((Image)bgImage, width - bgImage.getWidth(), height - bgImage.getHeight(), (ImageObserver)((Object)this));
            }
        }
    }
}

