/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model.gd;

import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreator;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.QName;
import com.google.gdata.util.Namespaces;

public class ExtendedProperty
extends Element {
    public static final ElementKey<Void, ExtendedProperty> KEY = ElementKey.of(new QName(Namespaces.gNs, "extendedProperty"), Void.class, ExtendedProperty.class);
    public static final AttributeKey<String> NAME = AttributeKey.of(new QName(null, "name"), String.class);
    public static final AttributeKey<String> REALM = AttributeKey.of(new QName(null, "realm"), String.class);
    public static final AttributeKey<String> VALUE = AttributeKey.of(new QName(null, "value"), String.class);

    public static void registerMetadata(MetadataRegistry registry) {
        if (registry.isRegistered(KEY)) {
            return;
        }
        ElementCreator builder = registry.build(KEY);
        builder.addAttribute(NAME).setRequired(true);
        builder.addAttribute(REALM);
        builder.addAttribute(VALUE);
    }

    public ExtendedProperty() {
        super(KEY);
    }

    protected ExtendedProperty(ElementKey<?, ? extends ExtendedProperty> key) {
        super(key);
    }

    protected ExtendedProperty(ElementKey<?, ? extends ExtendedProperty> key, Element source) {
        super(key, source);
    }

    @Override
    public ExtendedProperty lock() {
        return (ExtendedProperty)super.lock();
    }

    public String getName() {
        return super.getAttributeValue(NAME);
    }

    public ExtendedProperty setName(String name) {
        super.setAttributeValue(NAME, (Object)name);
        return this;
    }

    public boolean hasName() {
        return super.hasAttribute(NAME);
    }

    public String getRealm() {
        return super.getAttributeValue(REALM);
    }

    public ExtendedProperty setRealm(String realm) {
        super.setAttributeValue(REALM, (Object)realm);
        return this;
    }

    public boolean hasRealm() {
        return super.hasAttribute(REALM);
    }

    public String getValue() {
        return super.getAttributeValue(VALUE);
    }

    public ExtendedProperty setValue(String value) {
        super.setAttributeValue(VALUE, (Object)value);
        return this;
    }

    public boolean hasValue() {
        return super.hasAttribute(VALUE);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        ExtendedProperty other = (ExtendedProperty)obj;
        return ExtendedProperty.eq(this.getName(), other.getName()) && ExtendedProperty.eq(this.getRealm(), other.getRealm()) && ExtendedProperty.eq(this.getValue(), other.getValue());
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.getName() != null) {
            result = 37 * result + this.getName().hashCode();
        }
        if (this.getRealm() != null) {
            result = 37 * result + this.getRealm().hashCode();
        }
        if (this.getValue() != null) {
            result = 37 * result + this.getValue().hashCode();
        }
        return result;
    }

    public static final class Realm {
        public static final String SHARED = "http://schemas.google.com/g/2005#shared";
        private static final String[] ALL_VALUES = new String[]{"http://schemas.google.com/g/2005#shared"};

        public static String[] values() {
            return ALL_VALUES;
        }

        private Realm() {
        }
    }
}

