/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model.gd;

import com.google.gdata.data.ILink;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreator;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.QName;
import com.google.gdata.model.atom.Entry;
import com.google.gdata.model.gd.FeedLink;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.Namespaces;

public class EntryLink
extends Element
implements ILink {
    public static final ElementKey<Void, EntryLink> KEY = ElementKey.of(new QName(Namespaces.gNs, "entryLink"), EntryLink.class);
    public static final AttributeKey<String> HREF = AttributeKey.of(new QName("href"));
    public static final AttributeKey<Boolean> READ_ONLY = AttributeKey.of(new QName("readOnly"), Boolean.class);
    public static final AttributeKey<String> REL = AttributeKey.of(new QName("rel"));

    public static void registerMetadata(MetadataRegistry registry) {
        if (registry.isRegistered(KEY)) {
            return;
        }
        ElementCreator builder = registry.build(KEY);
        builder.addAttribute(REL);
        builder.addAttribute(HREF);
        builder.addAttribute(READ_ONLY);
        builder.addElement(Entry.KEY);
    }

    public EntryLink() {
        super(KEY);
    }

    protected EntryLink(ElementKey<?, ? extends EntryLink> key) {
        super(key);
    }

    protected EntryLink(ElementKey<?, ? extends EntryLink> key, Element source) {
        super(key, source);
    }

    public Entry getEntry() {
        return this.getElement(Entry.KEY);
    }

    public void setEntry(Entry entry) {
        this.setElement(Entry.KEY, (Element)entry);
    }

    public boolean hasEntry() {
        return this.hasElement(Entry.KEY);
    }

    @Override
    public String getHref() {
        return this.getAttributeValue(HREF);
    }

    @Override
    public void setHref(String href) {
        this.setAttributeValue(HREF, (Object)href);
    }

    public boolean hasHref() {
        return this.getHref() != null;
    }

    public Boolean getReadOnly() {
        return this.getAttributeValue(READ_ONLY);
    }

    public void setReadOnly(Boolean readOnly) {
        this.setAttributeValue(READ_ONLY, (Object)readOnly);
    }

    public boolean hasReadOnly() {
        return this.getReadOnly() != null;
    }

    @Override
    public String getRel() {
        return this.getAttributeValue(REL);
    }

    @Override
    public void setRel(String rel) {
        this.setAttributeValue(REL, (Object)rel);
    }

    public boolean hasRel() {
        return this.getRel() != null;
    }

    @Override
    public String toString() {
        return "{EntryLink href=" + this.getAttributeValue(HREF) + " readOnly=" + this.getAttributeValue(READ_ONLY) + " rel=" + this.getAttributeValue(REL) + "}";
    }

    @Override
    public String getType() {
        return ContentType.getAtomFeed().toString();
    }

    @Override
    public void setType(String type) {
        throw new UnsupportedOperationException("Type property not modifiable in " + FeedLink.class.getSimpleName());
    }
}

