/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.contacts;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="gContact", nsUri="http://schemas.google.com/contact/2008", localName="userDefinedField")
public class UserDefinedField
extends ExtensionPoint {
    static final String XML_NAME = "userDefinedField";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private String key = null;
    private String value = null;

    public UserDefinedField() {
    }

    public UserDefinedField(String key, String value) {
        this.setKey(key);
        this.setValue(value);
        this.setImmutable(true);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.throwExceptionIfImmutable();
        this.key = key;
    }

    public boolean hasKey() {
        return this.getKey() != null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.throwExceptionIfImmutable();
        this.value = value;
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    @Override
    protected void validate() {
        if (this.key == null) {
            UserDefinedField.throwExceptionForMissingAttribute(KEY);
        }
        if (this.value == null) {
            UserDefinedField.throwExceptionForMissingAttribute(VALUE);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(UserDefinedField.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    @Override
    protected void putAttributes(AttributeGenerator generator) {
        generator.put(KEY, this.key);
        generator.put(VALUE, this.value);
    }

    @Override
    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.key = helper.consume(KEY, true);
        this.value = helper.consume(VALUE, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        UserDefinedField other = (UserDefinedField)obj;
        return UserDefinedField.eq(this.key, other.key) && UserDefinedField.eq(this.value, other.value);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.key != null) {
            result = 37 * result + this.key.hashCode();
        }
        if (this.value != null) {
            result = 37 * result + this.value.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{UserDefinedField key=" + this.key + " value=" + this.value + "}";
    }
}

