/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import org.jitsi.impl.neomedia.RTPPacketPredicate;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformerAdapter;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.util.Logger;

public class AbsSendTimeEngine
extends SinglePacketTransformerAdapter
implements TransformEngine {
    private static final int b = 1000000000;
    private static final Logger logger = Logger.getLogger(AbsSendTimeEngine.class);
    private int extensionID = -1;

    public AbsSendTimeEngine() {
        super(RTPPacketPredicate.INSTANCE);
    }

    @Override
    public RawPacket transform(RawPacket pkt) {
        if (this.extensionID != -1 && !this.replaceExtension(pkt)) {
            this.addExtension(pkt);
        }
        return pkt;
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return null;
    }

    private boolean replaceExtension(RawPacket pkt) {
        int len;
        if (!pkt.getExtensionBit()) {
            return false;
        }
        byte[] buf = pkt.getBuffer();
        int extensionOffset = pkt.getOffset();
        extensionOffset += 12;
        if (buf.length < (extensionOffset += pkt.getCsrcCount() * 4) + 4) {
            return false;
        }
        if (buf[extensionOffset++] != -66) {
            return false;
        }
        if (buf[extensionOffset++] != -34) {
            return false;
        }
        int lengthInWords = (buf[extensionOffset++] & 0xFF) << 8 | buf[extensionOffset++] & 0xFF;
        int lengthInBytes = 4 * lengthInWords;
        for (int innerOffset = 0; extensionOffset < buf.length && innerOffset < lengthInBytes; innerOffset += 1 + len + 1, extensionOffset += 1 + len + 1) {
            int id = (buf[extensionOffset] & 0xF0) >> 4;
            len = buf[extensionOffset] & 0xF;
            if (id != this.extensionID) continue;
            if (len == 2 && extensionOffset + 3 < buf.length) {
                this.setTimestamp(buf, extensionOffset + 1);
                return true;
            }
            logger.warn("An existing extension with ID " + id + " was found, but it doesn't look like abs-send-time: len=" + len);
            return true;
        }
        return false;
    }

    private void addExtension(RawPacket pkt) {
        byte[] extensionBytes = new byte[4];
        extensionBytes[0] = (byte)(this.extensionID << 4 | 2);
        this.setTimestamp(extensionBytes, 1);
        pkt.addExtension(extensionBytes, extensionBytes.length);
    }

    private void setTimestamp(byte[] buf, int off) {
        long ns = System.nanoTime();
        int fraction = (int)(ns % 1000000000L * 262144L / 1000000000L);
        int seconds = (int)(ns / 1000000000L % 64L);
        int timestamp = (seconds << 18 | fraction) & 0xFFFFFF;
        buf[off] = (byte)(timestamp >> 16);
        buf[off + 1] = (byte)(timestamp >> 8);
        buf[off + 2] = (byte)timestamp;
    }

    public void setExtensionID(int id) {
        this.extensionID = id;
    }
}

