/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.sendsidebandwidthestimation;

import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.jitsi.impl.neomedia.rtcp.RTCPREMBPacket;
import org.jitsi.impl.neomedia.rtp.RTCPPacketListenerAdapter;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.rtp.BandwidthEstimator;
import org.jitsi.util.Logger;

class SendSideBandwidthEstimation
extends RTCPPacketListenerAdapter
implements BandwidthEstimator {
    private static final int kBweIncreaseIntervalMs = 1000;
    private static final long kBweDecreaseIntervalMs = 300L;
    private static final int kDefaultMinBitrateBps = 10000;
    private static final int kDefaultMaxBitrateBps = 1000000000;
    private static final int kStartPhaseMs = 2000;
    private static final int kLimitNumPackets = 20;
    private static final Logger logger = Logger.getLogger(SendSideBandwidthEstimation.class);
    private long first_report_time_ms_ = -1L;
    private int lost_packets_since_last_loss_update_Q8_ = 0;
    private int expected_packets_since_last_loss_update_ = 0;
    private boolean has_decreased_since_last_fraction_loss_ = false;
    private int last_fraction_loss_ = 0;
    private long time_last_receiver_block_ms_ = -1L;
    private int min_bitrate_configured_ = 10000;
    private int max_bitrate_configured_ = 1000000000;
    private long time_last_decrease_ms_ = 0L;
    private long bwe_incoming_ = 0L;
    private long bitrate_;
    private Deque<Pair<Long>> min_bitrate_history_ = new LinkedList<Pair<Long>>();
    private final List<BandwidthEstimator.Listener> listeners = new LinkedList<BandwidthEstimator.Listener>();
    private final MediaStream mediaStream;

    SendSideBandwidthEstimation(MediaStream stream, long startBitrate) {
        this.mediaStream = stream;
        this.setBitrate(startBitrate);
    }

    private synchronized boolean isInStartPhase(long now) {
        return this.first_report_time_ms_ == -1L || now - this.first_report_time_ms_ < 2000L;
    }

    private synchronized long capBitrateToThresholds(long bitrate) {
        if (this.bwe_incoming_ > 0L && bitrate > this.bwe_incoming_) {
            bitrate = this.bwe_incoming_;
        }
        if (bitrate > (long)this.max_bitrate_configured_) {
            bitrate = this.max_bitrate_configured_;
        }
        if (bitrate < (long)this.min_bitrate_configured_) {
            bitrate = this.min_bitrate_configured_;
        }
        return bitrate;
    }

    protected synchronized void updateEstimate(long now) {
        long bitrate = this.bitrate_;
        if (this.last_fraction_loss_ == 0 && this.isInStartPhase(now) && this.bwe_incoming_ > bitrate) {
            this.setBitrate(this.capBitrateToThresholds(this.bwe_incoming_));
            this.min_bitrate_history_.clear();
            this.min_bitrate_history_.addLast(new Pair<Long>(now, bitrate));
            return;
        }
        this.updateMinHistory(now);
        if (this.time_last_receiver_block_ms_ != -1L) {
            if (this.last_fraction_loss_ <= 5) {
                bitrate = (long)((double)((Long)this.min_bitrate_history_.getFirst().second).longValue() * 1.08 + 0.5);
                bitrate += 1000L;
            } else if (this.last_fraction_loss_ > 26 && !this.has_decreased_since_last_fraction_loss_ && now - this.time_last_decrease_ms_ >= 300L + this.getRtt()) {
                this.time_last_decrease_ms_ = now;
                bitrate = (long)((double)(bitrate * (long)(512 - this.last_fraction_loss_)) / 512.0);
                this.has_decreased_since_last_fraction_loss_ = true;
            }
        }
        this.setBitrate(this.capBitrateToThresholds(bitrate));
    }

    synchronized void updateReceiverBlock(long fraction_lost, long number_of_packets, long now) {
        if (this.first_report_time_ms_ == -1L) {
            this.first_report_time_ms_ = now;
        }
        if (number_of_packets > 0L) {
            long num_lost_packets_Q8 = fraction_lost * number_of_packets;
            this.lost_packets_since_last_loss_update_Q8_ = (int)((long)this.lost_packets_since_last_loss_update_Q8_ + num_lost_packets_Q8);
            this.expected_packets_since_last_loss_update_ = (int)((long)this.expected_packets_since_last_loss_update_ + number_of_packets);
            if (this.expected_packets_since_last_loss_update_ < 20) {
                return;
            }
            this.has_decreased_since_last_fraction_loss_ = false;
            this.last_fraction_loss_ = this.lost_packets_since_last_loss_update_Q8_ / this.expected_packets_since_last_loss_update_;
            this.lost_packets_since_last_loss_update_Q8_ = 0;
            this.expected_packets_since_last_loss_update_ = 0;
        }
        this.time_last_receiver_block_ms_ = now;
        this.updateEstimate(now);
    }

    private synchronized void updateMinHistory(long now_ms) {
        while (!this.min_bitrate_history_.isEmpty() && now_ms - (Long)this.min_bitrate_history_.getFirst().first + 1L > 1000L) {
            this.min_bitrate_history_.removeFirst();
        }
        while (!this.min_bitrate_history_.isEmpty() && this.bitrate_ <= (Long)this.min_bitrate_history_.getLast().second) {
            this.min_bitrate_history_.removeLast();
        }
        this.min_bitrate_history_.addLast(new Pair<Long>(now_ms, this.bitrate_));
    }

    private synchronized void updateReceiverEstimate(long bandwidth) {
        this.bwe_incoming_ = bandwidth;
        this.setBitrate(this.capBitrateToThresholds(this.bitrate_));
    }

    synchronized void setMinMaxBitrate(int min_bitrate, int max_bitrate) {
        this.min_bitrate_configured_ = Math.max(min_bitrate, 10000);
        this.max_bitrate_configured_ = max_bitrate > 0 ? Math.max(this.min_bitrate_configured_, max_bitrate) : 1000000000;
    }

    private synchronized void setBitrate(long newValue) {
        long oldValue = this.bitrate_;
        this.bitrate_ = newValue;
        if (oldValue != this.bitrate_) {
            this.fireBandwidthEstimationChanged(oldValue, newValue);
        }
    }

    @Override
    public long getLatestEstimate() {
        return this.bitrate_;
    }

    @Override
    public long getLatestREMB() {
        return this.bwe_incoming_;
    }

    @Override
    public int getLatestFractionLoss() {
        return this.last_fraction_loss_;
    }

    @Override
    public synchronized void addListener(BandwidthEstimator.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeListener(BandwidthEstimator.Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void rembReceived(RTCPREMBPacket remb) {
        this.updateReceiverEstimate(remb.getBitrate());
    }

    private synchronized long getRtt() {
        long rtt = this.mediaStream.getMediaStreamStats().getSendStats().getRtt();
        if (rtt < 0L || rtt > 1000L) {
            logger.warn("RTT not calculated, or has a suspiciously high value (" + rtt + "). Using the default of 100ms.");
            rtt = 100L;
        }
        return rtt;
    }

    private synchronized void fireBandwidthEstimationChanged(long oldValue, long newValue) {
        for (BandwidthEstimator.Listener listener : this.listeners) {
            listener.bandwidthEstimationChanged(newValue);
        }
    }

    private class Pair<T> {
        T first;
        T second;

        Pair(T a, T b) {
            this.first = a;
            this.second = b;
        }
    }
}

