/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtcp;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPFBPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPHeaderUtils;
import org.jitsi.impl.neomedia.rtcp.RTCPPacketParserEx;
import org.jitsi.service.neomedia.ByteArrayBuffer;

public class NACKPacket
extends RTCPFBPacket {
    public static final int FMT = 1;
    private Collection<Integer> lostPackets = null;

    public NACKPacket(RTCPCompoundPacket base) {
        super(base);
    }

    public NACKPacket(long senderSSRC, long sourceSSRC, Collection<Integer> lostPackets) {
        super(1, 205, senderSSRC, sourceSSRC);
        LinkedList<Integer> sorted = new LinkedList<Integer>(lostPackets);
        Collections.sort(sorted);
        LinkedList<byte[]> nackList = new LinkedList<byte[]>();
        int currentPid = -1;
        byte[] currentNack = null;
        Iterator iterator = sorted.iterator();
        while (iterator.hasNext()) {
            int seq = (Integer)iterator.next();
            if (currentPid == -1 || currentPid + 16 <= seq) {
                currentPid = seq;
                currentNack = new byte[]{(byte)((seq & 0xFF00) >> 8), (byte)(seq & 0xFF), 0, 0};
                nackList.add(currentNack);
                continue;
            }
            int diff = seq - currentPid;
            if (diff <= 8) {
                currentNack[3] = (byte)(currentNack[3] | (byte)(1 << diff - 1));
                continue;
            }
            currentNack[2] = (byte)(currentNack[2] | (byte)(1 << diff - 8 - 1));
        }
        this.fci = new byte[nackList.size() * 4];
        for (int i = 0; i < nackList.size(); ++i) {
            System.arraycopy(nackList.get(i), 0, this.fci, i * 4, 4);
        }
        this.lostPackets = sorted;
    }

    public static boolean isNACKPacket(ByteArrayBuffer baf) {
        int rc = RTCPHeaderUtils.getReportCount(baf);
        return NACKPacket.isRTPFBPacket(baf) && rc == 1;
    }

    public static Collection<Integer> getLostPackets(ByteArrayBuffer next) {
        LinkedList<Integer> lostPackets = new LinkedList<Integer>();
        ByteArrayBuffer fciBuffer = NACKPacket.getFCI(next);
        if (fciBuffer == null) {
            return lostPackets;
        }
        byte[] fci = fciBuffer.getBuffer();
        int off = fciBuffer.getOffset();
        int len = fciBuffer.getLength();
        for (int i = 0; i < len / 4; ++i) {
            int j;
            int pid = (0xFF & fci[off + i * 4 + 0]) << 8 | 0xFF & fci[off + i * 4 + 1];
            lostPackets.add(pid);
            for (j = 0; j < 8; ++j) {
                if (0 == (fci[off + i * 4 + 2] & 1 << j)) continue;
                lostPackets.add((pid + 1 + 8 + j) % 65536);
            }
            for (j = 0; j < 8; ++j) {
                if (0 == (fci[off + i * 4 + 3] & 1 << j)) continue;
                lostPackets.add((pid + 1 + j) % 65536);
            }
        }
        return lostPackets;
    }

    public synchronized Collection<Integer> getLostPackets() {
        if (this.lostPackets == null) {
            this.lostPackets = NACKPacket.getLostPackets(new RawPacket(this.fci, 0, this.fci.length));
        }
        return this.lostPackets;
    }

    private void writeSsrc(DataOutputStream dataOutputStream, long ssrc) throws IOException {
        dataOutputStream.writeByte((byte)(ssrc >> 24));
        dataOutputStream.writeByte((byte)(ssrc >> 16 & 0xFFL));
        dataOutputStream.writeByte((byte)(ssrc >> 8 & 0xFFL));
        dataOutputStream.writeByte((byte)(ssrc & 0xFFL));
    }

    @Override
    public void assemble(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeByte(-127);
        dataoutputstream.writeByte(-51);
        dataoutputstream.writeShort(2 + this.fci.length / 4);
        this.writeSsrc(dataoutputstream, this.senderSSRC);
        this.writeSsrc(dataoutputstream, this.sourceSSRC);
        dataoutputstream.write(this.fci);
    }

    @Override
    public String toString() {
        return "RTCP NACK packet; packet sender: " + this.senderSSRC + "; media sources: " + this.sourceSSRC + "; NACK entries: " + (this.fci == null ? "none" : Integer.valueOf(this.fci.length / 4)) + "; lost packets: " + (this.lostPackets == null ? "none" : Arrays.toString(this.lostPackets.toArray()));
    }

    public RawPacket toRawPacket() throws IOException {
        return RTCPPacketParserEx.toRawPacket(this);
    }
}

