/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.spellcheck;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import net.java.sip.communicator.plugin.spellcheck.SpellCheckActivator;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.ServiceReference;

public class Resources {
    private static Logger logger = Logger.getLogger(Resources.class);
    private static ResourceManagementService resourceService;
    private static final String FLAG_PATH = "resources/images/plugin/spellcheck/flags/";
    public static final String PLUGIN_ICON = "plugin.spellcheck.PLUGIN_ICON";
    public static final String ADD_WORD_ICON = "plugin.spellcheck.ADD_WORD_ICON";
    public static final String PERSONAL_DICTIONARY = "plugin.spellcheck.PERSONAL_DIR";
    public static final String WORD_INCLUDE = "plugin.spellcheck.WORD_INCLUDE";
    public static final String WORD_EXCLUDE = "plugin.spellcheck.WORD_EXCLUDE";

    public static String getString(String key) {
        return Resources.getResources().getI18NString(key);
    }

    public static ImageIcon getImage(String imageID) {
        return Resources.getResources().getImage(imageID);
    }

    public static ImageIcon getFlagImage(String resource) throws IOException {
        String path = FLAG_PATH + resource + ".png";
        InputStream input = Resources.getResources().getImageInputStreamForPath(path);
        if (input == null) {
            logger.info((Object)("Unable to obtain flag image for path: " + path));
        }
        BufferedImage image = ImageIO.read(input);
        return new ImageIcon(image);
    }

    public static byte[] getImageInBytes(String imageID) {
        return Resources.getResources().getImageInBytes(imageID);
    }

    public static ResourceManagementService getResources() {
        if (resourceService != null) {
            return resourceService;
        }
        ServiceReference configServiceRef = SpellCheckActivator.bundleContext.getServiceReference(ResourceManagementService.class.getName());
        resourceService = (ResourceManagementService)SpellCheckActivator.bundleContext.getService(configServiceRef);
        return resourceService;
    }
}

