/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.history;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import net.java.sip.communicator.impl.history.HistoryImpl;
import net.java.sip.communicator.impl.history.OrderedQueryResultSet;
import net.java.sip.communicator.service.history.HistoryReader;
import net.java.sip.communicator.service.history.QueryResultSet;
import net.java.sip.communicator.service.history.event.HistorySearchProgressListener;
import net.java.sip.communicator.service.history.event.ProgressEvent;
import net.java.sip.communicator.service.history.records.HistoryRecord;
import org.apache.commons.lang3.StringEscapeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HistoryReaderImpl
implements HistoryReader {
    private HistoryImpl historyImpl;
    private Vector<HistorySearchProgressListener> progressListeners = new Vector();
    private static String REGEXP_END = ".*$";
    private static String REGEXP_SENSITIVE_START = "(?s)^.*";
    private static String REGEXP_INSENSITIVE_START = "(?si)^.*";

    protected HistoryReaderImpl(HistoryImpl historyImpl) {
        this.historyImpl = historyImpl;
    }

    @Override
    public synchronized QueryResultSet<HistoryRecord> findByStartDate(Date startDate) throws RuntimeException {
        return this.find(startDate, null, null, null, false);
    }

    @Override
    public synchronized QueryResultSet<HistoryRecord> findByEndDate(Date endDate) throws RuntimeException {
        return this.find(null, endDate, null, null, false);
    }

    @Override
    public synchronized QueryResultSet<HistoryRecord> findByPeriod(Date startDate, Date endDate) throws RuntimeException {
        return this.find(startDate, endDate, null, null, false);
    }

    @Override
    public synchronized QueryResultSet<HistoryRecord> findByKeyword(String keyword, String field) throws RuntimeException {
        return this.findByKeywords(new String[]{keyword}, field);
    }

    @Override
    public synchronized QueryResultSet<HistoryRecord> findByKeywords(String[] keywords, String field) throws RuntimeException {
        return this.find(null, null, keywords, field, false);
    }

    @Override
    public synchronized QueryResultSet<HistoryRecord> findByPeriod(Date startDate, Date endDate, String[] keywords, String field) throws UnsupportedOperationException {
        return this.find(startDate, endDate, keywords, field, false);
    }

    @Override
    public synchronized QueryResultSet<HistoryRecord> findLast(int count) throws RuntimeException {
        return this.findLast(count, null, null, false);
    }

    @Override
    public synchronized QueryResultSet<HistoryRecord> findLast(int count, String[] keywords, String field, boolean caseSensitive) throws RuntimeException {
        Vector<String> filelist = HistoryReaderImpl.filterFilesByDate(this.historyImpl.getFileList(), null, null);
        TreeSet<HistoryRecord> result = new TreeSet<HistoryRecord>(new HistoryRecordComparator());
        int leftCount = count;
        int currentFile = filelist.size() - 1;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        while (leftCount > 0 && currentFile >= 0) {
            Document doc = this.historyImpl.getDocumentForFile(filelist.get(currentFile));
            if (doc == null) {
                --currentFile;
                continue;
            }
            ArrayList<Node> nodes = new ArrayList<Node>();
            NodeList nodesList = doc.getElementsByTagName("record");
            for (int i = 0; i < nodesList.getLength(); ++i) {
                nodes.add(nodesList.item(i));
            }
            List<Node> lNodes = null;
            if (nodes.size() > leftCount) {
                lNodes = nodes.subList(nodes.size() - leftCount, nodes.size());
                leftCount = 0;
            } else {
                lNodes = nodes;
                leftCount -= nodes.size();
            }
            for (Node node : lNodes) {
                HistoryRecord record;
                Date timestamp;
                NodeList propertyNodes = node.getChildNodes();
                String ts = node.getAttributes().getNamedItem("timestamp").getNodeValue();
                try {
                    timestamp = sdf.parse(ts);
                }
                catch (ParseException e) {
                    timestamp = new Date(Long.parseLong(ts));
                }
                if ((record = HistoryReaderImpl.filterByKeyword(propertyNodes, timestamp, keywords, field, caseSensitive)) == null) continue;
                result.add(record);
            }
            --currentFile;
        }
        return new OrderedQueryResultSet<HistoryRecord>(result);
    }

    @Override
    public synchronized QueryResultSet<HistoryRecord> findByKeyword(String keyword, String field, boolean caseSensitive) throws RuntimeException {
        return this.findByKeywords(new String[]{keyword}, field, caseSensitive);
    }

    @Override
    public synchronized QueryResultSet<HistoryRecord> findByKeywords(String[] keywords, String field, boolean caseSensitive) throws RuntimeException {
        return this.find(null, null, keywords, field, caseSensitive);
    }

    @Override
    public synchronized QueryResultSet<HistoryRecord> findByPeriod(Date startDate, Date endDate, String[] keywords, String field, boolean caseSensitive) throws UnsupportedOperationException {
        return this.find(startDate, endDate, keywords, field, caseSensitive);
    }

    @Override
    public QueryResultSet<HistoryRecord> findFirstRecordsAfter(Date date, int count) throws RuntimeException {
        TreeSet<HistoryRecord> result = new TreeSet<HistoryRecord>(new HistoryRecordComparator());
        Vector<String> filelist = HistoryReaderImpl.filterFilesByDate(this.historyImpl.getFileList(), date, null);
        int leftCount = count;
        int currentFile = 0;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        while (leftCount > 0 && currentFile < filelist.size()) {
            Document doc = this.historyImpl.getDocumentForFile(filelist.get(currentFile));
            if (doc == null) {
                ++currentFile;
                continue;
            }
            NodeList nodes = doc.getElementsByTagName("record");
            for (int i = 0; i < nodes.getLength() && leftCount > 0; ++i) {
                Date timestamp;
                Node node = nodes.item(i);
                NodeList propertyNodes = node.getChildNodes();
                String ts = node.getAttributes().getNamedItem("timestamp").getNodeValue();
                try {
                    timestamp = sdf.parse(ts);
                }
                catch (ParseException e) {
                    timestamp = new Date(Long.parseLong(ts));
                }
                if (!HistoryReaderImpl.isInPeriod(timestamp, date, null)) continue;
                ArrayList<String> nameVals = new ArrayList<String>();
                boolean isRecordOK = true;
                int len = propertyNodes.getLength();
                for (int j = 0; j < len; ++j) {
                    Node propertyNode = propertyNodes.item(j);
                    if (propertyNode.getNodeType() != 1) continue;
                    Node nodeValue = propertyNode.getFirstChild();
                    if (nodeValue != null) {
                        nameVals.add(propertyNode.getNodeName());
                        nameVals.add(nodeValue.getNodeValue());
                        continue;
                    }
                    isRecordOK = false;
                }
                if (!isRecordOK) continue;
                String[] propertyNames = new String[nameVals.size() / 2];
                String[] propertyValues = new String[propertyNames.length];
                for (int j = 0; j < propertyNames.length; ++j) {
                    propertyNames[j] = (String)nameVals.get(j * 2);
                    propertyValues[j] = (String)nameVals.get(j * 2 + 1);
                }
                HistoryRecord record = new HistoryRecord(propertyNames, propertyValues, timestamp);
                result.add(record);
                --leftCount;
            }
            ++currentFile;
        }
        return new OrderedQueryResultSet<HistoryRecord>(result);
    }

    @Override
    public QueryResultSet<HistoryRecord> findLastRecordsBefore(Date date, int count) throws RuntimeException {
        Vector<String> filelist = HistoryReaderImpl.filterFilesByDate(this.historyImpl.getFileList(), null, date);
        TreeSet<HistoryRecord> result = new TreeSet<HistoryRecord>(new HistoryRecordComparator());
        int leftCount = count;
        int currentFile = filelist.size() - 1;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        while (leftCount > 0 && currentFile >= 0) {
            Document doc = this.historyImpl.getDocumentForFile(filelist.get(currentFile));
            if (doc == null) {
                --currentFile;
                continue;
            }
            NodeList nodes = doc.getElementsByTagName("record");
            for (int i = nodes.getLength() - 1; i >= 0 && leftCount > 0; --i) {
                Date timestamp;
                Node node = nodes.item(i);
                NodeList propertyNodes = node.getChildNodes();
                String ts = node.getAttributes().getNamedItem("timestamp").getNodeValue();
                try {
                    timestamp = sdf.parse(ts);
                }
                catch (ParseException e) {
                    timestamp = new Date(Long.parseLong(ts));
                }
                if (!HistoryReaderImpl.isInPeriod(timestamp, null, date)) continue;
                ArrayList<String> nameVals = new ArrayList<String>();
                boolean isRecordOK = true;
                int len = propertyNodes.getLength();
                for (int j = 0; j < len; ++j) {
                    Node propertyNode = propertyNodes.item(j);
                    if (propertyNode.getNodeType() != 1) continue;
                    Node nodeValue = propertyNode.getFirstChild();
                    if (nodeValue != null) {
                        nameVals.add(propertyNode.getNodeName());
                        nameVals.add(nodeValue.getNodeValue());
                        continue;
                    }
                    isRecordOK = false;
                }
                if (!isRecordOK) continue;
                String[] propertyNames = new String[nameVals.size() / 2];
                String[] propertyValues = new String[propertyNames.length];
                for (int j = 0; j < propertyNames.length; ++j) {
                    propertyNames[j] = (String)nameVals.get(j * 2);
                    propertyValues[j] = (String)nameVals.get(j * 2 + 1);
                }
                HistoryRecord record = new HistoryRecord(propertyNames, propertyValues, timestamp);
                result.add(record);
                --leftCount;
            }
            --currentFile;
        }
        return new OrderedQueryResultSet<HistoryRecord>(result);
    }

    private QueryResultSet<HistoryRecord> find(Date startDate, Date endDate, String[] keywords, String field, boolean caseSensitive) {
        TreeSet<HistoryRecord> result = new TreeSet<HistoryRecord>(new HistoryRecordComparator());
        Vector<String> filelist = HistoryReaderImpl.filterFilesByDate(this.historyImpl.getFileList(), startDate, endDate);
        double currentProgress = 0.0;
        double fileProgressStep = 1000.0;
        if (filelist.size() != 0) {
            fileProgressStep = 1000 / filelist.size();
        }
        this.fireProgressStateChanged(startDate, endDate, keywords, 0);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        for (String filename : filelist) {
            Document doc = this.historyImpl.getDocumentForFile(filename);
            if (doc == null) continue;
            NodeList nodes = doc.getElementsByTagName("record");
            double nodesProgressStep = fileProgressStep;
            if (nodes.getLength() != 0) {
                nodesProgressStep = fileProgressStep / (double)nodes.getLength();
            }
            for (int i = 0; i < nodes.getLength(); ++i) {
                NodeList propertyNodes;
                HistoryRecord record;
                Date timestamp;
                Node node = nodes.item(i);
                String ts = node.getAttributes().getNamedItem("timestamp").getNodeValue();
                try {
                    timestamp = sdf.parse(ts);
                }
                catch (ParseException e) {
                    timestamp = new Date(Long.parseLong(ts));
                }
                if (HistoryReaderImpl.isInPeriod(timestamp, startDate, endDate) && (record = HistoryReaderImpl.filterByKeyword(propertyNodes = node.getChildNodes(), timestamp, keywords, field, caseSensitive)) != null) {
                    result.add(record);
                }
                this.fireProgressStateChanged(startDate, endDate, keywords, (int)(currentProgress += nodesProgressStep));
            }
        }
        if ((int)currentProgress < 1000) {
            this.fireProgressStateChanged(startDate, endDate, keywords, 1000);
        }
        return new OrderedQueryResultSet<HistoryRecord>(result);
    }

    static boolean isInPeriod(Date timestamp, Date startDate, Date endDate) {
        Long tsLong = timestamp.getTime();
        Long startLong = startDate == null ? Long.valueOf(Long.MIN_VALUE) : Long.valueOf(startDate.getTime());
        Long endLong = endDate == null ? Long.valueOf(Long.MAX_VALUE) : Long.valueOf(endDate.getTime());
        return startLong <= tsLong && tsLong < endLong;
    }

    static HistoryRecord filterByKeyword(NodeList propertyNodes, Date timestamp, String[] keywords, String field, boolean caseSensitive) {
        ArrayList<String> nameVals = new ArrayList<String>();
        int len = propertyNodes.getLength();
        boolean targetNodeFound = false;
        for (int j = 0; j < len; ++j) {
            Node propertyNode = propertyNodes.item(j);
            if (propertyNode.getNodeType() != 1) continue;
            String nodeName = propertyNode.getNodeName();
            Node nestedNode = propertyNode.getFirstChild();
            if (nestedNode == null) continue;
            String nodeValue = nestedNode.getNodeValue();
            nodeValue = StringEscapeUtils.unescapeXml((String)nodeValue);
            if (field != null && field.equals(nodeName)) {
                targetNodeFound = true;
                if (!HistoryReaderImpl.matchKeyword(nodeValue, keywords, caseSensitive)) {
                    return null;
                }
            }
            nameVals.add(nodeName);
            nameVals.add(nodeValue);
        }
        if (keywords != null && keywords.length > 0 && !targetNodeFound) {
            return null;
        }
        String[] propertyNames = new String[nameVals.size() / 2];
        String[] propertyValues = new String[propertyNames.length];
        for (int j = 0; j < propertyNames.length; ++j) {
            propertyNames[j] = (String)nameVals.get(j * 2);
            propertyValues[j] = (String)nameVals.get(j * 2 + 1);
        }
        return new HistoryRecord(propertyNames, propertyValues, timestamp);
    }

    static boolean matchKeyword(String value, String[] keywords, boolean caseSensitive) {
        if (keywords != null) {
            String regexpStart = null;
            regexpStart = caseSensitive ? REGEXP_SENSITIVE_START : REGEXP_INSENSITIVE_START;
            for (int i = 0; i < keywords.length; ++i) {
                if (value.matches(regexpStart + Pattern.quote(keywords[i]) + REGEXP_END)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    static Vector<String> filterFilesByDate(Iterator<String> filelist, Date startDate, Date endDate) {
        return HistoryReaderImpl.filterFilesByDate(filelist, startDate, endDate, false);
    }

    static Vector<String> filterFilesByDate(Iterator<String> filelist, Date startDate, Date endDate, final boolean reverseOrder) {
        NavigableSet<Long> setBeforeTheInterval;
        if (startDate == null && endDate == null) {
            Vector<String> result = new Vector<String>();
            while (filelist.hasNext()) {
                result.add(filelist.next());
            }
            Collections.sort(result, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (reverseOrder) {
                        return o2.compareTo(o1);
                    }
                    return o1.compareTo(o2);
                }
            });
            return result;
        }
        TreeSet<Long> files = new TreeSet<Long>();
        while (filelist.hasNext()) {
            String filename = filelist.next();
            files.add(Long.parseLong(filename.substring(0, filename.length() - 4)));
        }
        TreeSet<Long> resultAsLong = new TreeSet<Long>();
        if (files.size() == 0) {
            return new Vector<String>();
        }
        Long startLong = startDate == null ? Long.valueOf(Long.MIN_VALUE) : Long.valueOf(startDate.getTime());
        Long endLong = endDate == null ? Long.valueOf(Long.MAX_VALUE) : Long.valueOf(endDate.getTime());
        for (Long f : files) {
            if (startLong > f || f > endLong) continue;
            resultAsLong.add(f);
        }
        if (!files.isEmpty() && (Long)files.first() <= startLong && !(setBeforeTheInterval = files.subSet((Long)files.first(), true, startLong, true)).isEmpty()) {
            resultAsLong.add((Long)setBeforeTheInterval.last());
        }
        Vector<String> result = new Vector<String>();
        for (Long item : resultAsLong) {
            result.add(item.toString() + ".xml");
        }
        Collections.sort(result, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (reverseOrder) {
                    return o2.compareTo(o1);
                }
                return o1.compareTo(o2);
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProgressStateChanged(Date startDate, Date endDate, String[] keywords, int progress) {
        ProgressEvent event = new ProgressEvent(this, startDate, endDate, keywords, progress);
        Vector<HistorySearchProgressListener> vector = this.progressListeners;
        synchronized (vector) {
            for (HistorySearchProgressListener item : this.progressListeners) {
                item.progressChanged(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSearchProgressListener(HistorySearchProgressListener listener) {
        Vector<HistorySearchProgressListener> vector = this.progressListeners;
        synchronized (vector) {
            this.progressListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSearchProgressListener(HistorySearchProgressListener listener) {
        Vector<HistorySearchProgressListener> vector = this.progressListeners;
        synchronized (vector) {
            this.progressListeners.remove(listener);
        }
    }

    @Override
    public int countRecords() throws UnsupportedOperationException {
        int result = 0;
        String lastFile = null;
        Iterator<String> filelistIter = this.historyImpl.getFileList();
        while (filelistIter.hasNext()) {
            lastFile = filelistIter.next();
            result += 150;
        }
        if (lastFile == null) {
            return result;
        }
        Document doc = this.historyImpl.getDocumentForFile(lastFile);
        if (doc == null) {
            return result;
        }
        NodeList nodes = doc.getElementsByTagName("record");
        return result += nodes.getLength();
    }

    private static class HistoryRecordComparator
    implements Comparator<HistoryRecord> {
        private HistoryRecordComparator() {
        }

        @Override
        public int compare(HistoryRecord h1, HistoryRecord h2) {
            return h1.getTimestamp().compareTo(h2.getTimestamp());
        }
    }
}

