/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.systray;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import net.java.sip.communicator.service.systray.PopupMessage;
import net.java.sip.communicator.service.systray.PopupMessageHandler;
import net.java.sip.communicator.service.systray.SystrayService;
import net.java.sip.communicator.service.systray.event.SystrayPopupMessageListener;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public abstract class AbstractSystrayService
implements SystrayService {
    private final Logger logger = Logger.getLogger(AbstractSystrayService.class);
    private final BundleContext bundleContext;
    private PopupMessageHandler activePopupHandler;
    private final Hashtable<String, PopupMessageHandler> popupHandlerSet = new Hashtable();
    private List<SystrayPopupMessageListener> earlyAddedListeners = null;

    public AbstractSystrayService(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected void addPopupHandler(PopupMessageHandler handler) {
        this.popupHandlerSet.put(handler.getClass().getName(), handler);
    }

    protected void removePopupHandler(PopupMessageHandler handler) {
        this.popupHandlerSet.remove(handler.getClass().getName());
    }

    protected boolean containsHandler(String handlerClass) {
        return this.popupHandlerSet.contains(handlerClass);
    }

    protected PopupMessageHandler getActivePopupHandler() {
        return this.activePopupHandler;
    }

    @Override
    public void showPopupMessage(PopupMessage popupMessage) {
        if (this.activePopupHandler != null) {
            this.activePopupHandler.showPopupMessage(popupMessage);
        }
    }

    @Override
    public void setNotificationCount(int count) {
    }

    @Override
    public void addPopupMessageListener(SystrayPopupMessageListener listener) {
        if (this.activePopupHandler != null) {
            this.activePopupHandler.addPopupMessageListener(listener);
        } else {
            if (this.earlyAddedListeners == null) {
                this.earlyAddedListeners = new ArrayList<SystrayPopupMessageListener>();
            }
            this.earlyAddedListeners.add(listener);
        }
    }

    @Override
    public void removePopupMessageListener(SystrayPopupMessageListener listener) {
        if (this.activePopupHandler != null) {
            this.activePopupHandler.removePopupMessageListener(listener);
        }
    }

    @Override
    public PopupMessageHandler setActivePopupMessageHandler(PopupMessageHandler newHandler) {
        PopupMessageHandler oldHandler = this.activePopupHandler;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("setting the following popup handler as active: " + newHandler));
        }
        this.activePopupHandler = newHandler;
        if (this.earlyAddedListeners != null) {
            for (SystrayPopupMessageListener l : this.earlyAddedListeners) {
                this.activePopupHandler.addPopupMessageListener(l);
            }
            this.earlyAddedListeners.clear();
            this.earlyAddedListeners = null;
        }
        return oldHandler;
    }

    @Override
    public PopupMessageHandler getActivePopupMessageHandler() {
        return this.activePopupHandler;
    }

    @Override
    public void selectBestPopupMessageHandler() {
        PopupMessageHandler preferredHandler = null;
        int highestPrefIndex = 0;
        if (!this.popupHandlerSet.isEmpty()) {
            Enumeration<String> keys = this.popupHandlerSet.keys();
            while (keys.hasMoreElements()) {
                String handlerName = keys.nextElement();
                PopupMessageHandler h = this.popupHandlerSet.get(handlerName);
                if (h.getPreferenceIndex() <= highestPrefIndex) continue;
                highestPrefIndex = h.getPreferenceIndex();
                preferredHandler = h;
            }
            this.setActivePopupMessageHandler(preferredHandler);
        }
    }

    protected void initHandlers() {
        try {
            this.bundleContext.addServiceListener((ServiceListener)new ServiceListenerImpl(), "(objectclass=" + PopupMessageHandler.class.getName() + ")");
        }
        catch (Exception e) {
            this.logger.warn((Object)e);
        }
        Collection handlerRefs = ServiceUtils.getServiceReferences((BundleContext)this.bundleContext, PopupMessageHandler.class);
        if (!handlerRefs.isEmpty()) {
            ConfigurationService config = (ConfigurationService)ServiceUtils.getService((BundleContext)this.bundleContext, ConfigurationService.class);
            String configuredHandler = config.getString("systray.POPUP_HANDLER");
            for (ServiceReference handlerRef : handlerRefs) {
                PopupMessageHandler handler = (PopupMessageHandler)this.bundleContext.getService(handlerRef);
                String handlerName = handler.getClass().getName();
                if (this.containsHandler(handlerName)) continue;
                this.addPopupHandler(handler);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("added the following popup handler : " + handler));
                }
                if (configuredHandler == null || !configuredHandler.equals(handler.getClass().getName())) continue;
                this.setActivePopupMessageHandler(handler);
            }
            if (configuredHandler == null) {
                this.selectBestPopupMessageHandler();
            }
        }
    }

    private class ServiceListenerImpl
    implements ServiceListener {
        private ServiceListenerImpl() {
        }

        public void serviceChanged(ServiceEvent serviceEvent) {
            block13: {
                try {
                    Object service = AbstractSystrayService.this.bundleContext.getService(serviceEvent.getServiceReference());
                    if (!(service instanceof PopupMessageHandler)) {
                        return;
                    }
                    PopupMessageHandler handler = (PopupMessageHandler)AbstractSystrayService.this.bundleContext.getService(serviceEvent.getServiceReference());
                    if (serviceEvent.getType() == 1) {
                        if (!AbstractSystrayService.this.containsHandler(handler.getClass().getName())) {
                            if (AbstractSystrayService.this.logger.isInfoEnabled()) {
                                AbstractSystrayService.this.logger.info((Object)("adding the following popup handler : " + handler));
                            }
                            AbstractSystrayService.this.addPopupHandler(handler);
                        } else {
                            AbstractSystrayService.this.logger.warn((Object)("the following popup handler has not been added since it is already known : " + handler));
                        }
                        ConfigurationService cfg = (ConfigurationService)ServiceUtils.getService((BundleContext)AbstractSystrayService.this.bundleContext, ConfigurationService.class);
                        String configuredHandler = cfg.getString("systray.POPUP_HANDLER");
                        if (configuredHandler == null && (AbstractSystrayService.this.getActivePopupHandler() == null || handler.getPreferenceIndex() > AbstractSystrayService.this.getActivePopupHandler().getPreferenceIndex())) {
                            AbstractSystrayService.this.setActivePopupMessageHandler(handler);
                        }
                        if (configuredHandler != null && configuredHandler.equals(handler.getClass().getName())) {
                            AbstractSystrayService.this.setActivePopupMessageHandler(handler);
                        }
                    } else if (serviceEvent.getType() == 4) {
                        if (AbstractSystrayService.this.logger.isInfoEnabled()) {
                            AbstractSystrayService.this.logger.info((Object)("removing the following popup handler : " + handler));
                        }
                        AbstractSystrayService.this.removePopupHandler(handler);
                        PopupMessageHandler activeHandler = AbstractSystrayService.this.getActivePopupHandler();
                        if (activeHandler == handler) {
                            AbstractSystrayService.this.setActivePopupMessageHandler(null);
                            AbstractSystrayService.this.selectBestPopupMessageHandler();
                        }
                    }
                }
                catch (IllegalStateException e) {
                    if (!AbstractSystrayService.this.logger.isDebugEnabled()) break block13;
                    AbstractSystrayService.this.logger.debug((Object)e);
                }
            }
        }
    }
}

