/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar;

import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.ExtraInfoData;
import net.kano.joscar.snaccmd.FullUserInfo;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.ExternalServiceManager;
import net.kano.joustsim.oscar.OpenedServiceListener;
import net.kano.joustsim.oscar.oscar.service.Service;
import net.kano.joustsim.oscar.oscar.service.bos.MainBosService;
import net.kano.joustsim.oscar.oscar.service.bos.MainBosServiceListener;
import net.kano.joustsim.oscar.oscar.service.icon.IconServiceArbiter;

public class MyBuddyIconManager {
    private static final Logger LOGGER = Logger.getLogger(MyBuddyIconManager.class.getName());
    private AimConnection conn;
    private ByteBlock wantedIconData = null;
    private ExtraInfoData wantedIconHash = null;
    private MainBosServiceListener bosListener = new MainBosServiceListener(){

        @Override
        public void handleYourInfo(MainBosService service, FullUserInfo userInfo) {
        }

        @Override
        public void handleYourExtraInfo(List<ExtraInfoBlock> extraInfos) {
            for (ExtraInfoBlock block : extraInfos) {
                if (block.getType() != 1) continue;
                MyBuddyIconManager.this.handleMyIconBlock(block);
            }
        }
    };

    public MyBuddyIconManager(AimConnection connection) {
        this.conn = connection;
        this.conn.addOpenedServiceListener(new OpenedServiceListener(){

            @Override
            public void openedServices(AimConnection cocnn, Collection<? extends Service> services) {
                for (Service service : services) {
                    if (!(service instanceof MainBosService)) continue;
                    MainBosService bosService = (MainBosService)service;
                    bosService.addMainBosServiceListener(MyBuddyIconManager.this.bosListener);
                }
            }

            @Override
            public void closedServices(AimConnection conn, Collection<? extends Service> services) {
            }
        });
    }

    private void handleMyIconBlock(ExtraInfoBlock block) {
        ExtraInfoData hash = block.getExtraData();
        if (this.wantedIconData != null && this.wantedIconHash != null && hash.getData().equals(this.wantedIconHash.getData())) {
            if ((hash.getFlags() & 0x40) != 0) {
                if (this.wantedIconData == null) {
                    LOGGER.fine("Server asked us to upload icon for " + hash + " but we don't " + "want icon data");
                } else {
                    ExternalServiceManager externalServiceManager = this.conn.getExternalServiceManager();
                    IconServiceArbiter iconServiceArbiter = externalServiceManager.getIconServiceArbiter();
                    iconServiceArbiter.uploadIcon(this.wantedIconData);
                }
            } else {
                LOGGER.fine("Server doesn't want us to upload image " + hash.getData());
            }
        } else {
            LOGGER.fine("Ignoring obsolete icon upload request from server for " + hash);
        }
    }

    public void requestSetIconFromExtraInfoData(ExtraInfoData iconInfo) {
        this.wantedIconData = null;
        this.reallySetIcon(iconInfo);
    }

    public void requestSetIcon(ByteBlock iconData) {
        DefensiveTools.checkNull(iconData, "iconData");
        this.wantedIconData = iconData;
        ExtraInfoData iconInfo = this.conn.getBuddyIconTracker().addToCache(this.conn.getScreenname(), iconData);
        this.reallySetIcon(iconInfo);
    }

    public void requestClearIcon() {
        this.wantedIconData = null;
        this.reallySetIcon(new ExtraInfoData(0, ExtraInfoData.HASH_SPECIAL));
    }

    private void reallySetIcon(ExtraInfoData iconInfo) {
        DefensiveTools.checkNull(iconInfo, "iconInfo");
        this.wantedIconHash = iconInfo;
        this.conn.getSsiService().getBuddyIconItemManager().setIcon(iconInfo);
    }
}

