/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ssiitem;

import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.AbstractItemObj;
import net.kano.joscar.ssiitem.SsiItemObjectWithId;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

public class VisibilityItem
extends AbstractItemObj
implements SsiItemObjectWithId {
    public static final long MASK_SHOW_IDLE_TIME = 1024L;
    public static final long MASK_SHOW_TYPING = 0x400000L;
    public static final long MASK_DISABLE_RECENT_BUDDIES = 131072L;
    private static final int TYPE_VIS_MASK = 201;
    private static final String NAME_DEFAULT = "";
    private static final int GROUPID_DEFAULT = 0;
    private final int id;
    private long flags;

    public VisibilityItem(SsiItem item) {
        DefensiveTools.checkNull(item, "item");
        this.id = item.getId();
        ImmutableTlvChain chain = TlvTools.readChain(item.getData());
        Tlv visMaskTlv = chain.getLastTlv(201);
        if (visMaskTlv != null) {
            this.flags = visMaskTlv.getDataAsUInt();
            if (this.flags == -1L) {
                this.flags = 0L;
            }
        } else {
            this.flags = 0L;
        }
        MutableTlvChain extras = TlvTools.getMutableCopy(chain);
        extras.removeTlvs(new int[]{201});
        this.addExtraTlvs(extras);
    }

    public VisibilityItem(VisibilityItem other) {
        this(other.id, other.flags, other.copyExtraTlvs());
    }

    public VisibilityItem(int id, long flags) {
        this(id, flags, null);
    }

    public VisibilityItem(int id, long flags, TlvChain extraTlvs) {
        super(extraTlvs);
        DefensiveTools.checkRange(id, "id", 0);
        DefensiveTools.checkRange(flags, "flags", 0L);
        this.id = id;
        this.flags = flags;
    }

    public final int getId() {
        return this.id;
    }

    public final synchronized long getVisFlags() {
        return this.flags;
    }

    public final synchronized void setVisFlags(long flags) {
        this.flags = flags;
    }

    public synchronized SsiItem toSsiItem() {
        MutableTlvChain chain = TlvTools.createMutableChain();
        if (this.flags != 0L) {
            byte[] flagBytes = BinaryTools.getUInt(this.flags);
            ByteBlock flagsBlock = ByteBlock.wrap(flagBytes);
            chain.addTlv(new Tlv(201, flagsBlock));
        }
        return this.generateItem(NAME_DEFAULT, 0, this.id, 5, chain);
    }

    public synchronized String toString() {
        return "VisibilityItem: id=0x" + Integer.toHexString(this.id) + ", flags=0x" + Long.toHexString(this.flags);
    }
}

