/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.MiniRoomInfo;
import net.kano.joscar.snaccmd.conn.ConnCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class ServiceRequest
extends ConnCommand {
    private static final int TYPE_PARAM = 1;
    private static final int TYPE_KEY = 40;
    private final int family;
    private final MiniRoomInfo roomInfo;

    protected ServiceRequest(SnacPacket packet) {
        super(4);
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock snacData = packet.getData();
        this.family = BinaryTools.getUShort(snacData, 0);
        ByteBlock tlvBlock = snacData.subBlock(2);
        ImmutableTlvChain chatChain = TlvTools.readChain(tlvBlock);
        Tlv chatInfoTlv = chatChain.getLastTlv(1);
        if (chatInfoTlv != null) {
            ByteBlock chatBlock = chatInfoTlv.getData();
            this.roomInfo = MiniRoomInfo.readMiniRoomInfo(chatBlock);
        } else {
            this.roomInfo = null;
        }
    }

    public ServiceRequest(int snacFamily) {
        this(snacFamily, null);
    }

    public ServiceRequest(MiniRoomInfo roomInfo) {
        this(14, roomInfo);
    }

    public ServiceRequest(int snacFamily, MiniRoomInfo roomInfo) {
        super(4);
        DefensiveTools.checkRange(snacFamily, "snacFamily", 0);
        this.family = snacFamily;
        this.roomInfo = roomInfo;
    }

    public final int getRequestedFamily() {
        return this.family;
    }

    public final MiniRoomInfo getRoomInfo() {
        return this.roomInfo;
    }

    public void writeData(OutputStream out) throws IOException {
        BinaryTools.writeUShort(out, this.family);
        if (this.roomInfo != null) {
            ByteBlock roomInfoBlock = ByteBlock.createByteBlock(this.roomInfo);
            new Tlv(1, roomInfoBlock).write(out);
        }
    }

    public String toString() {
        return "ServiceRequest for family 0x" + Integer.toHexString(this.family) + (this.roomInfo == null ? "" : " (chat room: <" + this.roomInfo + ">)");
    }
}

