/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.getfile;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.rvcmd.AbstractRequestRvCmd;
import net.kano.joscar.rvcmd.ConnectionRequestRvCmd;
import net.kano.joscar.rvcmd.RvConnectionInfo;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public class GetFileReqRvCmd
extends AbstractRequestRvCmd
implements ConnectionRequestRvCmd {
    public static final String CHARSET_DEFAULT = "us-ascii";
    public static final int CODE_DEFAULT = 18;
    public static final int PROTOVERSION_DEFAULT = 2;
    public static final int PROTOVERSION_OLD = 1;
    public static final long FLAG_EXPAND_DYNAMIC = 1L;
    public static final ByteBlock EXTRABLOCK_DEFAULT = ByteBlock.wrap(new byte[]{0});
    private static final int TYPE_CHARSET = 10002;
    private final RvConnectionInfo connInfo;
    private final String charset;
    private final int code;
    private final int protoVersion;
    private final long flags;
    private final ByteBlock extraBlock;

    public GetFileReqRvCmd(RecvRvIcbm icbm) {
        super(icbm);
        TlvChain chain = this.getRvTlvs();
        this.connInfo = RvConnectionInfo.readConnectionInfo(chain);
        this.charset = chain.getString(10002);
        ByteBlock block = this.getServiceData();
        if (block == null) {
            this.code = -1;
            this.protoVersion = -1;
            this.flags = -1L;
            this.extraBlock = null;
        } else {
            this.code = BinaryTools.getUShort(block, 0);
            this.protoVersion = BinaryTools.getUShort(block, 2);
            this.flags = BinaryTools.getUInt(block, 4);
            this.extraBlock = block.getLength() > 8 ? ByteBlock.wrap(block.subBlock(8).toByteArray()) : null;
        }
    }

    public GetFileReqRvCmd(RvConnectionInfo connInfo) {
        this(connInfo, 1L);
    }

    public GetFileReqRvCmd(RvConnectionInfo connInfo, long flags) {
        this(1, connInfo, CHARSET_DEFAULT, 18, 2, flags, EXTRABLOCK_DEFAULT);
    }

    public GetFileReqRvCmd(int requestType, RvConnectionInfo connInfo) {
        this(requestType, connInfo, CHARSET_DEFAULT, 18, 2, 1L, EXTRABLOCK_DEFAULT);
    }

    public GetFileReqRvCmd(int requestIndex, RvConnectionInfo connInfo, String charset, int code, int protoVersion, long flags, ByteBlock extraBlock) {
        super(CapabilityBlock.BLOCK_FILE_GET, requestIndex);
        DefensiveTools.checkRange(code, "code", -1);
        DefensiveTools.checkRange(protoVersion, "protoVersion", -1);
        DefensiveTools.checkRange(flags, "flags", -1L);
        this.connInfo = connInfo;
        this.charset = charset;
        this.code = code;
        this.protoVersion = protoVersion;
        this.flags = flags;
        this.extraBlock = extraBlock;
    }

    public final RvConnectionInfo getConnInfo() {
        return this.connInfo;
    }

    public final String getCharset() {
        return this.charset;
    }

    public final int getCode() {
        return this.code;
    }

    public final int getProtoVersion() {
        return this.protoVersion;
    }

    public final long getFlags() {
        return this.flags;
    }

    public final ByteBlock getExtraBlock() {
        return this.extraBlock;
    }

    protected void writeRvTlvs(OutputStream out) throws IOException {
        if (this.connInfo != null) {
            this.connInfo.write(out);
        }
        if (this.charset != null) {
            Tlv.getStringInstance(10002, this.charset).write(out);
        }
    }

    protected boolean hasServiceData() {
        return true;
    }

    protected void writeServiceData(OutputStream out) throws IOException {
        if (this.code != -1 && this.protoVersion != -1 && this.flags != -1L) {
            BinaryTools.writeUShort(out, this.code);
            BinaryTools.writeUShort(out, this.protoVersion);
            BinaryTools.writeUInt(out, this.flags);
            if (this.extraBlock != null) {
                this.extraBlock.write(out);
            }
        }
    }

    public String toString() {
        return "GetFileReqRvCmd: connInfo=<" + this.connInfo + ">, code=0x" + Integer.toHexString(this.code) + " (" + MiscTools.findIntField(GetFileReqRvCmd.class, this.code, "CODE_.*") + "), proto=0x" + Integer.toHexString(this.protoVersion) + " (" + MiscTools.findIntField(GetFileReqRvCmd.class, this.protoVersion, "PROTOVERSION_.*") + "), flags=0x" + Long.toHexString(this.flags) + " (" + MiscTools.getFlagFieldsString(GetFileReqRvCmd.class, this.flags, "FLAG_.*") + "), extraBlock=" + (this.extraBlock == null ? null : BinaryTools.describeData(this.extraBlock));
    }
}

