/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ratelim;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.kano.joscar.CopyOnWriteArraySet;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.ratelim.AbstractFutureEventQueue;
import net.kano.joscar.ratelim.RateQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RateLimitingEventQueue
extends AbstractFutureEventQueue {
    private final Set<RateQueue> queues = new CopyOnWriteArraySet<RateQueue>();

    @Override
    public long flushQueues() {
        if (this.queues.isEmpty()) {
            return -1L;
        }
        long minimumWaitTime = -1L;
        for (RateQueue queue : this.queues) {
            boolean queueEmpty = queue.sendAndDequeueReadyRequestsIfPossible();
            if (queueEmpty) continue;
            long waitTime = queue.getOptimalWaitTime();
            if (minimumWaitTime != -1L && minimumWaitTime <= waitTime) continue;
            minimumWaitTime = waitTime;
        }
        if (minimumWaitTime == 0L) {
            minimumWaitTime = 1L;
        }
        return minimumWaitTime;
    }

    @Override
    public boolean hasQueues() {
        return !this.queues.isEmpty();
    }

    public void addQueue(RateQueue queue) {
        DefensiveTools.checkNull(queue, "queue");
        this.queues.add(queue);
        this.updateQueueRunners();
    }

    public void addQueues(Collection<RateQueue> rateQueues) {
        List<RateQueue> safeRateQueues = DefensiveTools.getSafeNonnullListCopy(rateQueues, "rateQueues");
        this.queues.addAll(safeRateQueues);
        this.updateQueueRunners();
    }

    public void removeQueue(RateQueue queue) {
        DefensiveTools.checkNull(queue, "queue");
        this.queues.remove(queue);
        this.updateQueueRunners();
    }

    public void removeQueues(Collection<RateQueue> rateQueues) {
        DefensiveTools.checkNull(rateQueues, "rateQueues");
        this.queues.removeAll(rateQueues);
        this.updateQueueRunners();
    }

    public String toString() {
        return "RateLimitingEventQueue: queues=" + this.queues;
    }
}

