/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.Color;
import java.awt.Cursor;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.UIManager;
import net.java.sip.communicator.plugin.desktoputil.plaf.SIPCommLinkButtonUI;

public class SIPCommLinkButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private static final String UIClassID = "LinkButtonUI";
    public static final int ALWAYS_UNDERLINE = 0;
    public static final int HOVER_UNDERLINE = 1;
    public static final int NEVER_UNDERLINE = 2;
    private int linkBehavior = 1;
    private Color linkColor = Color.blue;
    private Color colorPressed = Color.red;
    private Color visitedLinkColor = new Color(128, 0, 128);
    private Color disabledLinkColor;
    private URL buttonURL;
    private boolean isLinkVisited;

    public SIPCommLinkButton() {
        this((String)null, (URL)null);
    }

    public SIPCommLinkButton(String text) {
        this(text, (URL)null);
    }

    public SIPCommLinkButton(URL url) {
        this(null, url);
    }

    public SIPCommLinkButton(String text, URL url) {
        super(text);
        if (text == null && url != null) {
            this.setText(url.toExternalForm());
        }
        this.setLinkURL(url);
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setRolloverEnabled(true);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public String getUIClassID() {
        return UIClassID;
    }

    protected void setupToolTipText() {
        String tip = null;
        if (this.buttonURL != null) {
            tip = this.buttonURL.toExternalForm();
        }
        this.setToolTipText(tip);
    }

    public void setLinkBehavior(int bnew) {
        if (bnew != 0 && bnew != 1 && bnew != 2) {
            throw new IllegalArgumentException("Not a legal LinkBehavior");
        }
        int old = this.linkBehavior;
        this.linkBehavior = bnew;
        this.firePropertyChange("linkBehavior", old, bnew);
        this.repaint();
    }

    public int getLinkBehavior() {
        return this.linkBehavior;
    }

    public void setLinkColor(Color color) {
        Color colorOld = this.linkColor;
        this.linkColor = color;
        this.firePropertyChange("linkColor", colorOld, color);
        this.repaint();
    }

    public Color getLinkColor() {
        return this.linkColor;
    }

    public void setActiveLinkColor(Color colorNew) {
        Color colorOld = this.colorPressed;
        this.colorPressed = colorNew;
        this.firePropertyChange("activeLinkColor", colorOld, colorNew);
        this.repaint();
    }

    public Color getActiveLinkColor() {
        return this.colorPressed;
    }

    public void setDisabledLinkColor(Color color) {
        Color colorOld = this.disabledLinkColor;
        this.disabledLinkColor = color;
        this.firePropertyChange("disabledLinkColor", colorOld, color);
        if (!this.isEnabled()) {
            this.repaint();
        }
    }

    public Color getDisabledLinkColor() {
        return this.disabledLinkColor;
    }

    public void setVisitedLinkColor(Color colorNew) {
        Color colorOld = this.visitedLinkColor;
        this.visitedLinkColor = colorNew;
        this.firePropertyChange("visitedLinkColor", colorOld, colorNew);
        this.repaint();
    }

    public Color getVisitedLinkColor() {
        return this.visitedLinkColor;
    }

    public void setLinkURL(URL url) {
        URL urlOld = this.buttonURL;
        this.buttonURL = url;
        this.setupToolTipText();
        this.firePropertyChange("linkURL", urlOld, url);
        this.revalidate();
        this.repaint();
    }

    public URL getLinkURL() {
        return this.buttonURL;
    }

    public void setLinkVisited(boolean flagNew) {
        boolean flagOld = this.isLinkVisited;
        this.isLinkVisited = flagNew;
        this.firePropertyChange("linkVisited", flagOld, flagNew);
        this.repaint();
    }

    public boolean isLinkVisited() {
        return this.isLinkVisited;
    }

    static {
        UIManager.getDefaults().put(UIClassID, SIPCommLinkButtonUI.class.getName());
    }
}

