/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.dtls;

import java.io.IOException;
import java.util.Hashtable;
import org.bouncycastle.crypto.tls.Certificate;
import org.bouncycastle.crypto.tls.CertificateRequest;
import org.bouncycastle.crypto.tls.DefaultTlsEncryptionCredentials;
import org.bouncycastle.crypto.tls.DefaultTlsServer;
import org.bouncycastle.crypto.tls.DefaultTlsSignerCredentials;
import org.bouncycastle.crypto.tls.MaxFragmentLength;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsECCUtils;
import org.bouncycastle.crypto.tls.TlsEncryptionCredentials;
import org.bouncycastle.crypto.tls.TlsExtensionsUtils;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsPeer;
import org.bouncycastle.crypto.tls.TlsSRTPUtils;
import org.bouncycastle.crypto.tls.TlsServerContext;
import org.bouncycastle.crypto.tls.TlsSignerCredentials;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.crypto.tls.UseSRTPData;
import org.jitsi.impl.neomedia.transform.dtls.CertificateInfo;
import org.jitsi.impl.neomedia.transform.dtls.DtlsControlImpl;
import org.jitsi.impl.neomedia.transform.dtls.DtlsPacketTransformer;
import org.jitsi.impl.neomedia.transform.dtls.Properties;
import org.jitsi.util.Logger;

public class TlsServerImpl
extends DefaultTlsServer {
    private static final Logger logger = Logger.getLogger(TlsServerImpl.class);
    private final CertificateRequest certificateRequest = new CertificateRequest(new short[]{1}, null, null);
    private int chosenProtectionProfile;
    private final DtlsPacketTransformer packetTransformer;
    private TlsEncryptionCredentials rsaEncryptionCredentials;
    private TlsSignerCredentials rsaSignerCredentials;

    public TlsServerImpl(DtlsPacketTransformer packetTransformer) {
        this.packetTransformer = packetTransformer;
    }

    public CertificateRequest getCertificateRequest() {
        return this.certificateRequest;
    }

    int getChosenProtectionProfile() {
        return this.chosenProtectionProfile;
    }

    protected int[] getCipherSuites() {
        return new int[]{49200, 49199, 49192, 49191, 49172, 49171, 159, 158, 107, 103, 57, 51};
    }

    TlsContext getContext() {
        return this.context;
    }

    private DtlsControlImpl getDtlsControl() {
        return this.packetTransformer.getDtlsControl();
    }

    protected ProtocolVersion getMaximumVersion() {
        return ProtocolVersion.DTLSv10;
    }

    protected ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.DTLSv10;
    }

    private Properties getProperties() {
        return this.packetTransformer.getProperties();
    }

    protected TlsEncryptionCredentials getRSAEncryptionCredentials() throws IOException {
        if (this.rsaEncryptionCredentials == null) {
            CertificateInfo certificateInfo = this.getDtlsControl().getCertificateInfo();
            this.rsaEncryptionCredentials = new DefaultTlsEncryptionCredentials((TlsContext)this.context, certificateInfo.getCertificate(), certificateInfo.getKeyPair().getPrivate());
        }
        return this.rsaEncryptionCredentials;
    }

    protected TlsSignerCredentials getRSASignerCredentials() throws IOException {
        if (this.rsaSignerCredentials == null) {
            CertificateInfo certificateInfo = this.getDtlsControl().getCertificateInfo();
            this.rsaSignerCredentials = new DefaultTlsSignerCredentials((TlsContext)this.context, certificateInfo.getCertificate(), certificateInfo.getKeyPair().getPrivate(), new SignatureAndHashAlgorithm(2, 1));
        }
        return this.rsaSignerCredentials;
    }

    public Hashtable getServerExtensions() throws IOException {
        Hashtable serverExtensions = this.getServerExtensionsOverride();
        if (this.isSrtpDisabled()) {
            return serverExtensions;
        }
        if (TlsSRTPUtils.getUseSRTPExtension((Hashtable)serverExtensions) == null) {
            UseSRTPData useSRTPData;
            int chosenProtectionProfile;
            if (serverExtensions == null) {
                serverExtensions = new Hashtable();
            }
            if ((chosenProtectionProfile = DtlsControlImpl.chooseSRTPProtectionProfile((useSRTPData = TlsSRTPUtils.getUseSRTPExtension((Hashtable)this.clientExtensions)).getProtectionProfiles())) == 0) {
                String msg = "No chosen SRTP protection profile!";
                TlsFatalAlert tfa = new TlsFatalAlert(80);
                logger.error(msg, (Throwable)tfa);
                throw tfa;
            }
            TlsSRTPUtils.addUseSRTPExtension(serverExtensions, (UseSRTPData)new UseSRTPData(new int[]{chosenProtectionProfile}, useSRTPData.getMki()));
            this.chosenProtectionProfile = chosenProtectionProfile;
        }
        return serverExtensions;
    }

    private Hashtable getServerExtensionsOverride() throws IOException {
        if (this.encryptThenMACOffered && this.allowEncryptThenMAC() && TlsUtils.isBlockCipherSuite((int)this.selectedCipherSuite)) {
            TlsExtensionsUtils.addEncryptThenMACExtension((Hashtable)this.checkServerExtensions());
        }
        if (this.maxFragmentLengthOffered >= 0 && MaxFragmentLength.isValid((short)this.maxFragmentLengthOffered)) {
            TlsExtensionsUtils.addMaxFragmentLengthExtension((Hashtable)this.checkServerExtensions(), (short)this.maxFragmentLengthOffered);
        }
        if (this.truncatedHMacOffered && this.allowTruncatedHMac()) {
            TlsExtensionsUtils.addTruncatedHMacExtension((Hashtable)this.checkServerExtensions());
        }
        if (TlsECCUtils.isECCCipherSuite((int)this.selectedCipherSuite)) {
            this.serverECPointFormats = new short[]{0, 1, 2};
            TlsECCUtils.addSupportedPointFormatsExtension((Hashtable)this.checkServerExtensions(), (short[])this.serverECPointFormats);
        }
        return this.serverExtensions;
    }

    public void init(TlsServerContext context) {
        super.init(context);
    }

    private boolean isSrtpDisabled() {
        return this.getProperties().isSrtpDisabled();
    }

    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        this.packetTransformer.notifyAlertRaised((TlsPeer)this, alertLevel, alertDescription, message, cause);
    }

    public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        try {
            this.getDtlsControl().verifyAndValidateCertificate(clientCertificate);
        }
        catch (Exception e) {
            logger.error("Failed to verify and/or validate client certificate!", e);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    public void processClientExtensions(Hashtable clientExtensions) throws IOException {
        if (this.isSrtpDisabled()) {
            super.processClientExtensions(clientExtensions);
            return;
        }
        UseSRTPData useSRTPData = TlsSRTPUtils.getUseSRTPExtension((Hashtable)clientExtensions);
        if (useSRTPData == null) {
            String msg = "DTLS extended client hello does not include the use_srtp extension!";
            IOException ioe = new IOException(msg);
            logger.error(msg, ioe);
            throw ioe;
        }
        int chosenProtectionProfile = DtlsControlImpl.chooseSRTPProtectionProfile(useSRTPData.getProtectionProfiles());
        if (chosenProtectionProfile == 0) {
            String msg = "No chosen SRTP protection profile!";
            TlsFatalAlert tfa = new TlsFatalAlert(47);
            logger.error(msg, (Throwable)tfa);
            throw tfa;
        }
        super.processClientExtensions(clientExtensions);
    }
}

