/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.loc;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.loc.LocCommand;

public class SetDirAck
extends LocCommand {
    public static final int CODE_SUCCESS = 1;
    public static final int CODE_ERROR = 2;
    private final int code;

    protected SetDirAck(SnacPacket packet) {
        super(10);
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock snacData = packet.getData();
        this.code = BinaryTools.getUShort(snacData, 0);
    }

    public SetDirAck() {
        this(1);
    }

    public SetDirAck(int code) {
        super(10);
        DefensiveTools.checkRange(code, "code", 0);
        this.code = code;
    }

    public final int getResultCode() {
        return this.code;
    }

    public void writeData(OutputStream out) throws IOException {
        BinaryTools.writeUShort(out, this.code);
    }

    public String toString() {
        return "SetDirAck: code=" + this.code;
    }
}

