/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.icq;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class FullUserInfoCmd
extends SnacCommand {
    private static final int TYPE_ICQ_DATA = 1;
    private static CommandFactory commandFactory = new CommandFactory();
    private String senderUIN;
    private ByteArrayOutputStream icqDataOut = new ByteArrayOutputStream();
    private int primaryType = -1;
    private int secondaryType = -1;
    private int requestID = -1;
    boolean lastOfSequences = false;
    private static Hashtable<Integer, Hashtable<String, Object>> retreivedInfo = new Hashtable();
    static final String LAST_NAME = "LastName";
    static final String PHONE_NUMBER = "PhoneNumber";
    static final String SPEAK_LANG = "SpeakingLanguage";
    static final String HOME_COUNTRY = "HomeCountry";

    public FullUserInfoCmd(String senderUIN) {
        super(21, 2);
        this.senderUIN = senderUIN;
    }

    public FullUserInfoCmd(SnacPacket packet) {
        super(21, 3);
        Tlv icqDataTlv = TlvTools.readChain(packet.getData()).getLastTlv(1);
        if (icqDataTlv != null) {
            ByteBlock icqBlock = icqDataTlv.getData();
            int hdrlen = 8;
            this.senderUIN = String.valueOf(FullUserInfoCmd.getUInt(icqBlock, 2));
            this.requestID = FullUserInfoCmd.getUShort(icqBlock, 8);
            this.primaryType = FullUserInfoCmd.getUShort(icqBlock, 6);
            if (this.primaryType >= 1000) {
                this.secondaryType = FullUserInfoCmd.getUShort(icqBlock, 10);
                hdrlen = 10;
            }
            ByteBlock icqData = icqBlock.getLength() >= hdrlen + 2 ? icqBlock.subBlock(hdrlen + 2) : null;
            this.processICQData(icqData);
        }
    }

    private void processICQData(ByteBlock icqData) {
        switch (this.secondaryType) {
            case 200: {
                this.readBasicUserInfo(icqData, this.requestID);
                break;
            }
            case 220: {
                this.readMoreUserInfo(icqData, this.requestID);
                break;
            }
            case 235: {
                this.readEmailUserInfo(icqData, this.requestID);
                break;
            }
            case 270: {
                this.readHomePageUserInfo(icqData, this.requestID);
                break;
            }
            case 210: {
                this.readWorkUserInfo(icqData, this.requestID);
                break;
            }
            case 230: {
                this.readUserAboutInfo(icqData, this.requestID);
                break;
            }
            case 240: {
                this.readInterestsUserInfo(icqData, this.requestID);
                break;
            }
            case 250: {
                this.readAffilationsUserInfo(icqData, this.requestID);
            }
        }
    }

    @Override
    public void writeData(OutputStream out) throws IOException {
        ByteArrayOutputStream icqout = new ByteArrayOutputStream();
        int hdrlen = 10;
        int primary = 2000;
        int secondary = 3130;
        long icqUINlong = Long.parseLong(this.senderUIN);
        int length = hdrlen + this.icqDataOut.size();
        FullUserInfoCmd.writeUShort(icqout, length);
        FullUserInfoCmd.writeUInt(icqout, icqUINlong);
        FullUserInfoCmd.writeUShort(icqout, primary);
        FullUserInfoCmd.writeUShort(icqout, 2);
        FullUserInfoCmd.writeUShort(icqout, secondary);
        this.icqDataOut.writeTo(icqout);
        new Tlv(1, ByteBlock.wrap(icqout.toByteArray())).write(out);
    }

    private Hashtable<String, Object> getInfoForRequest(int requestID) {
        Hashtable<String, Object> res = retreivedInfo.get(new Integer(requestID));
        if (res == null) {
            res = new Hashtable();
            retreivedInfo.put(new Integer(requestID), res);
        }
        return res;
    }

    public Hashtable<String, Object> getInfo() {
        return this.getInfoForRequest(this.requestID);
    }

    private void readBasicUserInfo(ByteBlock block, int requestID) {
        Hashtable<String, Object> infoData = this.getInfoForRequest(requestID);
        String[] bscInfo = new String[11];
        int offset = FullUserInfoCmd.readStrings(block, bscInfo, 1);
        int homeCountryCode = FullUserInfoCmd.getUShort(block, offset);
        offset += 2;
        infoData.put(HOME_COUNTRY, new Integer(homeCountryCode));
        if (bscInfo[2] != null) {
            infoData.put(LAST_NAME, bscInfo[2]);
        }
        if (bscInfo[6] != null) {
            infoData.put(PHONE_NUMBER, bscInfo[6]);
        }
    }

    private void readMoreUserInfo(ByteBlock block, int requestID) {
        Hashtable<String, Object> infoData = this.getInfoForRequest(requestID);
        int offset = 1;
        String[] tmp = new String[1];
        offset += 2;
        ++offset;
        offset = FullUserInfoCmd.readStrings(block, tmp, offset);
        offset += 2;
        ++offset;
        ArrayList<Integer> langs = new ArrayList<Integer>();
        short speakingLanguage1 = FullUserInfoCmd.getUByte(block, ++offset);
        ++offset;
        if (speakingLanguage1 != 0 && speakingLanguage1 != 255) {
            langs.add(new Integer(speakingLanguage1));
        }
        short speakingLanguage2 = FullUserInfoCmd.getUByte(block, offset);
        ++offset;
        if (speakingLanguage2 != 0 && speakingLanguage2 != 255) {
            langs.add(new Integer(speakingLanguage2));
        }
        short speakingLanguage3 = FullUserInfoCmd.getUByte(block, offset);
        ++offset;
        if (speakingLanguage3 != 0 && speakingLanguage3 != 255) {
            langs.add(new Integer(speakingLanguage3));
        }
        infoData.put(SPEAK_LANG, langs);
    }

    private void readEmailUserInfo(ByteBlock block, int requestID) {
    }

    private void readHomePageUserInfo(ByteBlock block, int requestID) {
    }

    private void readWorkUserInfo(ByteBlock block, int requestID) {
    }

    private void readUserAboutInfo(ByteBlock block, int requestID) {
    }

    private void readInterestsUserInfo(ByteBlock block, int requestID) {
    }

    private void readAffilationsUserInfo(ByteBlock block, int requestID) {
        this.lastOfSequences = true;
    }

    protected void writeOutByte(int dataType, int value) {
        try {
            FullUserInfoCmd.writeUShort(this.icqDataOut, dataType);
            FullUserInfoCmd.writeUShort(this.icqDataOut, 1);
            FullUserInfoCmd.writeUByte(this.icqDataOut, value);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void writeOutShort(int dataType, int value) {
        try {
            FullUserInfoCmd.writeUShort(this.icqDataOut, dataType);
            FullUserInfoCmd.writeUShort(this.icqDataOut, 2);
            FullUserInfoCmd.writeUShort(this.icqDataOut, value);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void writeOutString(int dataType, String value) {
        try {
            byte[] data = BinaryTools.getAsciiBytes(value);
            FullUserInfoCmd.writeUShort(this.icqDataOut, dataType);
            FullUserInfoCmd.writeUShort(this.icqDataOut, data.length + 2);
            FullUserInfoCmd.writeUShort(this.icqDataOut, data.length);
            this.icqDataOut.write(data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void writeUInt(OutputStream out, long number) throws IOException {
        out.write(new byte[]{(byte)(number & 0xFFL), (byte)(number >> 8 & 0xFFL), (byte)(number >> 16 & 0xFFL), (byte)(number >> 24 & 0xFFL)});
    }

    private static void writeUShort(OutputStream out, int number) throws IOException {
        out.write(new byte[]{(byte)(number & 0xFF), (byte)(number >> 8 & 0xFF)});
    }

    private static void writeUByte(OutputStream out, int number) throws IOException {
        out.write(new byte[]{(byte)(number & 0xFF)});
    }

    private static long getUInt(ByteBlock data, int pos) {
        if (data.getLength() - pos < 4) {
            return -1L;
        }
        return ((long)data.get(pos + 3) & 0xFFL) << 24 | ((long)data.get(pos + 2) & 0xFFL) << 16 | ((long)data.get(pos + 1) & 0xFFL) << 8 | (long)data.get(pos) & 0xFFL;
    }

    private static int getUShort(ByteBlock data, int pos) {
        if (data.getLength() - pos < 2) {
            return -1;
        }
        return (data.get(pos + 1) & 0xFF) << 8 | data.get(pos) & 0xFF;
    }

    public static short getUByte(ByteBlock data, int pos) {
        if (data.getLength() - pos < 1) {
            return -1;
        }
        return (short)(data.get(pos) & 0xFF);
    }

    private static int readStrings(ByteBlock block, String[] result, int offset) {
        for (int i = 0; i < result.length; ++i) {
            int textlen = FullUserInfoCmd.getUShort(block, offset) - 1;
            offset += 2;
            if (textlen > 0) {
                ByteBlock field = block.subBlock(offset, textlen);
                result[i] = OscarTools.getString(field, "US-ASCII");
                offset += textlen;
            }
            ++offset;
        }
        return offset;
    }

    protected static SnacCmdFactory getCommandFactory() {
        return commandFactory;
    }

    protected static SnacCommand getFullInfoRequestCommand(String senderUIN, String userInfoUIN) {
        return new FullInfoRequest(senderUIN, userInfoUIN);
    }

    private static class FullInfoRequest
    extends SnacCommand {
        private String senderUIN;
        private String userInfoUIN;

        FullInfoRequest(String senderUIN, String userInfoUIN) {
            super(21, 2);
            this.senderUIN = senderUIN;
            this.userInfoUIN = userInfoUIN;
        }

        @Override
        public void writeData(OutputStream out) throws IOException {
            ByteArrayOutputStream icqout = new ByteArrayOutputStream();
            ByteArrayOutputStream icqDataOut = new ByteArrayOutputStream();
            FullUserInfoCmd.writeUInt(icqDataOut, Long.parseLong(this.userInfoUIN));
            int hdrlen = 10;
            int primary = 2000;
            int secondary = 1202;
            long icqUINlong = Long.parseLong(this.senderUIN);
            int length = hdrlen + icqDataOut.size();
            FullUserInfoCmd.writeUShort(icqout, length);
            FullUserInfoCmd.writeUInt(icqout, icqUINlong);
            FullUserInfoCmd.writeUShort(icqout, primary);
            FullUserInfoCmd.writeUShort(icqout, 2);
            FullUserInfoCmd.writeUShort(icqout, secondary);
            icqDataOut.writeTo(icqout);
            new Tlv(1, ByteBlock.wrap(icqout.toByteArray())).write(out);
        }
    }

    private static class CommandFactory
    implements SnacCmdFactory {
        static final List<CmdType> SUPPORTED_TYPES = DefensiveTools.asUnmodifiableList(new CmdType(21, 3));

        private CommandFactory() {
        }

        @Override
        public SnacCommand genSnacCommand(SnacPacket packet) {
            return new FullUserInfoCmd(packet);
        }

        @Override
        public List<CmdType> getSupportedTypes() {
            return SUPPORTED_TYPES;
        }
    }
}

