/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.usersearch;

import java.util.LinkedList;
import net.java.sip.communicator.plugin.usersearch.UserSearchContactSource;
import net.java.sip.communicator.plugin.usersearch.UserSearchSupportedProviderListener;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredContactInfo;
import net.java.sip.communicator.service.protocol.OperationSetUserSearch;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.UserSearchProviderEvent;
import net.java.sip.communicator.service.protocol.event.UserSearchProviderListener;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class UserSearchActivator
implements BundleActivator {
    private static LinkedList<ProtocolProviderService> userSearchProviders;
    public static BundleContext bundleContext;
    private static UserSearchProviderStateListener userSeachListener;
    private static LinkedList<ProtocolProviderService> supportedProviders;
    private static LinkedList<UserSearchSupportedProviderListener> listeners;
    private static ServiceRegistration contactSourceRegistration;
    private static Logger logger;
    private static UserSearchContactSource userSearchContactSource;
    private static ResourceManagementService resources;

    public static void initUserSearchProviders() {
        if (userSearchProviders != null) {
            return;
        }
        userSearchProviders = new LinkedList();
        bundleContext.addServiceListener((ServiceListener)new ProtocolProviderRegListener());
        ServiceReference[] serRefs = null;
        try {
            serRefs = bundleContext.getServiceReferences(ProtocolProviderFactory.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            logger.error((Object)("LoginManager : " + (Object)((Object)e)));
        }
        if (serRefs != null) {
            for (ServiceReference serRef : serRefs) {
                ProtocolProviderFactory providerFactory = (ProtocolProviderFactory)bundleContext.getService(serRef);
                for (AccountID accountID : providerFactory.getRegisteredAccounts()) {
                    serRef = providerFactory.getProviderForAccount(accountID);
                    ProtocolProviderService protocolProvider = (ProtocolProviderService)bundleContext.getService(serRef);
                    UserSearchActivator.handleProviderAdded(protocolProvider);
                }
            }
        }
    }

    public static LinkedList<ProtocolProviderService> getSupportedProviders() {
        return supportedProviders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addUserSearchSupportedProviderListener(UserSearchSupportedProviderListener listener) {
        LinkedList<UserSearchSupportedProviderListener> linkedList = listeners;
        synchronized (linkedList) {
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeUserSearchSupportedProviderListener(UserSearchSupportedProviderListener listener) {
        LinkedList<UserSearchSupportedProviderListener> linkedList = listeners;
        synchronized (linkedList) {
            listeners.remove(listener);
        }
    }

    private static void handleProviderAdded(ProtocolProviderService protocolProvider) {
        if (protocolProvider.getOperationSet(OperationSetServerStoredContactInfo.class) != null && !userSearchProviders.contains(protocolProvider)) {
            OperationSetUserSearch opSet = (OperationSetUserSearch)protocolProvider.getOperationSet(OperationSetUserSearch.class);
            if (opSet == null) {
                return;
            }
            if (userSeachListener == null) {
                userSeachListener = new UserSearchProviderStateListener();
            }
            opSet.addUserSearchProviderListener((UserSearchProviderListener)userSeachListener);
            if (opSet.isEnabled()) {
                UserSearchActivator.addSupportedProvider(protocolProvider);
            }
            userSearchProviders.add(protocolProvider);
        }
    }

    private static void handleProviderRemoved(ProtocolProviderService protocolProvider) {
        if (userSearchProviders.contains(protocolProvider)) {
            userSearchProviders.remove(protocolProvider);
            UserSearchActivator.removeSupportedProvider(protocolProvider);
            if (userSeachListener == null) {
                return;
            }
            OperationSetUserSearch opSet = (OperationSetUserSearch)protocolProvider.getOperationSet(OperationSetUserSearch.class);
            if (opSet == null) {
                return;
            }
            opSet.removeUserSearchProviderListener((UserSearchProviderListener)userSeachListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addSupportedProvider(ProtocolProviderService provider) {
        if (!supportedProviders.contains(provider)) {
            LinkedList<UserSearchSupportedProviderListener> tmpListeners;
            supportedProviders.add(provider);
            LinkedList<UserSearchSupportedProviderListener> linkedList = listeners;
            synchronized (linkedList) {
                tmpListeners = new LinkedList<UserSearchSupportedProviderListener>(listeners);
            }
            for (UserSearchSupportedProviderListener l : tmpListeners) {
                l.providerAdded(provider);
            }
            if (supportedProviders.size() == 1) {
                if (userSearchContactSource == null) {
                    userSearchContactSource = new UserSearchContactSource();
                }
                contactSourceRegistration = bundleContext.registerService(ContactSourceService.class.getName(), (Object)userSearchContactSource, null);
            }
        }
    }

    private static void removeSupportedProvider(ProtocolProviderService provider) {
        if (supportedProviders.contains(provider)) {
            supportedProviders.remove(provider);
            for (UserSearchSupportedProviderListener l : listeners) {
                l.providerRemoved(provider);
            }
            if (supportedProviders.isEmpty() && contactSourceRegistration != null) {
                contactSourceRegistration.unregister();
                contactSourceRegistration = null;
            }
        }
    }

    public void start(BundleContext context) throws Exception {
        bundleContext = context;
        UserSearchActivator.initUserSearchProviders();
    }

    public void stop(BundleContext context) throws Exception {
        userSeachListener = null;
        userSearchProviders.clear();
        supportedProviders.clear();
        listeners.clear();
        contactSourceRegistration = null;
        userSearchContactSource = null;
    }

    public static ResourceManagementService getResources() {
        if (resources == null) {
            resources = (ResourceManagementService)ServiceUtils.getService((BundleContext)bundleContext, ResourceManagementService.class);
        }
        return resources;
    }

    static {
        userSeachListener = null;
        supportedProviders = new LinkedList();
        listeners = new LinkedList();
        contactSourceRegistration = null;
        logger = Logger.getLogger(UserSearchActivator.class);
        userSearchContactSource = null;
        resources = null;
    }

    private static class UserSearchProviderStateListener
    implements UserSearchProviderListener {
        private UserSearchProviderStateListener() {
        }

        public void onUserSearchProviderEvent(UserSearchProviderEvent event) {
            if (event.getType() == UserSearchProviderEvent.PROVIDER_ADDED) {
                UserSearchActivator.addSupportedProvider(event.getProvider());
            } else if (event.getType() == UserSearchProviderEvent.PROVIDER_REMOVED) {
                UserSearchActivator.removeSupportedProvider(event.getProvider());
            }
        }
    }

    private static class ProtocolProviderRegListener
    implements ServiceListener {
        private ProtocolProviderRegListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            ServiceReference serviceRef = event.getServiceReference();
            if (serviceRef.getBundle().getState() == 16) {
                return;
            }
            Object service = bundleContext.getService(serviceRef);
            if (!(service instanceof ProtocolProviderService)) {
                return;
            }
            switch (event.getType()) {
                case 1: {
                    UserSearchActivator.handleProviderAdded((ProtocolProviderService)service);
                    break;
                }
                case 4: {
                    UserSearchActivator.handleProviderRemoved((ProtocolProviderService)service);
                }
            }
        }
    }
}

