/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import net.java.sip.communicator.impl.protocol.irc.Color;
import net.java.sip.communicator.impl.protocol.irc.ControlChar;
import net.java.sip.communicator.impl.protocol.irc.FormattedTextBuilder;
import net.java.sip.communicator.util.Logger;
import org.apache.commons.lang3.StringEscapeUtils;

public final class Utils {
    private static final Logger LOGGER = Logger.getLogger(Utils.class);
    private static final int INDEX_END_FOREGROUND_COLOR_CODE = 2;
    private static final int INDEX_END_BACKGROUND_COLOR_CODE = 3;

    private Utils() {
    }

    public static String parseIrcMessage(String text) {
        if (text == null) {
            return null;
        }
        FormattedTextBuilder builder = new FormattedTextBuilder();
        block7: for (int i = 0; i < text.length(); ++i) {
            char val = text.charAt(i);
            switch (val) {
                case '\u0002': {
                    if (builder.isActive(ControlChar.Bold.class)) {
                        builder.cancel(ControlChar.Bold.class, true);
                        continue block7;
                    }
                    builder.apply(new ControlChar.Bold());
                    continue block7;
                }
                case '\u0016': {
                    if (builder.isActive(ControlChar.Italics.class)) {
                        builder.cancel(ControlChar.Italics.class, true);
                        continue block7;
                    }
                    builder.apply(new ControlChar.Italics());
                    continue block7;
                }
                case '\u001f': {
                    if (builder.isActive(ControlChar.Underline.class)) {
                        builder.cancel(ControlChar.Underline.class, true);
                        continue block7;
                    }
                    builder.apply(new ControlChar.Underline());
                    continue block7;
                }
                case '\u0003': {
                    Color foreground = Utils.parseForegroundColor(text.substring(i + 1));
                    if (foreground == null) {
                        builder.cancel(ControlChar.ColorFormat.class, false);
                        continue block7;
                    }
                    Color background = Utils.parseBackgroundColor(text.substring((i += 2) + 1));
                    if (background != null) {
                        i += 3;
                    }
                    builder.apply(new ControlChar.ColorFormat(foreground, background));
                    continue block7;
                }
                case '\u000f': {
                    builder.cancelAll();
                    continue block7;
                }
                default: {
                    builder.append(StringEscapeUtils.escapeHtml4((String)("" + val)));
                }
            }
        }
        return builder.done();
    }

    private static Color parseBackgroundColor(String text) {
        try {
            if (text.charAt(0) == ',') {
                int color = Integer.parseInt("" + text.charAt(1) + text.charAt(2));
                return Color.values()[color %= Color.values().length];
            }
            return null;
        }
        catch (StringIndexOutOfBoundsException e) {
            LOGGER.trace((Object)"Abort parsing background color because text ended. Assuming only foreground color was available.");
            return null;
        }
        catch (NumberFormatException e) {
            LOGGER.trace((Object)"No background color defined. Ignoring ...");
            return null;
        }
    }

    private static Color parseForegroundColor(String text) {
        try {
            int color = Integer.parseInt("" + text.charAt(0) + text.charAt(1));
            return Color.values()[color %= Color.values().length];
        }
        catch (StringIndexOutOfBoundsException e) {
            LOGGER.trace((Object)"ArrayIndexOutOfBounds during foreground color control code parsing.");
            return null;
        }
        catch (NumberFormatException e) {
            LOGGER.trace((Object)"Invalid foreground color code encountered.", (Throwable)e);
            return null;
        }
    }

    public static String styleAsMessage(String message) {
        return message;
    }

    public static String styleAsNotice(String message, String user) {
        return "<i>" + user + "</i>: " + message;
    }

    public static String styleAsAwayMessage(String text) {
        return "<i>Away: " + text + "</i>";
    }
}

