/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.net.InetAddress;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.media.Format;
import javax.media.protocol.DataSource;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.Participant;
import javax.media.rtp.rtcp.Report;
import javax.media.rtp.rtcp.SourceDescription;
import net.sf.fmj.media.rtp.RTCPReportBlock;
import net.sf.fmj.media.rtp.RTCPReporter;
import net.sf.fmj.media.rtp.RTCPSDES;
import net.sf.fmj.media.rtp.RTPSinkStream;
import net.sf.fmj.media.rtp.RTPSourceInfo;
import net.sf.fmj.media.rtp.RTPSourceStream;
import net.sf.fmj.media.rtp.RTPStats;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.util.SSRCTable;

public abstract class SSRCInfo
implements Report {
    private SSRCCache cache;
    boolean alive = false;
    boolean payloadchange = false;
    boolean byeReceived = false;
    long byeTime = 0L;
    String byereason = null;
    public RTPSourceInfo sourceInfo = null;
    public SourceDescription name = null;
    public SourceDescription email = null;
    public SourceDescription phone = null;
    public SourceDescription loc = null;
    public SourceDescription tool = null;
    public SourceDescription note = null;
    SourceDescription priv = null;
    public long lastSRntptimestamp;
    long lastSRrtptimestamp;
    long lastSRoctetcount;
    long lastSRpacketcount;
    long lastRTCPreceiptTime;
    public long lastSRreceiptTime;
    long lastHeardFrom;
    boolean quiet;
    boolean inactivesent;
    boolean aging;
    public boolean sender;
    public boolean ours;
    public int ssrc;
    boolean streamconnect;
    SSRCTable<RTCPReportBlock[]> reports;
    boolean active;
    boolean newrecvstream;
    boolean recvstrmap;
    boolean newpartsent;
    boolean lastsr;
    boolean wrapped;
    static final int INITIALPROBATION = 2;
    int probation;
    static final int PAYLOAD_UNASSIGNED = -1;
    boolean wassender;
    public int prevmaxseq;
    public int prevlost;
    long starttime;
    public long rtptime;
    public long systime;
    InetAddress address;
    int port;
    RTCPReporter reporter;
    Format currentformat;
    int payloadType;
    net.sf.fmj.media.protocol.rtp.DataSource dsource;
    DataSource pds;
    RTPSourceStream dstream;
    RTPSinkStream sinkstream;
    long lastRTPReceiptTime;
    public int maxseq;
    public int cycles;
    public int baseseq;
    int lastbadseq;
    public int received;
    long lasttimestamp;
    int lastPayloadType = -1;
    public double jitter;
    public int bytesreceived;
    RTPStats stats;
    int clockrate;

    SSRCInfo(SSRCCache cache, int ssrc) {
        this.lastSRntptimestamp = 0L;
        this.lastSRrtptimestamp = 0L;
        this.lastSRoctetcount = 0L;
        this.lastSRpacketcount = 0L;
        this.lastRTCPreceiptTime = 0L;
        this.lastSRreceiptTime = 0L;
        this.lastHeardFrom = 0L;
        this.quiet = false;
        this.inactivesent = false;
        this.sender = false;
        this.ours = false;
        this.streamconnect = false;
        this.reports = new SSRCTable();
        this.active = false;
        this.newrecvstream = false;
        this.recvstrmap = false;
        this.newpartsent = false;
        this.lastsr = false;
        this.wrapped = false;
        this.probation = 2;
        this.wassender = false;
        this.currentformat = null;
        this.payloadType = -1;
        this.dsource = null;
        this.pds = null;
        this.dstream = null;
        this.sinkstream = null;
        this.maxseq = 0;
        this.cycles = 0;
        this.lasttimestamp = 0L;
        this.jitter = 0.0;
        this.clockrate = 0;
        this.cache = cache;
        this.ssrc = ssrc;
        this.stats = new RTPStats();
    }

    SSRCInfo(SSRCInfo info) {
        this.lastSRoctetcount = 0L;
        this.lastSRpacketcount = 0L;
        this.lastSRreceiptTime = 0L;
        this.lastHeardFrom = 0L;
        this.quiet = false;
        this.inactivesent = false;
        this.sender = false;
        this.ours = false;
        this.streamconnect = false;
        this.reports = new SSRCTable();
        this.active = false;
        this.newrecvstream = false;
        this.recvstrmap = false;
        this.newpartsent = false;
        this.lastsr = false;
        this.wrapped = false;
        this.probation = 2;
        this.wassender = false;
        this.currentformat = null;
        this.payloadType = -1;
        this.pds = null;
        this.sinkstream = null;
        this.maxseq = 0;
        this.cycles = 0;
        this.lasttimestamp = 0L;
        this.jitter = 0.0;
        this.clockrate = 0;
        this.cache = info.cache;
        this.alive = info.alive;
        this.sourceInfo = info.sourceInfo;
        if (this.sourceInfo != null) {
            this.sourceInfo.addSSRC(this);
        }
        this.cache.remove(info.ssrc);
        this.name = info.name;
        this.email = info.email;
        this.phone = info.phone;
        this.loc = info.loc;
        this.tool = info.tool;
        this.note = info.note;
        this.priv = info.priv;
        this.lastSRntptimestamp = info.lastSRntptimestamp;
        this.lastSRrtptimestamp = info.lastSRrtptimestamp;
        this.lastSRoctetcount = info.lastSRoctetcount;
        this.lastSRpacketcount = info.lastSRpacketcount;
        this.lastRTCPreceiptTime = info.lastRTCPreceiptTime;
        this.lastSRreceiptTime = info.lastSRreceiptTime;
        this.lastHeardFrom = info.lastHeardFrom;
        this.quiet = info.quiet;
        this.inactivesent = info.inactivesent;
        this.aging = info.aging;
        this.reports = info.reports;
        this.ours = info.ours;
        this.ssrc = info.ssrc;
        this.streamconnect = info.streamconnect;
        this.newrecvstream = info.newrecvstream;
        this.recvstrmap = info.recvstrmap;
        this.newpartsent = info.newpartsent;
        this.lastsr = info.lastsr;
        this.probation = info.probation;
        this.wassender = info.wassender;
        this.prevmaxseq = info.prevmaxseq;
        this.prevlost = info.prevlost;
        this.starttime = info.starttime;
        this.reporter = info.reporter;
        if (info.reporter != null) {
            this.reporter.transmit.setSSRCInfo(this);
        }
        this.payloadType = info.payloadType;
        this.dsource = info.dsource;
        this.pds = info.pds;
        this.dstream = info.dstream;
        this.lastRTPReceiptTime = info.lastRTPReceiptTime;
        this.maxseq = info.maxseq;
        this.cycles = info.cycles;
        this.baseseq = info.baseseq;
        this.lastbadseq = info.lastbadseq;
        this.received = info.received;
        this.lasttimestamp = info.lasttimestamp;
        this.lastPayloadType = info.lastPayloadType;
        this.jitter = info.jitter;
        this.bytesreceived = info.bytesreceived;
        this.address = info.address;
        this.port = info.port;
        this.stats = info.stats;
        this.clockrate = info.clockrate;
        this.byeTime = info.byeTime;
        this.byeReceived = info.byeReceived;
    }

    void addSDESInfo(RTCPSDES chunk) {
        int ci;
        for (ci = 0; ci < chunk.items.length && chunk.items[ci].type != 1; ++ci) {
        }
        String s = new String(chunk.items[ci].data);
        String sourceinfocname = null;
        if (this.sourceInfo != null) {
            sourceinfocname = this.sourceInfo.getCNAME();
        }
        if (this.sourceInfo != null && !s.equals(sourceinfocname)) {
            this.sourceInfo.removeSSRC(this);
            this.sourceInfo = null;
        }
        if (this.sourceInfo == null) {
            this.sourceInfo = this.cache.sourceInfoCache.get(s, this.ours);
            this.sourceInfo.addSSRC(this);
        }
        if (chunk.items.length > 1) {
            block10: for (int i = 0; i < chunk.items.length; ++i) {
                s = new String(chunk.items[i].data);
                switch (chunk.items[i].type) {
                    default: {
                        continue block10;
                    }
                    case 2: {
                        if (this.name == null) {
                            this.name = new SourceDescription(2, s, 0, false);
                            continue block10;
                        }
                        this.name.setDescription(s);
                        continue block10;
                    }
                    case 3: {
                        if (this.email == null) {
                            this.email = new SourceDescription(3, s, 0, false);
                            continue block10;
                        }
                        this.email.setDescription(s);
                        continue block10;
                    }
                    case 4: {
                        if (this.phone == null) {
                            this.phone = new SourceDescription(4, s, 0, false);
                            continue block10;
                        }
                        this.phone.setDescription(s);
                        continue block10;
                    }
                    case 5: {
                        if (this.loc == null) {
                            this.loc = new SourceDescription(5, s, 0, false);
                            continue block10;
                        }
                        this.loc.setDescription(s);
                        continue block10;
                    }
                    case 6: {
                        if (this.tool == null) {
                            this.tool = new SourceDescription(6, s, 0, false);
                            continue block10;
                        }
                        this.tool.setDescription(s);
                        continue block10;
                    }
                    case 7: {
                        if (this.note == null) {
                            this.note = new SourceDescription(7, s, 0, false);
                            continue block10;
                        }
                        this.note.setDescription(s);
                        continue block10;
                    }
                    case 8: {
                        if (this.priv == null) {
                            this.priv = new SourceDescription(8, s, 0, false);
                            continue block10;
                        }
                        this.priv.setDescription(s);
                    }
                }
            }
        }
    }

    void delete() {
        if (this.sourceInfo != null) {
            this.sourceInfo.removeSSRC(this);
        }
    }

    public String getCNAME() {
        return this.sourceInfo != null ? this.sourceInfo.getCNAME() : null;
    }

    @Override
    public Vector<RTCPReportBlock> getFeedbackReports() {
        Vector<RTCPReportBlock> reportlist = new Vector<RTCPReportBlock>(this.reports.size());
        if (this.reports.size() == 0) {
            return reportlist;
        }
        Enumeration<RTCPReportBlock[]> reportblks = this.reports.elements();
        try {
            while (reportblks.hasMoreElements()) {
                RTCPReportBlock[] reportblklist = reportblks.nextElement();
                RTCPReportBlock report = reportblklist[0];
                reportlist.addElement(report);
            }
        }
        catch (NoSuchElementException e) {
            System.err.println("No more elements");
        }
        reportlist.trimToSize();
        return reportlist;
    }

    @Override
    public Participant getParticipant() {
        if (this.sourceInfo instanceof LocalParticipant && this.cache.sm.IsNonParticipating()) {
            return null;
        }
        return this.sourceInfo;
    }

    int getPayloadType() {
        return this.payloadType;
    }

    RTPSourceInfo getRTPSourceInfo() {
        return this.sourceInfo;
    }

    @Override
    public Vector<SourceDescription> getSourceDescription() {
        Vector<SourceDescription> sdeslist = new Vector<SourceDescription>();
        sdeslist.addElement(this.sourceInfo.getCNAMESDES());
        if (this.name != null) {
            sdeslist.addElement(this.name);
        }
        if (this.email != null) {
            sdeslist.addElement(this.email);
        }
        if (this.phone != null) {
            sdeslist.addElement(this.phone);
        }
        if (this.loc != null) {
            sdeslist.addElement(this.loc);
        }
        if (this.tool != null) {
            sdeslist.addElement(this.tool);
        }
        if (this.note != null) {
            sdeslist.addElement(this.note);
        }
        if (this.priv != null) {
            sdeslist.addElement(this.priv);
        }
        sdeslist.trimToSize();
        return sdeslist;
    }

    @Override
    public long getSSRC() {
        return this.ssrc;
    }

    public SSRCCache getSSRCCache() {
        return this.cache;
    }

    private void InitSDES() {
        this.name = new SourceDescription(2, null, 0, false);
        this.email = new SourceDescription(3, null, 0, false);
        this.phone = new SourceDescription(4, null, 0, false);
        this.loc = new SourceDescription(5, null, 0, false);
        this.tool = new SourceDescription(6, null, 0, false);
        this.note = new SourceDescription(7, null, 0, false);
        this.priv = new SourceDescription(8, null, 0, false);
    }

    void initsource(int seqnum) {
        if (this.probation <= 0) {
            this.active = true;
            this.setSender(true);
        }
        this.baseseq = seqnum;
        this.maxseq = seqnum - 1;
        this.lastbadseq = -2;
        this.cycles = 0;
        this.received = 0;
        this.bytesreceived = 0;
        this.lastRTPReceiptTime = 0L;
        this.lasttimestamp = 0L;
        this.jitter = 0.0;
        this.prevmaxseq = this.maxseq;
        this.prevlost = 0;
    }

    boolean isActive() {
        return this.active;
    }

    void setAging(boolean beaging) {
        if (this.aging != beaging) {
            this.aging = beaging;
        }
    }

    void setAlive(boolean bealive) {
        this.setAging(false);
        if (this.alive == bealive) {
            return;
        }
        if (bealive) {
            this.reports.removeAll();
        } else {
            this.setSender(false);
        }
        this.alive = bealive;
    }

    public void setOurs(boolean beours) {
        if (this.ours == beours) {
            return;
        }
        if (beours) {
            this.setAlive(true);
        } else {
            this.setAlive(false);
        }
        this.ours = beours;
    }

    void setSender(boolean besender) {
        if (this.sender == besender) {
            return;
        }
        if (besender) {
            ++this.cache.sendercount;
            this.setAlive(true);
        } else {
            --this.cache.sendercount;
        }
        this.sender = besender;
    }

    void setSourceDescription(SourceDescription[] userdesclist) {
        if (userdesclist == null) {
            return;
        }
        String cname = null;
        for (SourceDescription currdesc : userdesclist) {
            if (currdesc == null || currdesc.getType() != 1) continue;
            cname = currdesc.getDescription();
            break;
        }
        String sourceinfocname = null;
        if (this.sourceInfo != null) {
            sourceinfocname = this.sourceInfo.getCNAME();
        }
        if (this.sourceInfo != null && cname != null && !cname.equals(sourceinfocname)) {
            this.sourceInfo.removeSSRC(this);
            this.sourceInfo = null;
        }
        if (this.sourceInfo == null) {
            this.sourceInfo = this.cache.sourceInfoCache.get(cname, true);
            this.sourceInfo.addSSRC(this);
        }
        block10: for (SourceDescription currdesc : userdesclist) {
            if (currdesc == null) continue;
            switch (currdesc.getType()) {
                default: {
                    continue block10;
                }
                case 2: {
                    if (this.name == null) {
                        this.name = new SourceDescription(2, currdesc.getDescription(), 0, false);
                        continue block10;
                    }
                    this.name.setDescription(currdesc.getDescription());
                    continue block10;
                }
                case 3: {
                    if (this.email == null) {
                        this.email = new SourceDescription(3, currdesc.getDescription(), 0, false);
                        continue block10;
                    }
                    this.email.setDescription(currdesc.getDescription());
                    continue block10;
                }
                case 4: {
                    if (this.phone == null) {
                        this.phone = new SourceDescription(4, currdesc.getDescription(), 0, false);
                        continue block10;
                    }
                    this.phone.setDescription(currdesc.getDescription());
                    continue block10;
                }
                case 5: {
                    if (this.loc == null) {
                        this.loc = new SourceDescription(5, currdesc.getDescription(), 0, false);
                        continue block10;
                    }
                    this.loc.setDescription(currdesc.getDescription());
                    continue block10;
                }
                case 6: {
                    if (this.tool == null) {
                        this.tool = new SourceDescription(6, currdesc.getDescription(), 0, false);
                        continue block10;
                    }
                    this.tool.setDescription(currdesc.getDescription());
                    continue block10;
                }
                case 7: {
                    if (this.note == null) {
                        this.note = new SourceDescription(7, currdesc.getDescription(), 0, false);
                        continue block10;
                    }
                    this.note.setDescription(currdesc.getDescription());
                    continue block10;
                }
                case 8: {
                    if (this.priv == null) {
                        this.priv = new SourceDescription(8, currdesc.getDescription(), 0, false);
                        continue block10;
                    }
                    this.priv.setDescription(currdesc.getDescription());
                }
            }
        }
    }

    public long getExpectedPacketCount() {
        long maxseq = (long)this.maxseq & 0xFFFFL;
        long cycles = this.cycles;
        long baseseq = (long)this.baseseq & 0xFFFFL;
        return maxseq + cycles - baseseq + 1L;
    }

    public RTCPReportBlock makeReceiverReport(long time) {
        double frac;
        RTCPReportBlock receiverReport = new RTCPReportBlock();
        receiverReport.ssrc = this.ssrc;
        receiverReport.lastseq = this.maxseq + this.cycles;
        receiverReport.jitter = (int)this.jitter;
        receiverReport.lsr = (int)((this.lastSRntptimestamp & 0xFFFFFFFF0000L) >> 16);
        receiverReport.dlsr = (int)((double)(time - this.lastSRreceiptTime) * 65.536);
        receiverReport.packetslost = (int)(receiverReport.lastseq - (long)this.baseseq + 1L - (long)this.received);
        if (receiverReport.packetslost < 0) {
            receiverReport.packetslost = 0;
        }
        if ((frac = (double)(receiverReport.packetslost - this.prevlost) / (double)(receiverReport.lastseq - (long)this.prevmaxseq)) < 0.0) {
            frac = 0.0;
        }
        receiverReport.fractionlost = (int)(frac * 256.0);
        this.prevmaxseq = (int)receiverReport.lastseq;
        this.prevlost = receiverReport.packetslost;
        return receiverReport;
    }

    public int extendSequenceNumber(int seqnum) {
        int cycles = this.cycles;
        int maxseq = this.maxseq;
        int delta = seqnum - maxseq;
        if (delta >= 0) {
            if (delta > Short.MAX_VALUE) {
                cycles -= 65536;
            }
        } else if (delta < -32767) {
            cycles += 65536;
        }
        return seqnum + cycles;
    }
}

