/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.lookandfeel.SIPCommBorders;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactListSearchKeyDispatcher;
import net.java.sip.communicator.impl.gui.main.contactlist.SearchField;
import net.java.sip.communicator.impl.gui.utils.InviteContactListFilter;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.gui.ContactList;
import net.java.sip.communicator.service.gui.ContactListContainer;
import net.java.sip.communicator.service.gui.ContactListFilter;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.gui.event.ContactListEvent;
import net.java.sip.communicator.service.gui.event.ContactListListener;

public class OneChoiceInviteDialog
extends SIPCommDialog
implements ContactListContainer {
    private final JTextArea infoTextArea;
    private final JLabel infoIconLabel = new JLabel();
    private final JButton okButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.OK"));
    private final JButton cancelButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.CANCEL"));
    protected ContactList contactList;
    private final SearchField searchField;

    public OneChoiceInviteDialog(String title) {
        this.setModal(false);
        this.setTitle(title);
        TransparentPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
        TransparentPanel northPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
        mainPanel.setPreferredSize(new Dimension(450, 350));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        this.infoTextArea = this.createInfoArea();
        northPanel.add((Component)this.infoIconLabel, (Object)"West");
        northPanel.add((Component)this.infoTextArea, (Object)"Center");
        TransparentPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
        buttonsPanel.add((Component)this.okButton);
        buttonsPanel.add((Component)this.cancelButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.OK"));
        this.cancelButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.CANCEL"));
        Component contactListComponent = this.createContactListComponent();
        InviteContactListFilter inviteFilter = new InviteContactListFilter(this.contactList);
        this.contactList.setDefaultFilter((ContactListFilter)inviteFilter);
        this.searchField = new SearchField(null, inviteFilter, false, false);
        this.searchField.setPreferredSize(new Dimension(200, 25));
        this.searchField.setContactList(this.contactList);
        this.searchField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                OneChoiceInviteDialog.this.contactList.removeSelection();
            }
        });
        TransparentPanel listPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        listPanel.setBorder(SIPCommBorders.getRoundBorder());
        listPanel.add(contactListComponent);
        northPanel.add((Component)((Object)this.searchField), (Object)"South");
        mainPanel.add((Component)northPanel, (Object)"North");
        mainPanel.add((Component)listPanel, (Object)"Center");
        mainPanel.add((Component)buttonsPanel, (Object)"South");
        this.getContentPane().add((Component)mainPanel);
        KeyboardFocusManager keyManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        ContactListSearchKeyDispatcher clKeyDispatcher = new ContactListSearchKeyDispatcher(keyManager, this.searchField, this);
        clKeyDispatcher.setContactList(this.contactList);
        keyManager.addKeyEventDispatcher(clKeyDispatcher);
    }

    public UIContact getSelectedContact() {
        return this.contactList.getSelectedContact();
    }

    public String getSelectedString() {
        return this.searchField.getText();
    }

    public void setInfoText(String text) {
        this.infoTextArea.setText(text);
    }

    public void setIcon(Icon icon) {
        this.infoIconLabel.setIcon(icon);
    }

    public void setOkButtonText(String text) {
        this.okButton.setText(text);
    }

    public void addOkButtonListener(ActionListener l) {
        this.okButton.addActionListener(l);
    }

    public void addCancelButtonListener(ActionListener l) {
        this.cancelButton.addActionListener(l);
    }

    protected void close(boolean isEscaped) {
        this.cancelButton.doClick();
    }

    private JTextArea createInfoArea() {
        JTextArea infoTextArea = new JTextArea();
        infoTextArea.setFont(infoTextArea.getFont().deriveFont(1));
        infoTextArea.setLineWrap(true);
        infoTextArea.setOpaque(false);
        infoTextArea.setWrapStyleWord(true);
        infoTextArea.setEditable(false);
        return infoTextArea;
    }

    private Component createContactListComponent() {
        this.contactList = GuiActivator.getUIService().createContactListComponent(this);
        this.contactList.setContactButtonsVisible(false);
        this.contactList.setRightButtonMenuEnabled(false);
        this.contactList.addContactListListener(new ContactListListener(){

            public void groupSelected(ContactListEvent evt) {
            }

            public void groupClicked(ContactListEvent evt) {
            }

            public void contactSelected(ContactListEvent evt) {
            }

            public void contactClicked(ContactListEvent evt) {
                int clickCount = evt.getClickCount();
                if (clickCount > 1) {
                    OneChoiceInviteDialog.this.okButton.doClick();
                }
            }
        });
        JScrollPane contactListScrollPane = new JScrollPane();
        contactListScrollPane.setOpaque(false);
        contactListScrollPane.getViewport().setOpaque(false);
        contactListScrollPane.getViewport().add(this.contactList.getComponent());
        contactListScrollPane.getViewport().setBorder(null);
        contactListScrollPane.setViewportBorder(null);
        contactListScrollPane.setBorder(null);
        return contactListScrollPane;
    }

    protected void addContact(UIContact contact) {
        this.contactList.addContact(contact, null, true, false);
    }

    public void enterKeyTyped() {
        UIContact selectedContact = this.contactList.getSelectedContact();
        if (selectedContact != null) {
            this.okButton.doClick();
        }
    }

    public String getCurrentSearchText() {
        return this.searchField.getText();
    }

    public void clearCurrentSearchText() {
        this.searchField.setText("");
    }

    public void ctrlEnterKeyTyped() {
    }

    public boolean isMenuSelected() {
        return false;
    }

    public void dispose() {
        this.searchField.dispose();
        super.dispose();
    }
}

