/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import junit.framework.Assert;
import junit.framework.TestCase;
import net.java.sip.communicator.impl.gui.main.contactlist.GroupNode;
import net.java.sip.communicator.service.gui.ContactListNode;

public class GroupNodeTest
extends TestCase {
    public void testNodeComparatorUnknownsAtTheEnd() {
        ContactListNode unknown = new ContactListNode(){

            public int getSourceIndex() {
                return -1;
            }
        };
        ContactListNode node = new ContactListNode(){

            public int getSourceIndex() {
                return 1;
            }
        };
        GroupNode.NodeComparator comparator = new GroupNode.NodeComparator();
        Assert.assertEquals((int)comparator.compare(unknown, node), (int)(-1 * comparator.compare(node, unknown)));
        Assert.assertEquals((int)1, (int)comparator.compare(unknown, node));
        Assert.assertEquals((int)-1, (int)comparator.compare(node, unknown));
    }

    public void testNodeComparatorNormalNodes() {
        ContactListNode node1 = new ContactListNode(){

            public int getSourceIndex() {
                return 4;
            }
        };
        ContactListNode node2 = new ContactListNode(){

            public int getSourceIndex() {
                return 7;
            }
        };
        GroupNode.NodeComparator comparator = new GroupNode.NodeComparator();
        Assert.assertEquals((int)comparator.compare(node1, node2), (int)(-1 * comparator.compare(node2, node1)));
        Assert.assertEquals((int)-1, (int)comparator.compare(node1, node2));
        Assert.assertEquals((int)1, (int)comparator.compare(node2, node1));
    }

    public void testNodeComparatorSymmetryForUnknownNodes() {
        ContactListNode unknown1 = new ContactListNode(){

            public int getSourceIndex() {
                return -1;
            }
        };
        ContactListNode unknown2 = new ContactListNode(){

            public int getSourceIndex() {
                return -1;
            }
        };
        GroupNode.NodeComparator comparator = new GroupNode.NodeComparator();
        Assert.assertEquals((int)comparator.compare(unknown1, unknown2), (int)(-1 * comparator.compare(unknown2, unknown1)));
    }
}

