/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat;

import java.awt.Image;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.ImageIcon;
import net.java.sip.communicator.impl.gui.main.chat.ChatSession;
import net.java.sip.communicator.impl.gui.main.chat.ChatTransport;
import net.java.sip.communicator.impl.gui.main.chat.MetaContactChatSession;
import net.java.sip.communicator.impl.gui.utils.SMSManager;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactResource;
import net.java.sip.communicator.service.protocol.FileTransfer;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetContactCapabilities;
import net.java.sip.communicator.service.protocol.OperationSetFileTransfer;
import net.java.sip.communicator.service.protocol.OperationSetMessageCorrection;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.OperationSetSmsMessaging;
import net.java.sip.communicator.service.protocol.OperationSetThumbnailedFileFactory;
import net.java.sip.communicator.service.protocol.OperationSetTypingNotifications;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusListener;
import net.java.sip.communicator.service.protocol.event.MessageListener;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.FileUtils;
import net.java.sip.communicator.util.Logger;

public class MetaContactChatTransport
implements ChatTransport,
ContactPresenceStatusListener {
    private static final Logger logger = Logger.getLogger(MetaContactChatTransport.class);
    private final MetaContactChatSession parentChatSession;
    private final Contact contact;
    private ContactResource contactResource;
    private final OperationSetPresence presenceOpSet;
    private static final int THUMBNAIL_WIDTH = 64;
    private static final int THUMBNAIL_HEIGHT = 64;
    private boolean isDisplayResourceOnly = false;

    public MetaContactChatTransport(MetaContactChatSession chatSession, Contact contact) {
        this(chatSession, contact, null, false);
    }

    public MetaContactChatTransport(MetaContactChatSession chatSession, Contact contact, ContactResource contactResource, boolean isDisplayResourceOnly) {
        this.parentChatSession = chatSession;
        this.contact = contact;
        this.contactResource = contactResource;
        this.isDisplayResourceOnly = isDisplayResourceOnly;
        this.presenceOpSet = (OperationSetPresence)contact.getProtocolProvider().getOperationSet(OperationSetPresence.class);
        if (this.presenceOpSet != null) {
            this.presenceOpSet.addContactPresenceStatusListener((ContactPresenceStatusListener)this);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                MetaContactChatTransport.this.checkImCaps();
            }
        }).start();
    }

    private void checkImCaps() {
        OperationSetBasicInstantMessaging imOpSet;
        if (ConfigurationUtils.getChatDefaultFontFamily() != null && ConfigurationUtils.getChatDefaultFontSize() > 0 && (imOpSet = (OperationSetBasicInstantMessaging)this.contact.getProtocolProvider().getOperationSet(OperationSetBasicInstantMessaging.class)) != null) {
            imOpSet.isContentTypeSupported("text/html", this.contact);
        }
    }

    public Contact getContact() {
        return this.contact;
    }

    @Override
    public String getName() {
        return this.contact.getAddress();
    }

    @Override
    public String getDisplayName() {
        return this.contact.getDisplayName();
    }

    @Override
    public String getResourceName() {
        if (this.contactResource != null) {
            return this.contactResource.getResourceName();
        }
        return null;
    }

    @Override
    public boolean isDisplayResourceOnly() {
        return this.isDisplayResourceOnly;
    }

    @Override
    public PresenceStatus getStatus() {
        if (this.contactResource != null) {
            return this.contactResource.getPresenceStatus();
        }
        return this.contact.getPresenceStatus();
    }

    @Override
    public ProtocolProviderService getProtocolProvider() {
        return this.contact.getProtocolProvider();
    }

    @Override
    public boolean allowsInstantMessage() {
        OperationSetContactCapabilities capOpSet = (OperationSetContactCapabilities)this.getProtocolProvider().getOperationSet(OperationSetContactCapabilities.class);
        return capOpSet != null ? capOpSet.getOperationSet(this.contact, OperationSetBasicInstantMessaging.class) != null : this.contact.getProtocolProvider().getOperationSet(OperationSetBasicInstantMessaging.class) != null;
    }

    @Override
    public boolean allowsMessageCorrections() {
        OperationSetContactCapabilities capOpSet = (OperationSetContactCapabilities)this.getProtocolProvider().getOperationSet(OperationSetContactCapabilities.class);
        if (capOpSet != null) {
            return capOpSet.getOperationSet(this.contact, OperationSetMessageCorrection.class) != null;
        }
        return this.contact.getProtocolProvider().getOperationSet(OperationSetMessageCorrection.class) != null;
    }

    @Override
    public boolean allowsSmsMessage() {
        OperationSetContactCapabilities capOpSet = (OperationSetContactCapabilities)this.getProtocolProvider().getOperationSet(OperationSetContactCapabilities.class);
        return capOpSet != null ? capOpSet.getOperationSet(this.contact, OperationSetSmsMessaging.class) != null : this.contact.getProtocolProvider().getOperationSet(OperationSetSmsMessaging.class) != null;
    }

    @Override
    public boolean allowsTypingNotifications() {
        OperationSet tnOpSet = this.contact.getProtocolProvider().getOperationSet(OperationSetTypingNotifications.class);
        return tnOpSet != null;
    }

    public boolean allowsFileTransfer() {
        OperationSet ftOpSet = this.contact.getProtocolProvider().getOperationSet(OperationSetFileTransfer.class);
        return ftOpSet != null;
    }

    @Override
    public void sendInstantMessage(String message, String mimeType) throws Exception {
        if (!this.allowsInstantMessage()) {
            return;
        }
        OperationSetBasicInstantMessaging imOpSet = (OperationSetBasicInstantMessaging)this.contact.getProtocolProvider().getOperationSet(OperationSetBasicInstantMessaging.class);
        Message msg = mimeType.equals("text/html") && imOpSet.isContentTypeSupported("text/html") ? imOpSet.createMessage(message, "text/html", "utf-8", "") : imOpSet.createMessage(message);
        if (this.contactResource != null) {
            imOpSet.sendInstantMessage(this.contact, this.contactResource, msg);
        } else {
            imOpSet.sendInstantMessage(this.contact, ContactResource.BASE_RESOURCE, msg);
        }
    }

    @Override
    public void correctInstantMessage(String message, String mimeType, String correctedMessageUID) {
        if (!this.allowsMessageCorrections()) {
            return;
        }
        OperationSetMessageCorrection mcOpSet = (OperationSetMessageCorrection)this.contact.getProtocolProvider().getOperationSet(OperationSetMessageCorrection.class);
        Message msg = mimeType.equals("text/html") && mcOpSet.isContentTypeSupported("text/html") ? mcOpSet.createMessage(message, "text/html", "utf-8", "") : mcOpSet.createMessage(message);
        mcOpSet.correctMessage(this.contact, this.contactResource, msg, correctedMessageUID);
    }

    @Override
    public boolean isContentTypeSupported(String contentType) {
        OperationSetBasicInstantMessaging imOpSet = (OperationSetBasicInstantMessaging)this.contact.getProtocolProvider().getOperationSet(OperationSetBasicInstantMessaging.class);
        if (imOpSet != null) {
            return imOpSet.isContentTypeSupported(contentType);
        }
        return false;
    }

    @Override
    public void sendSmsMessage(String phoneNumber, String messageText) throws Exception {
        if (!this.allowsSmsMessage()) {
            return;
        }
        SMSManager.sendSMS(this.contact.getProtocolProvider(), phoneNumber, messageText);
    }

    @Override
    public boolean askForSMSNumber() {
        if (!this.allowsSmsMessage()) {
            return false;
        }
        OperationSetSmsMessaging smsOpSet = (OperationSetSmsMessaging)this.contact.getProtocolProvider().getOperationSet(OperationSetSmsMessaging.class);
        return smsOpSet.askForNumber(this.contact);
    }

    @Override
    public void sendSmsMessage(String message) throws Exception {
        if (!this.allowsSmsMessage()) {
            return;
        }
        SMSManager.sendSMS(this.contact, message);
    }

    @Override
    public int sendTypingNotification(int typingState) {
        if (!this.allowsTypingNotifications()) {
            return -1;
        }
        ProtocolProviderService protocolProvider = this.contact.getProtocolProvider();
        OperationSetTypingNotifications tnOperationSet = (OperationSetTypingNotifications)protocolProvider.getOperationSet(OperationSetTypingNotifications.class);
        if (protocolProvider.isRegistered() && this.contact.getPresenceStatus().getStatus() >= 20) {
            try {
                tnOperationSet.sendTypingNotification(this.contact, typingState);
                return 1;
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to send typing notifications.", (Throwable)ex);
                return 0;
            }
        }
        return 0;
    }

    @Override
    public FileTransfer sendFile(File file) throws Exception {
        return this.sendFile(file, false);
    }

    private FileTransfer sendFile(File file, boolean isMultimediaMessage) throws Exception {
        byte[] thumbnail;
        OperationSetThumbnailedFileFactory tfOpSet;
        if (!this.allowsFileTransfer()) {
            return null;
        }
        if (FileUtils.isImage((String)file.getName()) && (tfOpSet = (OperationSetThumbnailedFileFactory)this.contact.getProtocolProvider().getOperationSet(OperationSetThumbnailedFileFactory.class)) != null && (thumbnail = this.getFileThumbnail(file)) != null && thumbnail.length > 0) {
            file = tfOpSet.createFileWithThumbnail(file, 64, 64, "image/png", thumbnail);
        }
        if (isMultimediaMessage) {
            OperationSetSmsMessaging smsOpSet = (OperationSetSmsMessaging)this.contact.getProtocolProvider().getOperationSet(OperationSetSmsMessaging.class);
            if (smsOpSet == null) {
                return null;
            }
            return smsOpSet.sendMultimediaFile(this.contact, file);
        }
        OperationSetFileTransfer ftOpSet = (OperationSetFileTransfer)this.contact.getProtocolProvider().getOperationSet(OperationSetFileTransfer.class);
        return ftOpSet.sendFile(this.contact, file);
    }

    @Override
    public FileTransfer sendMultimediaFile(File file) throws Exception {
        return this.sendFile(file, true);
    }

    @Override
    public long getMaximumFileLength() {
        OperationSetFileTransfer ftOpSet = (OperationSetFileTransfer)this.contact.getProtocolProvider().getOperationSet(OperationSetFileTransfer.class);
        return ftOpSet.getMaximumFileLength();
    }

    @Override
    public void inviteChatContact(String contactAddress, String reason) {
    }

    @Override
    public ChatSession getParentChatSession() {
        return this.parentChatSession;
    }

    @Override
    public void addSmsMessageListener(MessageListener l) {
        if (!this.allowsSmsMessage()) {
            return;
        }
        OperationSetSmsMessaging smsOpSet = (OperationSetSmsMessaging)this.contact.getProtocolProvider().getOperationSet(OperationSetSmsMessaging.class);
        smsOpSet.addMessageListener(l);
    }

    @Override
    public void addInstantMessageListener(MessageListener l) {
        if (!this.allowsInstantMessage()) {
            return;
        }
        OperationSetBasicInstantMessaging imOpSet = (OperationSetBasicInstantMessaging)this.contact.getProtocolProvider().getOperationSet(OperationSetBasicInstantMessaging.class);
        imOpSet.addMessageListener(l);
    }

    @Override
    public void removeSmsMessageListener(MessageListener l) {
        if (!this.allowsSmsMessage()) {
            return;
        }
        OperationSetSmsMessaging smsOpSet = (OperationSetSmsMessaging)this.contact.getProtocolProvider().getOperationSet(OperationSetSmsMessaging.class);
        smsOpSet.removeMessageListener(l);
    }

    @Override
    public void removeInstantMessageListener(MessageListener l) {
        if (!this.allowsInstantMessage()) {
            return;
        }
        OperationSetBasicInstantMessaging imOpSet = (OperationSetBasicInstantMessaging)this.contact.getProtocolProvider().getOperationSet(OperationSetBasicInstantMessaging.class);
        imOpSet.removeMessageListener(l);
    }

    public void contactPresenceStatusChanged(ContactPresenceStatusChangeEvent evt) {
        if (evt.getSourceContact().equals(this.contact) && !evt.getOldStatus().equals((Object)evt.getNewStatus()) && this.contactResource == null) {
            this.updateContactStatus();
        }
    }

    private void updateContactStatus() {
        this.parentChatSession.getChatSessionRenderer().updateChatTransportStatus(this);
    }

    @Override
    public void dispose() {
        if (this.presenceOpSet != null) {
            this.presenceOpSet.removeContactPresenceStatusListener((ContactPresenceStatusListener)this);
        }
    }

    @Override
    public Object getDescriptor() {
        return this.contact;
    }

    private byte[] getFileThumbnail(File file) {
        byte[] bytes;
        block5: {
            bytes = null;
            if (FileUtils.isImage((String)file.getName())) {
                try {
                    ImageIcon image = new ImageIcon(file.toURI().toURL());
                    int width = image.getIconWidth();
                    int height = image.getIconHeight();
                    if (width > 64) {
                        width = 64;
                    }
                    if (height > 64) {
                        height = 64;
                    }
                    bytes = ImageUtils.getScaledInstanceInBytes((Image)image.getImage(), (int)width, (int)height);
                }
                catch (MalformedURLException e) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug((Object)"Could not locate image.", (Throwable)e);
                }
            }
        }
        return bytes;
    }
}

