/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.OperationSetDesktopSharingClient;
import net.java.sip.communicator.service.protocol.event.RemoteControlGrantedEvent;
import net.java.sip.communicator.service.protocol.event.RemoteControlListener;
import net.java.sip.communicator.service.protocol.event.RemoteControlRevokedEvent;

public class DesktopSharingMouseAndKeyboardListener
implements RemoteControlListener,
KeyListener,
MouseListener,
MouseMotionListener {
    private final CallPeer callPeer;
    private final OperationSetDesktopSharingClient desktopSharingClient;
    private Component videoComponent = null;
    private final Object videoComponentMutex = new Object();

    public DesktopSharingMouseAndKeyboardListener(CallPeer callPeer) {
        this(callPeer, (OperationSetDesktopSharingClient)callPeer.getProtocolProvider().getOperationSet(OperationSetDesktopSharingClient.class));
    }

    public DesktopSharingMouseAndKeyboardListener(CallPeer callPeer, OperationSetDesktopSharingClient desktopSharingClient) {
        this.callPeer = callPeer;
        this.desktopSharingClient = desktopSharingClient;
    }

    public CallPeer getCallPeer() {
        return this.callPeer;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.desktopSharingClient != null) {
            this.desktopSharingClient.sendKeyboardEvent(this.callPeer, e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.desktopSharingClient != null) {
            this.desktopSharingClient.sendMouseEvent(this.callPeer, e, this.videoComponent.getSize());
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.desktopSharingClient != null) {
            this.desktopSharingClient.sendMouseEvent(this.callPeer, e, this.videoComponent.getSize());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.desktopSharingClient != null) {
            this.desktopSharingClient.sendMouseEvent(this.callPeer, e, this.videoComponent.getSize());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.desktopSharingClient != null) {
            this.desktopSharingClient.sendMouseEvent(this.callPeer, e, this.videoComponent.getSize());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.desktopSharingClient != null) {
            this.desktopSharingClient.sendMouseEvent(this.callPeer, e, this.videoComponent.getSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remoteControlGranted(RemoteControlGrantedEvent event) {
        Object object = this.videoComponentMutex;
        synchronized (object) {
            if (this.videoComponent != null) {
                this.videoComponent.addKeyListener(this);
                this.videoComponent.addMouseListener(this);
                this.videoComponent.addMouseMotionListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remoteControlRevoked(RemoteControlRevokedEvent event) {
        Object object = this.videoComponentMutex;
        synchronized (object) {
            if (this.videoComponent != null) {
                this.videoComponent.removeKeyListener(this);
                this.videoComponent.removeMouseListener(this);
                this.videoComponent.removeMouseMotionListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVideoComponent(Component videoComponent) {
        if (this.desktopSharingClient == null) {
            return;
        }
        Object object = this.videoComponentMutex;
        synchronized (object) {
            if (this.videoComponent == null) {
                if (videoComponent != null) {
                    this.desktopSharingClient.addRemoteControlListener((RemoteControlListener)this);
                }
            } else if (videoComponent == null) {
                this.desktopSharingClient.removeRemoteControlListener((RemoteControlListener)this);
            }
            this.videoComponent = videoComponent;
        }
    }
}

