/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model.batch;

import com.google.gdata.model.Element;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.QName;
import com.google.gdata.util.Namespaces;

public class BatchId
extends Element {
    public static final ElementKey<String, BatchId> KEY = ElementKey.of(new QName(Namespaces.batchNs, "id"), String.class, BatchId.class);

    public static void registerMetadata(MetadataRegistry registry) {
        if (registry.isRegistered(KEY)) {
            return;
        }
        registry.build(KEY);
    }

    public static String getIdFrom(Element element) {
        BatchId tag = element.getElement(KEY);
        return tag == null ? null : tag.getId();
    }

    public BatchId() {
        super(KEY);
    }

    public BatchId(String id) {
        this();
        this.setId(id);
    }

    public String getId() {
        return (String)super.getTextValue();
    }

    public BatchId setId(String id) {
        super.setTextValue(id);
        return this;
    }

    public boolean hasId() {
        return super.hasTextValue();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        BatchId other = (BatchId)obj;
        return BatchId.eq(this.getId(), other.getId());
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.getId() != null) {
            result = 37 * result + this.getId().hashCode();
        }
        return result;
    }

    @Override
    public String toString() {
        return "{BatchId id=" + this.getTextValue() + "}";
    }
}

