/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;

public class HtmlFoldParser
implements FoldParser {
    public static final int LANGUAGE_HTML = -1;
    public static final int LANGUAGE_PHP = 0;
    public static final int LANGUAGE_JSP = 1;
    private final int language;
    private static final Set<String> FOLDABLE_TAGS;
    private static final char[] MARKUP_CLOSING_TAG_START;
    private static final char[] MLC_START;
    private static final char[] MLC_END;
    private static final char[] PHP_START;
    private static final char[] PHP_END;
    private static final char[] JSP_START;
    private static final char[] JSP_END;
    private static final char[][] LANG_START;
    private static final char[][] LANG_END;
    private static final char[] JSP_COMMENT_START;
    private static final char[] JSP_COMMENT_END;

    public HtmlFoldParser(int n) {
        if (n < -1 && n > 1) {
            throw new IllegalArgumentException("Invalid language: " + n);
        }
        this.language = n;
    }

    @Override
    public List<Fold> getFolds(RSyntaxTextArea rSyntaxTextArea) {
        ArrayList<Fold> arrayList = new ArrayList<Fold>();
        Stack<String> stack = new Stack<String>();
        boolean bl = false;
        Object object = null;
        int n = rSyntaxTextArea.getLineCount();
        boolean bl2 = false;
        boolean bl3 = false;
        TagCloseInfo tagCloseInfo = new TagCloseInfo();
        try {
            for (int i = 0; i < n; ++i) {
                Token token = rSyntaxTextArea.getTokenListForLine(i);
                while (token != null && token.isPaintable()) {
                    Object object2;
                    int n2;
                    if (this.language >= 0 && token.getType() == 22) {
                        if (token.startsWith(LANG_START[this.language])) {
                            if (object == null) {
                                object = new Fold(0, rSyntaxTextArea, token.getOffset());
                                arrayList.add((Fold)object);
                            } else {
                                object = ((Fold)object).createChild(0, token.getOffset());
                            }
                            bl = true;
                        } else if (token.startsWith(LANG_END[this.language])) {
                            n2 = token.getEndOffset() - 1;
                            ((Fold)object).setEndOffset(n2);
                            object2 = ((Fold)object).getParent();
                            if (((Fold)object).isOnSingleLine()) {
                                HtmlFoldParser.removeFold((Fold)object, arrayList);
                            }
                            object = object2;
                            bl = false;
                            token = token.getNextToken();
                            continue;
                        }
                    }
                    if (!bl) {
                        Token token2;
                        if (token.getType() == 2) {
                            if (bl2) {
                                if (token.endsWith(MLC_END)) {
                                    n2 = token.getEndOffset() - 1;
                                    ((Fold)object).setEndOffset(n2);
                                    object2 = ((Fold)object).getParent();
                                    if (((Fold)object).isOnSingleLine()) {
                                        HtmlFoldParser.removeFold((Fold)object, arrayList);
                                    }
                                    object = object2;
                                    bl2 = false;
                                }
                            } else if (bl3) {
                                if (token.endsWith(JSP_COMMENT_END)) {
                                    n2 = token.getEndOffset() - 1;
                                    ((Fold)object).setEndOffset(n2);
                                    object2 = ((Fold)object).getParent();
                                    if (((Fold)object).isOnSingleLine()) {
                                        HtmlFoldParser.removeFold((Fold)object, arrayList);
                                    }
                                    object = object2;
                                    bl3 = false;
                                }
                            } else if (token.startsWith(MLC_START) && !token.endsWith(MLC_END)) {
                                if (object == null) {
                                    object = new Fold(1, rSyntaxTextArea, token.getOffset());
                                    arrayList.add((Fold)object);
                                } else {
                                    object = ((Fold)object).createChild(1, token.getOffset());
                                }
                                bl2 = true;
                            } else if (this.language == 1 && token.startsWith(JSP_COMMENT_START) && !token.endsWith(JSP_COMMENT_END)) {
                                if (object == null) {
                                    object = new Fold(1, rSyntaxTextArea, token.getOffset());
                                    arrayList.add((Fold)object);
                                } else {
                                    object = ((Fold)object).createChild(1, token.getOffset());
                                }
                                bl3 = true;
                            }
                        } else if (token.isSingleChar(25, '<')) {
                            Token token3 = token;
                            object2 = token.getNextToken();
                            if (HtmlFoldParser.isFoldableTag((Token)object2)) {
                                int n3 = this.getTagCloseInfo((Token)object2, rSyntaxTextArea, i, tagCloseInfo);
                                if (tagCloseInfo.line == -1) {
                                    return arrayList;
                                }
                                System.out.println(i + ", " + tagCloseInfo + ", " + token);
                                Token token4 = tagCloseInfo.closeToken;
                                if (token4.isSingleChar(25, '>')) {
                                    if (object == null) {
                                        object = new Fold(0, rSyntaxTextArea, token3.getOffset());
                                        arrayList.add((Fold)object);
                                    } else {
                                        object = ((Fold)object).createChild(0, token3.getOffset());
                                    }
                                    stack.push(object2.getLexeme());
                                }
                                token = token4;
                                i = n3;
                            }
                        } else if (token.is(25, MARKUP_CLOSING_TAG_START) && object != null && HtmlFoldParser.isFoldableTag(token2 = token.getNextToken()) && HtmlFoldParser.isEndOfLastFold(stack, token2)) {
                            stack.pop();
                            ((Fold)object).setEndOffset(token.getOffset());
                            object2 = ((Fold)object).getParent();
                            if (((Fold)object).isOnSingleLine()) {
                                HtmlFoldParser.removeFold((Fold)object, arrayList);
                            }
                            object = object2;
                            token = token2;
                        }
                    }
                    token = token.getNextToken();
                }
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return arrayList;
    }

    private int getTagCloseInfo(Token token, RSyntaxTextArea rSyntaxTextArea, int n, TagCloseInfo tagCloseInfo) {
        tagCloseInfo.reset();
        Token token2 = token.getNextToken();
        while (true) {
            if (token2 != null && token2.getType() != 25) {
                token2 = token2.getNextToken();
                continue;
            }
            if (token2 != null) {
                tagCloseInfo.closeToken = token2;
                tagCloseInfo.line = n;
                break;
            }
            if (++n >= rSyntaxTextArea.getLineCount() || (token2 = rSyntaxTextArea.getTokenListForLine(n)) == null) break;
        }
        return n;
    }

    private static final boolean isEndOfLastFold(Stack<String> stack, Token token) {
        if (token != null && !stack.isEmpty()) {
            return token.getLexeme().equalsIgnoreCase(stack.peek());
        }
        return false;
    }

    private static final boolean isFoldableTag(Token token) {
        return token != null && FOLDABLE_TAGS.contains(token.getLexeme().toLowerCase());
    }

    private static final void removeFold(Fold fold, List<Fold> list) {
        if (!fold.removeFromParent()) {
            list.remove(list.size() - 1);
        }
    }

    static {
        MARKUP_CLOSING_TAG_START = "</".toCharArray();
        MLC_START = "<!--".toCharArray();
        MLC_END = "-->".toCharArray();
        PHP_START = "<?".toCharArray();
        PHP_END = "?>".toCharArray();
        JSP_START = "<%".toCharArray();
        JSP_END = "%>".toCharArray();
        LANG_START = new char[][]{PHP_START, JSP_START};
        LANG_END = new char[][]{PHP_END, JSP_END};
        JSP_COMMENT_START = "<%--".toCharArray();
        JSP_COMMENT_END = "--%>".toCharArray();
        FOLDABLE_TAGS = new HashSet<String>();
        FOLDABLE_TAGS.add("body");
        FOLDABLE_TAGS.add("canvas");
        FOLDABLE_TAGS.add("div");
        FOLDABLE_TAGS.add("form");
        FOLDABLE_TAGS.add("head");
        FOLDABLE_TAGS.add("html");
        FOLDABLE_TAGS.add("ol");
        FOLDABLE_TAGS.add("pre");
        FOLDABLE_TAGS.add("script");
        FOLDABLE_TAGS.add("span");
        FOLDABLE_TAGS.add("style");
        FOLDABLE_TAGS.add("table");
        FOLDABLE_TAGS.add("tfoot");
        FOLDABLE_TAGS.add("thead");
        FOLDABLE_TAGS.add("tr");
        FOLDABLE_TAGS.add("td");
        FOLDABLE_TAGS.add("ul");
    }

    private static class TagCloseInfo {
        private Token closeToken;
        private int line;

        private TagCloseInfo() {
        }

        public void reset() {
            this.closeToken = null;
            this.line = -1;
        }

        public String toString() {
            return "[TagCloseInfo: closeToken=" + this.closeToken + ", line=" + this.line + "]";
        }
    }
}

