/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class Fold
implements Comparable<Fold> {
    private int type;
    private RSyntaxTextArea textArea;
    private Position startOffs;
    private Position endOffs;
    private Fold parent;
    private List<Fold> children;
    private boolean collapsed;
    private int childCollapsedLineCount;
    private int lastStartOffs = -1;
    private int cachedStartLine;
    private int lastEndOffs = -1;
    private int cachedEndLine;

    public Fold(int n, RSyntaxTextArea rSyntaxTextArea, int n2) throws BadLocationException {
        this.type = n;
        this.textArea = rSyntaxTextArea;
        this.startOffs = rSyntaxTextArea.getDocument().createPosition(n2);
    }

    public Fold createChild(int n, int n2) throws BadLocationException {
        Fold fold = new Fold(n, this.textArea, n2);
        fold.parent = this;
        if (this.children == null) {
            this.children = new ArrayList<Fold>();
        }
        this.children.add(fold);
        return fold;
    }

    @Override
    public int compareTo(Fold fold) {
        int n = -1;
        if (fold != null) {
            n = this.startOffs.getOffset() - fold.startOffs.getOffset();
        }
        return n;
    }

    public boolean containsLine(int n) {
        return n > this.getStartLine() && n <= this.getEndLine();
    }

    public boolean containsOrStartsOnLine(int n) {
        return n >= this.getStartLine() && n <= this.getEndLine();
    }

    public boolean containsOffset(int n) {
        boolean bl = false;
        if (n > this.getStartOffset()) {
            Element element = this.textArea.getDocument().getDefaultRootElement();
            int n2 = element.getElementIndex(n);
            bl = n2 <= this.getEndLine();
        }
        return bl;
    }

    public boolean equals(Object object) {
        return object instanceof Fold && this.compareTo((Fold)object) == 0;
    }

    public Fold getChild(int n) {
        return this.children.get(n);
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    List<Fold> getChildren() {
        return this.children;
    }

    public int getCollapsedLineCount() {
        return this.collapsed ? this.getLineCount() : this.childCollapsedLineCount;
    }

    Fold getDeepestFoldContaining(int n) {
        Fold fold = this;
        for (int i = 0; i < this.getChildCount(); ++i) {
            Fold fold2 = this.getChild(i);
            if (!fold2.containsOffset(n)) continue;
            fold = fold2.getDeepestFoldContaining(n);
            break;
        }
        return fold;
    }

    Fold getDeepestOpenFoldContaining(int n) {
        Fold fold = this;
        for (int i = 0; i < this.getChildCount(); ++i) {
            Fold fold2 = this.getChild(i);
            if (!fold2.containsOffset(n)) continue;
            if (fold2.isCollapsed()) break;
            fold = fold2.getDeepestOpenFoldContaining(n);
            break;
        }
        return fold;
    }

    public int getEndLine() {
        int n = this.getEndOffset();
        if (this.lastEndOffs == n) {
            return this.cachedEndLine;
        }
        this.lastEndOffs = n;
        Element element = this.textArea.getDocument().getDefaultRootElement();
        this.cachedEndLine = element.getElementIndex(n);
        return this.cachedEndLine;
    }

    public int getEndOffset() {
        return this.endOffs != null ? this.endOffs.getOffset() : Integer.MAX_VALUE;
    }

    public int getFoldType() {
        return this.type;
    }

    public boolean getHasChildFolds() {
        return this.getChildCount() > 0;
    }

    public Fold getLastChild() {
        int n = this.getChildCount();
        return n == 0 ? null : this.getChild(n - 1);
    }

    public int getLineCount() {
        return this.getEndLine() - this.getStartLine();
    }

    public Fold getParent() {
        return this.parent;
    }

    public int getStartLine() {
        int n = this.getStartOffset();
        if (this.lastStartOffs == n) {
            return this.cachedStartLine;
        }
        this.lastStartOffs = n;
        Element element = this.textArea.getDocument().getDefaultRootElement();
        this.cachedStartLine = element.getElementIndex(n);
        return this.cachedStartLine;
    }

    public int getStartOffset() {
        return this.startOffs.getOffset();
    }

    public int hashCode() {
        return this.getStartLine();
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public boolean isOnSingleLine() {
        return this.getStartLine() == this.getEndLine();
    }

    public boolean removeFromParent() {
        if (this.parent != null) {
            this.parent.removeMostRecentChild();
            this.parent = null;
            return true;
        }
        return false;
    }

    private void removeMostRecentChild() {
        this.children.remove(this.children.size() - 1);
    }

    public void setCollapsed(boolean bl) {
        if (bl != this.collapsed) {
            int n = this.getLineCount();
            int n2 = n - this.childCollapsedLineCount;
            if (!bl) {
                n2 = -n2;
            }
            this.collapsed = bl;
            if (this.parent != null) {
                this.parent.updateChildCollapsedLineCount(n2);
            }
            if (bl) {
                int n3;
                int n4 = this.textArea.getSelectionStart();
                Element element = this.textArea.getDocument().getDefaultRootElement();
                int n5 = element.getElementIndex(n4);
                boolean bl2 = this.containsLine(n5);
                if (!bl2 && (n3 = this.textArea.getSelectionEnd()) != n4) {
                    int n6 = element.getElementIndex(n3);
                    bl2 = this.containsLine(n6);
                }
                if (bl2) {
                    n4 = element.getElement(this.getStartLine()).getEndOffset() - 1;
                    this.textArea.setCaretPosition(n4);
                }
            }
            this.textArea.foldToggled(this);
        }
    }

    public void setEndOffset(int n) throws BadLocationException {
        this.endOffs = this.textArea.getDocument().createPosition(n);
    }

    public void toggleCollapsedState() {
        this.setCollapsed(!this.collapsed);
    }

    private void updateChildCollapsedLineCount(int n) {
        this.childCollapsedLineCount += n;
        if (!this.collapsed && this.parent != null) {
            this.parent.updateChildCollapsedLineCount(n);
        }
    }

    public String toString() {
        return "[Fold: startOffs=" + this.getStartOffset() + ", endOffs=" + this.getEndOffset() + ", collapsed=" + this.collapsed + "]";
    }
}

