/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.fife.ui.rsyntaxtextarea.OccurrenceMarker;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.SmartHighlightPainter;

class DefaultOccurrenceMarker
implements OccurrenceMarker {
    DefaultOccurrenceMarker() {
    }

    @Override
    public Token getTokenToMark(RSyntaxTextArea rSyntaxTextArea) {
        Caret caret;
        int n;
        int n2 = rSyntaxTextArea.getCaretLineNumber();
        Token token = rSyntaxTextArea.getTokenListForLine(n2);
        Token token2 = RSyntaxUtilities.getTokenAtOffset(token, n = (caret = rSyntaxTextArea.getCaret()).getDot());
        if (token2 == null || !this.isValidType(rSyntaxTextArea, token2) || RSyntaxUtilities.isNonWordChar(token2)) {
            --n;
            try {
                if (n >= rSyntaxTextArea.getLineStartOffset(n2)) {
                    token2 = RSyntaxUtilities.getTokenAtOffset(token, n);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        return token2;
    }

    @Override
    public boolean isValidType(RSyntaxTextArea rSyntaxTextArea, Token token) {
        return rSyntaxTextArea.getMarkOccurrencesOfTokenType(token.getType());
    }

    @Override
    public void markOccurrences(RSyntaxDocument rSyntaxDocument, Token token, RSyntaxTextAreaHighlighter rSyntaxTextAreaHighlighter, SmartHighlightPainter smartHighlightPainter) {
        DefaultOccurrenceMarker.markOccurrencesOfToken(rSyntaxDocument, token, rSyntaxTextAreaHighlighter, smartHighlightPainter);
    }

    public static final void markOccurrencesOfToken(RSyntaxDocument rSyntaxDocument, Token token, RSyntaxTextAreaHighlighter rSyntaxTextAreaHighlighter, SmartHighlightPainter smartHighlightPainter) {
        char[] cArray = token.getLexeme().toCharArray();
        int n = token.getType();
        int n2 = rSyntaxDocument.getDefaultRootElement().getElementCount();
        for (int i = 0; i < n2; ++i) {
            for (Token token2 = rSyntaxDocument.getTokenListForLine(i); token2 != null && token2.isPaintable(); token2 = token2.getNextToken()) {
                if (!token2.is(n, cArray)) continue;
                try {
                    int n3 = token2.getEndOffset();
                    rSyntaxTextAreaHighlighter.addMarkedOccurrenceHighlight(token2.getOffset(), n3, smartHighlightPainter);
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
    }
}

