/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.IndentBuffer;
import com.thoughtworks.qdox.model.Member;
import com.thoughtworks.qdox.model.Type;

public class JavaField
extends AbstractJavaEntity
implements Member {
    private Type type;
    private String initializationExpression;

    public JavaField() {
    }

    public JavaField(String string) {
        this.setName(string);
    }

    public JavaField(Type type, String string) {
        this.setType(type);
        this.setName(string);
    }

    public Type getType() {
        return this.type;
    }

    @Override
    protected void writeBody(IndentBuffer indentBuffer) {
        this.writeAllModifiers(indentBuffer);
        indentBuffer.write(this.type.toString());
        indentBuffer.write(' ');
        indentBuffer.write(this.name);
        if (this.initializationExpression != null && this.initializationExpression.length() > 0) {
            indentBuffer.write(" = ");
            indentBuffer.write(this.initializationExpression);
        }
        indentBuffer.write(';');
        indentBuffer.newline();
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int compareTo(Object object) {
        return this.getName().compareTo(((JavaField)object).getName());
    }

    @Override
    public String getDeclarationSignature(boolean bl) {
        IndentBuffer indentBuffer = new IndentBuffer();
        if (bl) {
            this.writeAllModifiers(indentBuffer);
        }
        indentBuffer.write(this.type.toString());
        indentBuffer.write(' ');
        indentBuffer.write(this.name);
        return indentBuffer.toString();
    }

    @Override
    public String getCallSignature() {
        return this.getName();
    }

    public String getInitializationExpression() {
        return this.initializationExpression;
    }

    public void setInitializationExpression(String string) {
        this.initializationExpression = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isPrivate()) {
            stringBuffer.append("private ");
        } else if (this.isProtected()) {
            stringBuffer.append("protected ");
        } else if (this.isPublic()) {
            stringBuffer.append("public ");
        }
        if (this.isStatic()) {
            stringBuffer.append("static ");
        }
        if (this.isFinal()) {
            stringBuffer.append("final ");
        }
        if (this.isTransient()) {
            stringBuffer.append("transient ");
        }
        if (this.isVolatile()) {
            stringBuffer.append("volatile ");
        }
        stringBuffer.append(this.getType().getValue() + " ");
        stringBuffer.append(this.getParentClass().getFullyQualifiedName() + "." + this.getName());
        return stringBuffer.toString();
    }
}

