/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.util.CompactStringObjectMap;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class EnumResolver
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Class<Enum<?>> _enumClass;
    protected final Enum<?>[] _enums;
    protected final HashMap<String, Enum<?>> _enumsById;
    protected final Enum<?> _defaultValue;

    protected EnumResolver(Class<Enum<?>> clazz, Enum<?>[] enumArray, HashMap<String, Enum<?>> hashMap, Enum<?> enum_) {
        this._enumClass = clazz;
        this._enums = enumArray;
        this._enumsById = hashMap;
        this._defaultValue = enum_;
    }

    public static EnumResolver constructFor(Class<Enum<?>> clazz, AnnotationIntrospector annotationIntrospector) {
        Enum<?>[] enumArray = clazz.getEnumConstants();
        if (enumArray == null) {
            throw new IllegalArgumentException("No enum constants for class " + clazz.getName());
        }
        String[] stringArray = annotationIntrospector.findEnumValues(clazz, enumArray, new String[enumArray.length]);
        HashMap hashMap = new HashMap();
        int n = enumArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (string == null) {
                string = enumArray[i].name();
            }
            hashMap.put(string, enumArray[i]);
        }
        Enum<?> enum_ = annotationIntrospector.findDefaultEnumValue(clazz);
        return new EnumResolver(clazz, enumArray, hashMap, enum_);
    }

    @Deprecated
    public static EnumResolver constructUsingToString(Class<Enum<?>> clazz) {
        return EnumResolver.constructUsingToString(clazz, null);
    }

    public static EnumResolver constructUsingToString(Class<Enum<?>> clazz, AnnotationIntrospector annotationIntrospector) {
        Enum<?>[] enumArray = clazz.getEnumConstants();
        HashMap hashMap = new HashMap();
        int n = enumArray.length;
        while (--n >= 0) {
            Enum<?> enum_ = enumArray[n];
            hashMap.put(enum_.toString(), enum_);
        }
        Enum<?> enum_ = annotationIntrospector == null ? null : annotationIntrospector.findDefaultEnumValue(clazz);
        return new EnumResolver(clazz, enumArray, hashMap, enum_);
    }

    @Deprecated
    public static EnumResolver constructUsingMethod(Class<Enum<?>> clazz, Method method) {
        return EnumResolver.constructUsingMethod(clazz, method, null);
    }

    public static EnumResolver constructUsingMethod(Class<Enum<?>> clazz, Method method, AnnotationIntrospector annotationIntrospector) {
        Enum<?>[] enumArray = clazz.getEnumConstants();
        HashMap hashMap = new HashMap();
        int n = enumArray.length;
        while (--n >= 0) {
            Enum<?> enum_ = enumArray[n];
            try {
                Object object = method.invoke(enum_, new Object[0]);
                if (object == null) continue;
                hashMap.put(object.toString(), enum_);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to access @JsonValue of Enum value " + enum_ + ": " + exception.getMessage());
            }
        }
        Enum<?> enum_ = annotationIntrospector != null ? annotationIntrospector.findDefaultEnumValue(clazz) : null;
        return new EnumResolver(clazz, enumArray, hashMap, enum_);
    }

    public static EnumResolver constructUnsafe(Class<?> clazz, AnnotationIntrospector annotationIntrospector) {
        Class<Enum<?>> clazz2 = clazz;
        return EnumResolver.constructFor(clazz2, annotationIntrospector);
    }

    @Deprecated
    public static EnumResolver constructUnsafeUsingToString(Class<?> clazz) {
        return EnumResolver.constructUnsafeUsingToString(clazz, null);
    }

    public static EnumResolver constructUnsafeUsingToString(Class<?> clazz, AnnotationIntrospector annotationIntrospector) {
        Class<Enum<?>> clazz2 = clazz;
        return EnumResolver.constructUsingToString(clazz2, annotationIntrospector);
    }

    @Deprecated
    public static EnumResolver constructUnsafeUsingMethod(Class<?> clazz, Method method) {
        return EnumResolver.constructUnsafeUsingMethod(clazz, method, null);
    }

    public static EnumResolver constructUnsafeUsingMethod(Class<?> clazz, Method method, AnnotationIntrospector annotationIntrospector) {
        Class<Enum<?>> clazz2 = clazz;
        return EnumResolver.constructUsingMethod(clazz2, method, annotationIntrospector);
    }

    public CompactStringObjectMap constructLookup() {
        return CompactStringObjectMap.construct(this._enumsById);
    }

    public Enum<?> findEnum(String string) {
        return this._enumsById.get(string);
    }

    public Enum<?> getEnum(int n) {
        if (n < 0 || n >= this._enums.length) {
            return null;
        }
        return this._enums[n];
    }

    public Enum<?> getDefaultValue() {
        return this._defaultValue;
    }

    public Enum<?>[] getRawEnums() {
        return this._enums;
    }

    public List<Enum<?>> getEnums() {
        ArrayList arrayList = new ArrayList(this._enums.length);
        for (Enum<?> enum_ : this._enums) {
            arrayList.add(enum_);
        }
        return arrayList;
    }

    public Collection<String> getEnumIds() {
        return this._enumsById.keySet();
    }

    public Class<Enum<?>> getEnumClass() {
        return this._enumClass;
    }

    public int lastValidIndex() {
        return this._enums.length - 1;
    }
}

