/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;

public abstract class StdSerializer<T>
extends JsonSerializer<T>
implements JsonFormatVisitable,
SchemaAware,
Serializable {
    private static final Object CONVERTING_CONTENT_CONVERTER_LOCK = new Object();
    private static final long serialVersionUID = 1L;
    protected final Class<T> _handledType;

    protected StdSerializer(Class<T> clazz) {
        this._handledType = clazz;
    }

    protected StdSerializer(JavaType javaType) {
        this._handledType = javaType.getRawClass();
    }

    protected StdSerializer(Class<?> clazz, boolean bl) {
        this._handledType = clazz;
    }

    protected StdSerializer(StdSerializer<?> stdSerializer) {
        this._handledType = stdSerializer._handledType;
    }

    @Override
    public Class<T> handledType() {
        return this._handledType;
    }

    @Override
    public abstract void serialize(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException;

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        jsonFormatVisitorWrapper.expectAnyFormat(javaType);
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) throws JsonMappingException {
        return this.createSchemaNode("string");
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type, boolean bl) throws JsonMappingException {
        ObjectNode objectNode = (ObjectNode)this.getSchema(serializerProvider, type);
        if (!bl) {
            objectNode.put("required", !bl);
        }
        return objectNode;
    }

    protected ObjectNode createObjectNode() {
        return JsonNodeFactory.instance.objectNode();
    }

    protected ObjectNode createSchemaNode(String string) {
        ObjectNode objectNode = this.createObjectNode();
        objectNode.put("type", string);
        return objectNode;
    }

    protected ObjectNode createSchemaNode(String string, boolean bl) {
        ObjectNode objectNode = this.createSchemaNode(string);
        if (!bl) {
            objectNode.put("required", !bl);
        }
        return objectNode;
    }

    protected void visitStringFormat(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        if (jsonFormatVisitorWrapper != null) {
            jsonFormatVisitorWrapper.expectStringFormat(javaType);
        }
    }

    protected void visitStringFormat(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType, JsonValueFormat jsonValueFormat) throws JsonMappingException {
        JsonStringFormatVisitor jsonStringFormatVisitor;
        if (jsonFormatVisitorWrapper != null && (jsonStringFormatVisitor = jsonFormatVisitorWrapper.expectStringFormat(javaType)) != null) {
            jsonStringFormatVisitor.format(jsonValueFormat);
        }
    }

    protected void visitIntFormat(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType, JsonParser.NumberType numberType) throws JsonMappingException {
        JsonIntegerFormatVisitor jsonIntegerFormatVisitor;
        if (jsonFormatVisitorWrapper != null && (jsonIntegerFormatVisitor = jsonFormatVisitorWrapper.expectIntegerFormat(javaType)) != null && numberType != null) {
            jsonIntegerFormatVisitor.numberType(numberType);
        }
    }

    protected void visitIntFormat(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType, JsonParser.NumberType numberType, JsonValueFormat jsonValueFormat) throws JsonMappingException {
        JsonIntegerFormatVisitor jsonIntegerFormatVisitor;
        if (jsonFormatVisitorWrapper != null && (jsonIntegerFormatVisitor = jsonFormatVisitorWrapper.expectIntegerFormat(javaType)) != null) {
            if (numberType != null) {
                jsonIntegerFormatVisitor.numberType(numberType);
            }
            if (jsonValueFormat != null) {
                jsonIntegerFormatVisitor.format(jsonValueFormat);
            }
        }
    }

    protected void visitFloatFormat(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType, JsonParser.NumberType numberType) throws JsonMappingException {
        JsonNumberFormatVisitor jsonNumberFormatVisitor;
        if (jsonFormatVisitorWrapper != null && (jsonNumberFormatVisitor = jsonFormatVisitorWrapper.expectNumberFormat(javaType)) != null) {
            jsonNumberFormatVisitor.numberType(numberType);
        }
    }

    protected void visitArrayFormat(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType, JsonSerializer<?> jsonSerializer, JavaType javaType2) throws JsonMappingException {
        JsonArrayFormatVisitor jsonArrayFormatVisitor;
        if (jsonFormatVisitorWrapper != null && (jsonArrayFormatVisitor = jsonFormatVisitorWrapper.expectArrayFormat(javaType)) != null && jsonSerializer != null) {
            jsonArrayFormatVisitor.itemsFormat(jsonSerializer, javaType2);
        }
    }

    protected void visitArrayFormat(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType, JsonFormatTypes jsonFormatTypes) throws JsonMappingException {
        JsonArrayFormatVisitor jsonArrayFormatVisitor;
        if (jsonFormatVisitorWrapper != null && (jsonArrayFormatVisitor = jsonFormatVisitorWrapper.expectArrayFormat(javaType)) != null) {
            jsonArrayFormatVisitor.itemsFormat(jsonFormatTypes);
        }
    }

    public void wrapAndThrow(SerializerProvider serializerProvider, Throwable throwable, Object object, String string) throws IOException {
        boolean bl;
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        boolean bl2 = bl = serializerProvider == null || serializerProvider.isEnabled(SerializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            if (!bl || !(throwable instanceof JsonMappingException)) {
                throw (IOException)throwable;
            }
        } else if (!bl && throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw JsonMappingException.wrapWithPath(throwable, object, string);
    }

    public void wrapAndThrow(SerializerProvider serializerProvider, Throwable throwable, Object object, int n) throws IOException {
        boolean bl;
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        boolean bl2 = bl = serializerProvider == null || serializerProvider.isEnabled(SerializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            if (!bl || !(throwable instanceof JsonMappingException)) {
                throw (IOException)throwable;
            }
        } else if (!bl && throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw JsonMappingException.wrapWithPath(throwable, object, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonSerializer<?> findConvertingContentSerializer(SerializerProvider serializerProvider, BeanProperty beanProperty, JsonSerializer<?> jsonSerializer) throws JsonMappingException {
        AnnotatedMember annotatedMember;
        Object object = serializerProvider.getAttribute(CONVERTING_CONTENT_CONVERTER_LOCK);
        if (object != null && object == Boolean.TRUE) {
            return jsonSerializer;
        }
        AnnotationIntrospector annotationIntrospector = serializerProvider.getAnnotationIntrospector();
        if (annotationIntrospector != null && beanProperty != null && (annotatedMember = beanProperty.getMember()) != null) {
            Object object2;
            serializerProvider.setAttribute(CONVERTING_CONTENT_CONVERTER_LOCK, Boolean.TRUE);
            try {
                object2 = annotationIntrospector.findSerializationContentConverter(annotatedMember);
            }
            finally {
                serializerProvider.setAttribute(CONVERTING_CONTENT_CONVERTER_LOCK, null);
            }
            if (object2 != null) {
                Converter<Object, Object> converter = serializerProvider.converterInstance(beanProperty.getMember(), object2);
                JavaType javaType = converter.getOutputType(serializerProvider.getTypeFactory());
                if (jsonSerializer == null && !javaType.isJavaLangObject()) {
                    jsonSerializer = serializerProvider.findValueSerializer(javaType);
                }
                return new StdDelegatingSerializer(converter, javaType, jsonSerializer);
            }
        }
        return jsonSerializer;
    }

    protected PropertyFilter findPropertyFilter(SerializerProvider serializerProvider, Object object, Object object2) throws JsonMappingException {
        FilterProvider filterProvider = serializerProvider.getFilterProvider();
        if (filterProvider == null) {
            throw JsonMappingException.from(serializerProvider, "Can not resolve PropertyFilter with id '" + object + "'; no FilterProvider configured");
        }
        return filterProvider.findPropertyFilter(object, object2);
    }

    protected JsonFormat.Value findFormatOverrides(SerializerProvider serializerProvider, BeanProperty beanProperty, Class<?> clazz) {
        if (beanProperty != null) {
            return beanProperty.findPropertyFormat(serializerProvider.getConfig(), clazz);
        }
        return serializerProvider.getDefaultPropertyFormat(clazz);
    }

    protected Boolean findFormatFeature(SerializerProvider serializerProvider, BeanProperty beanProperty, Class<?> clazz, JsonFormat.Feature feature) {
        JsonFormat.Value value = this.findFormatOverrides(serializerProvider, beanProperty, clazz);
        if (value != null) {
            return value.getFeature(feature);
        }
        return null;
    }

    protected JsonInclude.Value findIncludeOverrides(SerializerProvider serializerProvider, BeanProperty beanProperty, Class<?> clazz) {
        if (beanProperty != null) {
            return beanProperty.findPropertyInclusion(serializerProvider.getConfig(), clazz);
        }
        return serializerProvider.getDefaultPropertyInclusion(clazz);
    }

    protected JsonSerializer<?> findAnnotatedContentSerializer(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        if (beanProperty != null) {
            Object object;
            AnnotatedMember annotatedMember = beanProperty.getMember();
            AnnotationIntrospector annotationIntrospector = serializerProvider.getAnnotationIntrospector();
            if (annotatedMember != null && (object = annotationIntrospector.findContentSerializer(annotatedMember)) != null) {
                return serializerProvider.serializerInstance(annotatedMember, object);
            }
        }
        return null;
    }

    protected boolean isDefaultSerializer(JsonSerializer<?> jsonSerializer) {
        return ClassUtil.isJacksonStdImpl(jsonSerializer);
    }
}

