/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

public abstract class DateTimeSerializerBase<T>
extends StdScalarSerializer<T>
implements ContextualSerializer {
    protected final Boolean _useTimestamp;
    protected final DateFormat _customFormat;

    protected DateTimeSerializerBase(Class<T> clazz, Boolean bl, DateFormat dateFormat) {
        super(clazz);
        this._useTimestamp = bl;
        this._customFormat = dateFormat;
    }

    public abstract DateTimeSerializerBase<T> withFormat(Boolean var1, DateFormat var2);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        JsonFormat.Value value;
        if (beanProperty != null && (value = this.findFormatOverrides(serializerProvider, beanProperty, this.handledType())) != null) {
            JsonFormat.Shape shape = value.getShape();
            if (shape.isNumeric()) {
                return this.withFormat(Boolean.TRUE, null);
            }
            if (shape == JsonFormat.Shape.STRING || value.hasPattern() || value.hasLocale() || value.hasTimeZone()) {
                TimeZone timeZone = value.getTimeZone();
                String string = value.hasPattern() ? value.getPattern() : "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
                Locale locale = value.hasLocale() ? value.getLocale() : serializerProvider.getLocale();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale);
                if (timeZone == null) {
                    timeZone = serializerProvider.getTimeZone();
                }
                simpleDateFormat.setTimeZone(timeZone);
                return this.withFormat(Boolean.FALSE, simpleDateFormat);
            }
        }
        return this;
    }

    @Override
    @Deprecated
    public boolean isEmpty(T t) {
        return t == null || this._timestamp(t) == 0L;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, T t) {
        return t == null || this._timestamp(t) == 0L;
    }

    protected abstract long _timestamp(T var1);

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode(this._asTimestamp(serializerProvider) ? "number" : "string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        this._acceptJsonFormatVisitor(jsonFormatVisitorWrapper, javaType, this._asTimestamp(jsonFormatVisitorWrapper.getProvider()));
    }

    @Override
    public abstract void serialize(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException;

    protected boolean _asTimestamp(SerializerProvider serializerProvider) {
        if (this._useTimestamp != null) {
            return this._useTimestamp;
        }
        if (this._customFormat == null) {
            if (serializerProvider != null) {
                return serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            }
            throw new IllegalArgumentException("Null SerializerProvider passed for " + this.handledType().getName());
        }
        return false;
    }

    protected void _acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType, boolean bl) throws JsonMappingException {
        if (bl) {
            this.visitIntFormat(jsonFormatVisitorWrapper, javaType, JsonParser.NumberType.LONG, JsonValueFormat.UTC_MILLISEC);
        } else {
            this.visitStringFormat(jsonFormatVisitorWrapper, javaType, JsonValueFormat.DATE_TIME);
        }
    }
}

