/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.databind.ser.BeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SimpleFilterProvider
extends FilterProvider
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Map<String, PropertyFilter> _filtersById;
    protected PropertyFilter _defaultFilter;
    protected boolean _cfgFailOnUnknownId = true;

    public SimpleFilterProvider() {
        this(new HashMap());
    }

    public SimpleFilterProvider(Map<String, ?> map) {
        for (Object obj : map.values()) {
            if (obj instanceof PropertyFilter) continue;
            this._filtersById = SimpleFilterProvider._convert(map);
            return;
        }
        this._filtersById = map;
    }

    private static final Map<String, PropertyFilter> _convert(Map<String, ?> map) {
        HashMap<String, PropertyFilter> hashMap = new HashMap<String, PropertyFilter>();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Object obj = entry.getValue();
            if (obj instanceof PropertyFilter) {
                hashMap.put(entry.getKey(), (PropertyFilter)obj);
                continue;
            }
            if (obj instanceof BeanPropertyFilter) {
                hashMap.put(entry.getKey(), SimpleFilterProvider._convert((BeanPropertyFilter)obj));
                continue;
            }
            throw new IllegalArgumentException("Unrecognized filter type (" + obj.getClass().getName() + ")");
        }
        return hashMap;
    }

    private static final PropertyFilter _convert(BeanPropertyFilter beanPropertyFilter) {
        return SimpleBeanPropertyFilter.from(beanPropertyFilter);
    }

    @Deprecated
    public SimpleFilterProvider setDefaultFilter(BeanPropertyFilter beanPropertyFilter) {
        this._defaultFilter = SimpleBeanPropertyFilter.from(beanPropertyFilter);
        return this;
    }

    public SimpleFilterProvider setDefaultFilter(PropertyFilter propertyFilter) {
        this._defaultFilter = propertyFilter;
        return this;
    }

    public SimpleFilterProvider setDefaultFilter(SimpleBeanPropertyFilter simpleBeanPropertyFilter) {
        this._defaultFilter = simpleBeanPropertyFilter;
        return this;
    }

    public PropertyFilter getDefaultFilter() {
        return this._defaultFilter;
    }

    public SimpleFilterProvider setFailOnUnknownId(boolean bl) {
        this._cfgFailOnUnknownId = bl;
        return this;
    }

    public boolean willFailOnUnknownId() {
        return this._cfgFailOnUnknownId;
    }

    @Deprecated
    public SimpleFilterProvider addFilter(String string, BeanPropertyFilter beanPropertyFilter) {
        this._filtersById.put(string, SimpleFilterProvider._convert(beanPropertyFilter));
        return this;
    }

    public SimpleFilterProvider addFilter(String string, PropertyFilter propertyFilter) {
        this._filtersById.put(string, propertyFilter);
        return this;
    }

    public SimpleFilterProvider addFilter(String string, SimpleBeanPropertyFilter simpleBeanPropertyFilter) {
        this._filtersById.put(string, simpleBeanPropertyFilter);
        return this;
    }

    public PropertyFilter removeFilter(String string) {
        return this._filtersById.remove(string);
    }

    @Override
    @Deprecated
    public BeanPropertyFilter findFilter(Object object) {
        throw new UnsupportedOperationException("Access to deprecated filters not supported");
    }

    @Override
    public PropertyFilter findPropertyFilter(Object object, Object object2) {
        PropertyFilter propertyFilter = this._filtersById.get(object);
        if (propertyFilter == null && (propertyFilter = this._defaultFilter) == null && this._cfgFailOnUnknownId) {
            throw new IllegalArgumentException("No filter configured with id '" + object + "' (type " + object.getClass().getName() + ")");
        }
        return propertyFilter;
    }
}

