/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.NullifyingDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class TypeDeserializerBase
extends TypeDeserializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final TypeIdResolver _idResolver;
    protected final JavaType _baseType;
    protected final BeanProperty _property;
    protected final JavaType _defaultImpl;
    protected final String _typePropertyName;
    protected final boolean _typeIdVisible;
    protected final Map<String, JsonDeserializer<Object>> _deserializers;
    protected JsonDeserializer<Object> _defaultImplDeserializer;

    protected TypeDeserializerBase(JavaType javaType, TypeIdResolver typeIdResolver, String string, boolean bl, JavaType javaType2) {
        this._baseType = javaType;
        this._idResolver = typeIdResolver;
        this._typePropertyName = string == null ? "" : string;
        this._typeIdVisible = bl;
        this._deserializers = new ConcurrentHashMap<String, JsonDeserializer<Object>>(16, 0.75f, 2);
        this._defaultImpl = javaType2;
        this._property = null;
    }

    protected TypeDeserializerBase(TypeDeserializerBase typeDeserializerBase, BeanProperty beanProperty) {
        this._baseType = typeDeserializerBase._baseType;
        this._idResolver = typeDeserializerBase._idResolver;
        this._typePropertyName = typeDeserializerBase._typePropertyName;
        this._typeIdVisible = typeDeserializerBase._typeIdVisible;
        this._deserializers = typeDeserializerBase._deserializers;
        this._defaultImpl = typeDeserializerBase._defaultImpl;
        this._defaultImplDeserializer = typeDeserializerBase._defaultImplDeserializer;
        this._property = beanProperty;
    }

    @Override
    public abstract TypeDeserializer forProperty(BeanProperty var1);

    @Override
    public abstract JsonTypeInfo.As getTypeInclusion();

    public String baseTypeName() {
        return this._baseType.getRawClass().getName();
    }

    @Override
    public final String getPropertyName() {
        return this._typePropertyName;
    }

    @Override
    public TypeIdResolver getTypeIdResolver() {
        return this._idResolver;
    }

    @Override
    public Class<?> getDefaultImpl() {
        return this._defaultImpl == null ? null : this._defaultImpl.getRawClass();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(this.getClass().getName());
        stringBuilder.append("; base-type:").append(this._baseType);
        stringBuilder.append("; id-resolver: ").append(this._idResolver);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    protected final JsonDeserializer<Object> _findDeserializer(DeserializationContext deserializationContext, String string) throws IOException {
        JsonDeserializer<Object> jsonDeserializer = this._deserializers.get(string);
        if (jsonDeserializer == null) {
            JavaType javaType = this._idResolver.typeFromId(deserializationContext, string);
            if (javaType == null) {
                jsonDeserializer = this._findDefaultImplDeserializer(deserializationContext);
                if (jsonDeserializer == null) {
                    JavaType javaType2 = this._handleUnknownTypeId(deserializationContext, string, this._idResolver, this._baseType);
                    if (javaType2 == null) {
                        return null;
                    }
                    jsonDeserializer = deserializationContext.findContextualValueDeserializer(javaType2, this._property);
                }
            } else {
                if (this._baseType != null && this._baseType.getClass() == javaType.getClass() && !javaType.hasGenericTypes()) {
                    javaType = deserializationContext.getTypeFactory().constructSpecializedType(this._baseType, javaType.getRawClass());
                }
                jsonDeserializer = deserializationContext.findContextualValueDeserializer(javaType, this._property);
            }
            this._deserializers.put(string, jsonDeserializer);
        }
        return jsonDeserializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final JsonDeserializer<Object> _findDefaultImplDeserializer(DeserializationContext deserializationContext) throws IOException {
        if (this._defaultImpl == null) {
            if (!deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE)) {
                return NullifyingDeserializer.instance;
            }
            return null;
        }
        Class<?> clazz = this._defaultImpl.getRawClass();
        if (ClassUtil.isBogusClass(clazz)) {
            return NullifyingDeserializer.instance;
        }
        JavaType javaType = this._defaultImpl;
        synchronized (javaType) {
            if (this._defaultImplDeserializer == null) {
                this._defaultImplDeserializer = deserializationContext.findContextualValueDeserializer(this._defaultImpl, this._property);
            }
            return this._defaultImplDeserializer;
        }
    }

    @Deprecated
    protected Object _deserializeWithNativeTypeId(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return this._deserializeWithNativeTypeId(jsonParser, deserializationContext, jsonParser.getTypeId());
    }

    protected Object _deserializeWithNativeTypeId(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
        JsonDeserializer<Object> jsonDeserializer;
        if (object == null) {
            jsonDeserializer = this._findDefaultImplDeserializer(deserializationContext);
            if (jsonDeserializer == null) {
                deserializationContext.reportMappingException("No (native) type id found when one was expected for polymorphic type handling", new Object[0]);
                return null;
            }
        } else {
            String string = object instanceof String ? (String)object : String.valueOf(object);
            jsonDeserializer = this._findDeserializer(deserializationContext, string);
        }
        return jsonDeserializer.deserialize(jsonParser, deserializationContext);
    }

    protected JavaType _handleUnknownTypeId(DeserializationContext deserializationContext, String string, TypeIdResolver typeIdResolver, JavaType javaType) throws IOException {
        String string2 = typeIdResolver.getDescForKnownTypeIds();
        string2 = string2 == null ? "known type ids are not statically known" : "known type ids = " + string2;
        return deserializationContext.handleUnknownTypeId(this._baseType, string, typeIdResolver, string2);
    }
}

