/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.util.BeanUtil;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class POJOPropertiesCollector {
    protected final MapperConfig<?> _config;
    protected final boolean _forSerialization;
    protected final boolean _stdBeanNaming;
    protected final JavaType _type;
    protected final AnnotatedClass _classDef;
    protected final VisibilityChecker<?> _visibilityChecker;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final String _mutatorPrefix;
    protected boolean _collected;
    protected LinkedHashMap<String, POJOPropertyBuilder> _properties;
    protected LinkedList<POJOPropertyBuilder> _creatorProperties;
    protected LinkedList<AnnotatedMember> _anyGetters;
    protected LinkedList<AnnotatedMethod> _anySetters;
    protected LinkedList<AnnotatedMember> _anySetterField;
    protected LinkedList<AnnotatedMethod> _jsonValueGetters;
    protected HashSet<String> _ignoredPropertyNames;
    protected LinkedHashMap<Object, AnnotatedMember> _injectables;

    protected POJOPropertiesCollector(MapperConfig<?> mapperConfig, boolean bl, JavaType javaType, AnnotatedClass annotatedClass, String string) {
        this._config = mapperConfig;
        this._stdBeanNaming = mapperConfig.isEnabled(MapperFeature.USE_STD_BEAN_NAMING);
        this._forSerialization = bl;
        this._type = javaType;
        this._classDef = annotatedClass;
        this._mutatorPrefix = string == null ? "set" : string;
        this._annotationIntrospector = mapperConfig.isAnnotationProcessingEnabled() ? this._config.getAnnotationIntrospector() : null;
        this._visibilityChecker = this._annotationIntrospector == null ? this._config.getDefaultVisibilityChecker() : this._annotationIntrospector.findAutoDetectVisibility(annotatedClass, this._config.getDefaultVisibilityChecker());
    }

    public MapperConfig<?> getConfig() {
        return this._config;
    }

    public JavaType getType() {
        return this._type;
    }

    public AnnotatedClass getClassDef() {
        return this._classDef;
    }

    public AnnotationIntrospector getAnnotationIntrospector() {
        return this._annotationIntrospector;
    }

    public List<BeanPropertyDefinition> getProperties() {
        Map<String, POJOPropertyBuilder> map = this.getPropertyMap();
        return new ArrayList<BeanPropertyDefinition>(map.values());
    }

    public Map<Object, AnnotatedMember> getInjectables() {
        if (!this._collected) {
            this.collectAll();
        }
        return this._injectables;
    }

    public AnnotatedMethod getJsonValueMethod() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._jsonValueGetters != null) {
            if (this._jsonValueGetters.size() > 1) {
                this.reportProblem("Multiple value properties defined (" + this._jsonValueGetters.get(0) + " vs " + this._jsonValueGetters.get(1) + ")");
            }
            return this._jsonValueGetters.get(0);
        }
        return null;
    }

    public AnnotatedMember getAnyGetter() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._anyGetters != null) {
            if (this._anyGetters.size() > 1) {
                this.reportProblem("Multiple 'any-getters' defined (" + this._anyGetters.get(0) + " vs " + this._anyGetters.get(1) + ")");
            }
            return this._anyGetters.getFirst();
        }
        return null;
    }

    public AnnotatedMember getAnySetterField() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._anySetterField != null) {
            if (this._anySetterField.size() > 1) {
                this.reportProblem("Multiple 'any-Setters' defined (" + this._anySetters.get(0) + " vs " + this._anySetterField.get(1) + ")");
            }
            return this._anySetterField.getFirst();
        }
        return null;
    }

    public AnnotatedMethod getAnySetterMethod() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._anySetters != null) {
            if (this._anySetters.size() > 1) {
                this.reportProblem("Multiple 'any-setters' defined (" + this._anySetters.get(0) + " vs " + this._anySetters.get(1) + ")");
            }
            return this._anySetters.getFirst();
        }
        return null;
    }

    public Set<String> getIgnoredPropertyNames() {
        return this._ignoredPropertyNames;
    }

    public ObjectIdInfo getObjectIdInfo() {
        if (this._annotationIntrospector == null) {
            return null;
        }
        ObjectIdInfo objectIdInfo = this._annotationIntrospector.findObjectIdInfo(this._classDef);
        if (objectIdInfo != null) {
            objectIdInfo = this._annotationIntrospector.findObjectReferenceInfo(this._classDef, objectIdInfo);
        }
        return objectIdInfo;
    }

    public Class<?> findPOJOBuilderClass() {
        return this._annotationIntrospector.findPOJOBuilder(this._classDef);
    }

    protected Map<String, POJOPropertyBuilder> getPropertyMap() {
        if (!this._collected) {
            this.collectAll();
        }
        return this._properties;
    }

    @Deprecated
    public POJOPropertiesCollector collect() {
        return this;
    }

    protected void collectAll() {
        LinkedHashMap<String, POJOPropertyBuilder> linkedHashMap = new LinkedHashMap<String, POJOPropertyBuilder>();
        this._addFields(linkedHashMap);
        this._addMethods(linkedHashMap);
        this._addCreators(linkedHashMap);
        this._addInjectables(linkedHashMap);
        this._removeUnwantedProperties(linkedHashMap);
        for (POJOPropertyBuilder object : linkedHashMap.values()) {
            object.mergeAnnotations(this._forSerialization);
        }
        this._removeUnwantedAccessor(linkedHashMap);
        this._renameProperties(linkedHashMap);
        PropertyNamingStrategy propertyNamingStrategy = this._findNamingStrategy();
        if (propertyNamingStrategy != null) {
            this._renameUsing(linkedHashMap, propertyNamingStrategy);
        }
        for (POJOPropertyBuilder pOJOPropertyBuilder : linkedHashMap.values()) {
            pOJOPropertyBuilder.trimByVisibility();
        }
        if (this._config.isEnabled(MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME)) {
            this._renameWithWrappers(linkedHashMap);
        }
        this._sortProperties(linkedHashMap);
        this._properties = linkedHashMap;
        this._collected = true;
    }

    protected void _addFields(Map<String, POJOPropertyBuilder> map) {
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        boolean bl = !this._forSerialization && !this._config.isEnabled(MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS);
        boolean bl2 = this._config.isEnabled(MapperFeature.PROPAGATE_TRANSIENT_MARKER);
        for (AnnotatedField annotatedField : this._classDef.fields()) {
            boolean bl3;
            boolean bl4;
            PropertyName propertyName;
            boolean bl5;
            boolean bl6;
            String string;
            String string2 = string = annotationIntrospector == null ? null : annotationIntrospector.findImplicitPropertyName(annotatedField);
            if (string == null) {
                string = annotatedField.getName();
            }
            if ((bl6 = (bl5 = (propertyName = annotationIntrospector == null ? null : (this._forSerialization ? annotationIntrospector.findNameForSerialization(annotatedField) : annotationIntrospector.findNameForDeserialization(annotatedField))) != null)) && propertyName.isEmpty()) {
                propertyName = this._propNameFromSimple(string);
                bl6 = false;
            }
            boolean bl7 = bl4 = propertyName != null;
            if (!bl4) {
                bl4 = this._visibilityChecker.isFieldVisible(annotatedField);
            }
            boolean bl8 = bl3 = annotationIntrospector != null && annotationIntrospector.hasIgnoreMarker(annotatedField);
            if (annotatedField.isTransient() && !bl5) {
                bl4 = false;
                if (bl2) {
                    bl3 = true;
                }
            }
            if (bl && propertyName == null && !bl3 && Modifier.isFinal(annotatedField.getModifiers())) continue;
            if (annotatedField.hasAnnotation(JsonAnySetter.class)) {
                if (this._anySetterField == null) {
                    this._anySetterField = new LinkedList();
                }
                this._anySetterField.add(annotatedField);
            }
            this._property(map, string).addField(annotatedField, propertyName, bl6, bl4, bl3);
        }
    }

    protected void _addCreators(Map<String, POJOPropertyBuilder> map) {
        int n;
        int n2;
        if (this._annotationIntrospector == null) {
            return;
        }
        for (AnnotatedConstructor annotatedWithParams : this._classDef.getConstructors()) {
            if (this._creatorProperties == null) {
                this._creatorProperties = new LinkedList();
            }
            n2 = annotatedWithParams.getParameterCount();
            for (n = 0; n < n2; ++n) {
                this._addCreatorParam(map, annotatedWithParams.getParameter(n));
            }
        }
        for (AnnotatedMethod annotatedMethod : this._classDef.getStaticMethods()) {
            if (this._creatorProperties == null) {
                this._creatorProperties = new LinkedList();
            }
            n2 = annotatedMethod.getParameterCount();
            for (n = 0; n < n2; ++n) {
                this._addCreatorParam(map, annotatedMethod.getParameter(n));
            }
        }
    }

    protected void _addCreatorParam(Map<String, POJOPropertyBuilder> map, AnnotatedParameter annotatedParameter) {
        PropertyName propertyName;
        boolean bl;
        String string = this._annotationIntrospector.findImplicitPropertyName(annotatedParameter);
        if (string == null) {
            string = "";
        }
        boolean bl2 = bl = (propertyName = this._annotationIntrospector.findNameForDeserialization(annotatedParameter)) != null && !propertyName.isEmpty();
        if (!bl) {
            if (string.isEmpty()) {
                return;
            }
            if (!this._annotationIntrospector.hasCreatorAnnotation(annotatedParameter.getOwner())) {
                return;
            }
            propertyName = PropertyName.construct(string);
        }
        POJOPropertyBuilder pOJOPropertyBuilder = bl && string.isEmpty() ? this._property(map, propertyName) : this._property(map, string);
        pOJOPropertyBuilder.addCtor(annotatedParameter, propertyName, bl, true, false);
        this._creatorProperties.add(pOJOPropertyBuilder);
    }

    protected void _addMethods(Map<String, POJOPropertyBuilder> map) {
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        for (AnnotatedMethod annotatedMethod : this._classDef.memberMethods()) {
            int n = annotatedMethod.getParameterCount();
            if (n == 0) {
                this._addGetterMethod(map, annotatedMethod, annotationIntrospector);
                continue;
            }
            if (n == 1) {
                this._addSetterMethod(map, annotatedMethod, annotationIntrospector);
                continue;
            }
            if (n != 2 || annotationIntrospector == null || !annotationIntrospector.hasAnySetterAnnotation(annotatedMethod)) continue;
            if (this._anySetters == null) {
                this._anySetters = new LinkedList();
            }
            this._anySetters.add(annotatedMethod);
        }
    }

    protected void _addGetterMethod(Map<String, POJOPropertyBuilder> map, AnnotatedMethod annotatedMethod, AnnotationIntrospector annotationIntrospector) {
        boolean bl;
        String string;
        boolean bl2;
        if (!annotatedMethod.hasReturnType()) {
            return;
        }
        if (annotationIntrospector != null) {
            if (annotationIntrospector.hasAnyGetterAnnotation(annotatedMethod)) {
                if (this._anyGetters == null) {
                    this._anyGetters = new LinkedList();
                }
                this._anyGetters.add(annotatedMethod);
                return;
            }
            if (annotationIntrospector.hasAsValueAnnotation(annotatedMethod)) {
                if (this._jsonValueGetters == null) {
                    this._jsonValueGetters = new LinkedList();
                }
                this._jsonValueGetters.add(annotatedMethod);
                return;
            }
        }
        PropertyName propertyName = annotationIntrospector == null ? null : annotationIntrospector.findNameForSerialization(annotatedMethod);
        boolean bl3 = bl2 = propertyName != null;
        if (!bl2) {
            String string2 = string = annotationIntrospector == null ? null : annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (string == null) {
                string = BeanUtil.okNameForRegularGetter(annotatedMethod, annotatedMethod.getName(), this._stdBeanNaming);
            }
            if (string == null) {
                string = BeanUtil.okNameForIsGetter(annotatedMethod, annotatedMethod.getName(), this._stdBeanNaming);
                if (string == null) {
                    return;
                }
                bl = this._visibilityChecker.isIsGetterVisible(annotatedMethod);
            } else {
                bl = this._visibilityChecker.isGetterVisible(annotatedMethod);
            }
        } else {
            String string3 = string = annotationIntrospector == null ? null : annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (string == null) {
                string = BeanUtil.okNameForGetter(annotatedMethod, this._stdBeanNaming);
            }
            if (string == null) {
                string = annotatedMethod.getName();
            }
            if (propertyName.isEmpty()) {
                propertyName = this._propNameFromSimple(string);
                bl2 = false;
            }
            bl = true;
        }
        boolean bl4 = annotationIntrospector == null ? false : annotationIntrospector.hasIgnoreMarker(annotatedMethod);
        this._property(map, string).addGetter(annotatedMethod, propertyName, bl2, bl, bl4);
    }

    protected void _addSetterMethod(Map<String, POJOPropertyBuilder> map, AnnotatedMethod annotatedMethod, AnnotationIntrospector annotationIntrospector) {
        boolean bl;
        String string;
        boolean bl2;
        PropertyName propertyName = annotationIntrospector == null ? null : annotationIntrospector.findNameForDeserialization(annotatedMethod);
        boolean bl3 = bl2 = propertyName != null;
        if (!bl2) {
            String string2 = string = annotationIntrospector == null ? null : annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (string == null) {
                string = BeanUtil.okNameForMutator(annotatedMethod, this._mutatorPrefix, this._stdBeanNaming);
            }
            if (string == null) {
                return;
            }
            bl = this._visibilityChecker.isSetterVisible(annotatedMethod);
        } else {
            String string3 = string = annotationIntrospector == null ? null : annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (string == null) {
                string = BeanUtil.okNameForMutator(annotatedMethod, this._mutatorPrefix, this._stdBeanNaming);
            }
            if (string == null) {
                string = annotatedMethod.getName();
            }
            if (propertyName.isEmpty()) {
                propertyName = this._propNameFromSimple(string);
                bl2 = false;
            }
            bl = true;
        }
        boolean bl4 = annotationIntrospector == null ? false : annotationIntrospector.hasIgnoreMarker(annotatedMethod);
        this._property(map, string).addSetter(annotatedMethod, propertyName, bl2, bl, bl4);
    }

    protected void _addInjectables(Map<String, POJOPropertyBuilder> map) {
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        if (annotationIntrospector == null) {
            return;
        }
        for (AnnotatedField annotatedMember : this._classDef.fields()) {
            this._doAddInjectable(annotationIntrospector.findInjectableValueId(annotatedMember), annotatedMember);
        }
        for (AnnotatedMethod annotatedMethod : this._classDef.memberMethods()) {
            if (annotatedMethod.getParameterCount() != 1) continue;
            this._doAddInjectable(annotationIntrospector.findInjectableValueId(annotatedMethod), annotatedMethod);
        }
    }

    protected void _doAddInjectable(Object object, AnnotatedMember annotatedMember) {
        AnnotatedMember annotatedMember2;
        if (object == null) {
            return;
        }
        if (this._injectables == null) {
            this._injectables = new LinkedHashMap();
        }
        if ((annotatedMember2 = this._injectables.put(object, annotatedMember)) != null) {
            String string = object.getClass().getName();
            throw new IllegalArgumentException("Duplicate injectable value with id '" + String.valueOf(object) + "' (of type " + string + ")");
        }
    }

    private PropertyName _propNameFromSimple(String string) {
        return PropertyName.construct(string, null);
    }

    protected void _removeUnwantedProperties(Map<String, POJOPropertyBuilder> map) {
        Iterator<POJOPropertyBuilder> iterator = map.values().iterator();
        while (iterator.hasNext()) {
            POJOPropertyBuilder pOJOPropertyBuilder = iterator.next();
            if (!pOJOPropertyBuilder.anyVisible()) {
                iterator.remove();
                continue;
            }
            if (!pOJOPropertyBuilder.anyIgnorals()) continue;
            if (!pOJOPropertyBuilder.isExplicitlyIncluded()) {
                iterator.remove();
                this._collectIgnorals(pOJOPropertyBuilder.getName());
                continue;
            }
            pOJOPropertyBuilder.removeIgnored();
            if (this._forSerialization || pOJOPropertyBuilder.couldDeserialize()) continue;
            this._collectIgnorals(pOJOPropertyBuilder.getName());
        }
    }

    protected void _removeUnwantedAccessor(Map<String, POJOPropertyBuilder> map) {
        boolean bl = this._config.isEnabled(MapperFeature.INFER_PROPERTY_MUTATORS);
        for (POJOPropertyBuilder pOJOPropertyBuilder : map.values()) {
            pOJOPropertyBuilder.removeNonVisible(bl);
        }
    }

    private void _collectIgnorals(String string) {
        if (!this._forSerialization) {
            if (this._ignoredPropertyNames == null) {
                this._ignoredPropertyNames = new HashSet();
            }
            this._ignoredPropertyNames.add(string);
        }
    }

    protected void _renameProperties(Map<String, POJOPropertyBuilder> map) {
        Object object;
        Object object2;
        Iterator<Map.Entry<String, POJOPropertyBuilder>> iterator = map.entrySet().iterator();
        LinkedList<POJOPropertyBuilder> linkedList = null;
        while (iterator.hasNext()) {
            Map.Entry<String, POJOPropertyBuilder> entry = iterator.next();
            POJOPropertyBuilder pOJOPropertyBuilder = entry.getValue();
            object2 = pOJOPropertyBuilder.findExplicitNames();
            if (object2.isEmpty()) continue;
            iterator.remove();
            if (linkedList == null) {
                linkedList = new LinkedList<POJOPropertyBuilder>();
            }
            if (object2.size() == 1) {
                object = (PropertyName)object2.iterator().next();
                linkedList.add(pOJOPropertyBuilder.withName((PropertyName)object));
                continue;
            }
            linkedList.addAll(pOJOPropertyBuilder.explode((Collection<PropertyName>)object2));
        }
        if (linkedList != null) {
            for (POJOPropertyBuilder pOJOPropertyBuilder : linkedList) {
                object2 = pOJOPropertyBuilder.getName();
                object = map.get(object2);
                if (object == null) {
                    map.put((String)object2, pOJOPropertyBuilder);
                } else {
                    ((POJOPropertyBuilder)object).addAll(pOJOPropertyBuilder);
                }
                this._updateCreatorProperty(pOJOPropertyBuilder, this._creatorProperties);
            }
        }
    }

    protected void _renameUsing(Map<String, POJOPropertyBuilder> map, PropertyNamingStrategy propertyNamingStrategy) {
        POJOPropertyBuilder[] pOJOPropertyBuilderArray = map.values().toArray(new POJOPropertyBuilder[map.size()]);
        map.clear();
        for (POJOPropertyBuilder pOJOPropertyBuilder : pOJOPropertyBuilderArray) {
            String string;
            PropertyName propertyName = pOJOPropertyBuilder.getFullName();
            String string2 = null;
            if (!pOJOPropertyBuilder.isExplicitlyNamed() || this._config.isEnabled(MapperFeature.ALLOW_EXPLICIT_PROPERTY_RENAMING)) {
                if (this._forSerialization) {
                    if (pOJOPropertyBuilder.hasGetter()) {
                        string2 = propertyNamingStrategy.nameForGetterMethod(this._config, pOJOPropertyBuilder.getGetter(), propertyName.getSimpleName());
                    } else if (pOJOPropertyBuilder.hasField()) {
                        string2 = propertyNamingStrategy.nameForField(this._config, pOJOPropertyBuilder.getField(), propertyName.getSimpleName());
                    }
                } else if (pOJOPropertyBuilder.hasSetter()) {
                    string2 = propertyNamingStrategy.nameForSetterMethod(this._config, pOJOPropertyBuilder.getSetter(), propertyName.getSimpleName());
                } else if (pOJOPropertyBuilder.hasConstructorParameter()) {
                    string2 = propertyNamingStrategy.nameForConstructorParameter(this._config, pOJOPropertyBuilder.getConstructorParameter(), propertyName.getSimpleName());
                } else if (pOJOPropertyBuilder.hasField()) {
                    string2 = propertyNamingStrategy.nameForField(this._config, pOJOPropertyBuilder.getField(), propertyName.getSimpleName());
                } else if (pOJOPropertyBuilder.hasGetter()) {
                    string2 = propertyNamingStrategy.nameForGetterMethod(this._config, pOJOPropertyBuilder.getGetter(), propertyName.getSimpleName());
                }
            }
            if (string2 != null && !propertyName.hasSimpleName(string2)) {
                pOJOPropertyBuilder = pOJOPropertyBuilder.withSimpleName(string2);
                string = string2;
            } else {
                string = propertyName.getSimpleName();
            }
            POJOPropertyBuilder pOJOPropertyBuilder2 = map.get(string);
            if (pOJOPropertyBuilder2 == null) {
                map.put(string, pOJOPropertyBuilder);
            } else {
                pOJOPropertyBuilder2.addAll(pOJOPropertyBuilder);
            }
            this._updateCreatorProperty(pOJOPropertyBuilder, this._creatorProperties);
        }
    }

    protected void _renameWithWrappers(Map<String, POJOPropertyBuilder> map) {
        Object object;
        Object object2;
        Iterator<Map.Entry<String, POJOPropertyBuilder>> iterator = map.entrySet().iterator();
        LinkedList<POJOPropertyBuilder> linkedList = null;
        while (iterator.hasNext()) {
            Map.Entry<String, POJOPropertyBuilder> entry = iterator.next();
            POJOPropertyBuilder pOJOPropertyBuilder = entry.getValue();
            object2 = pOJOPropertyBuilder.getPrimaryMember();
            if (object2 == null || (object = this._annotationIntrospector.findWrapperName((Annotated)object2)) == null || !((PropertyName)object).hasSimpleName() || ((PropertyName)object).equals(pOJOPropertyBuilder.getFullName())) continue;
            if (linkedList == null) {
                linkedList = new LinkedList<POJOPropertyBuilder>();
            }
            pOJOPropertyBuilder = pOJOPropertyBuilder.withName((PropertyName)object);
            linkedList.add(pOJOPropertyBuilder);
            iterator.remove();
        }
        if (linkedList != null) {
            for (POJOPropertyBuilder pOJOPropertyBuilder : linkedList) {
                object2 = pOJOPropertyBuilder.getName();
                object = map.get(object2);
                if (object == null) {
                    map.put((String)object2, pOJOPropertyBuilder);
                    continue;
                }
                ((POJOPropertyBuilder)object).addAll(pOJOPropertyBuilder);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void _sortProperties(Map<String, POJOPropertyBuilder> map) {
        String[] stringArray;
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        Boolean bl = annotationIntrospector == null ? null : annotationIntrospector.findSerializationSortAlphabetically(this._classDef);
        boolean bl2 = bl == null ? this._config.shouldSortPropertiesAlphabetically() : bl.booleanValue();
        String[] stringArray2 = stringArray = annotationIntrospector == null ? null : annotationIntrospector.findSerializationPropertyOrder(this._classDef);
        if (!bl2 && this._creatorProperties == null && stringArray == null) {
            return;
        }
        int n = map.size();
        AbstractMap abstractMap = bl2 ? new TreeMap() : new LinkedHashMap(n + n);
        for (POJOPropertyBuilder object : map.values()) {
            abstractMap.put(object.getName(), object);
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap(n + n);
        if (stringArray != null) {
            for (String string : stringArray) {
                void var12_21;
                POJOPropertyBuilder pOJOPropertyBuilder = (POJOPropertyBuilder)abstractMap.get(string);
                if (pOJOPropertyBuilder == null) {
                    for (POJOPropertyBuilder pOJOPropertyBuilder2 : map.values()) {
                        if (!string.equals(pOJOPropertyBuilder2.getInternalName())) continue;
                        pOJOPropertyBuilder = pOJOPropertyBuilder2;
                        String string2 = pOJOPropertyBuilder2.getName();
                        break;
                    }
                }
                if (pOJOPropertyBuilder == null) continue;
                linkedHashMap.put(var12_21, pOJOPropertyBuilder);
            }
        }
        if (this._creatorProperties != null) {
            void var9_14;
            if (bl2) {
                TreeMap<String, POJOPropertyBuilder> treeMap = new TreeMap<String, POJOPropertyBuilder>();
                for (POJOPropertyBuilder pOJOPropertyBuilder : this._creatorProperties) {
                    treeMap.put(pOJOPropertyBuilder.getName(), pOJOPropertyBuilder);
                }
                Collection collection = treeMap.values();
            } else {
                LinkedList<POJOPropertyBuilder> linkedList = this._creatorProperties;
            }
            for (POJOPropertyBuilder pOJOPropertyBuilder : var9_14) {
                linkedHashMap.put(pOJOPropertyBuilder.getName(), pOJOPropertyBuilder);
            }
        }
        linkedHashMap.putAll(abstractMap);
        map.clear();
        map.putAll(linkedHashMap);
    }

    protected void reportProblem(String string) {
        throw new IllegalArgumentException("Problem with definition of " + this._classDef + ": " + string);
    }

    protected POJOPropertyBuilder _property(Map<String, POJOPropertyBuilder> map, PropertyName propertyName) {
        return this._property(map, propertyName.getSimpleName());
    }

    protected POJOPropertyBuilder _property(Map<String, POJOPropertyBuilder> map, String string) {
        POJOPropertyBuilder pOJOPropertyBuilder = map.get(string);
        if (pOJOPropertyBuilder == null) {
            pOJOPropertyBuilder = new POJOPropertyBuilder(this._config, this._annotationIntrospector, this._forSerialization, PropertyName.construct(string));
            map.put(string, pOJOPropertyBuilder);
        }
        return pOJOPropertyBuilder;
    }

    private PropertyNamingStrategy _findNamingStrategy() {
        PropertyNamingStrategy propertyNamingStrategy;
        Object object;
        Object object2 = object = this._annotationIntrospector == null ? null : this._annotationIntrospector.findNamingStrategy(this._classDef);
        if (object == null) {
            return this._config.getPropertyNamingStrategy();
        }
        if (object instanceof PropertyNamingStrategy) {
            return (PropertyNamingStrategy)object;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned PropertyNamingStrategy definition of type " + object.getClass().getName() + "; expected type PropertyNamingStrategy or Class<PropertyNamingStrategy> instead");
        }
        Class clazz = (Class)object;
        if (clazz == PropertyNamingStrategy.class) {
            return null;
        }
        if (!PropertyNamingStrategy.class.isAssignableFrom(clazz)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<PropertyNamingStrategy>");
        }
        HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
        if (handlerInstantiator != null && (propertyNamingStrategy = handlerInstantiator.namingStrategyInstance(this._config, this._classDef, clazz)) != null) {
            return propertyNamingStrategy;
        }
        return (PropertyNamingStrategy)ClassUtil.createInstance(clazz, this._config.canOverrideAccessModifiers());
    }

    protected void _updateCreatorProperty(POJOPropertyBuilder pOJOPropertyBuilder, List<POJOPropertyBuilder> list) {
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (!list.get(i).getInternalName().equals(pOJOPropertyBuilder.getInternalName())) continue;
                list.set(i, pOJOPropertyBuilder);
                break;
            }
        }
    }
}

