/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import java.io.Serializable;

public abstract class ConcreteBeanPropertyBase
implements BeanProperty,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final PropertyMetadata _metadata;
    protected transient JsonFormat.Value _propertyFormat;

    protected ConcreteBeanPropertyBase(PropertyMetadata propertyMetadata) {
        this._metadata = propertyMetadata == null ? PropertyMetadata.STD_REQUIRED_OR_OPTIONAL : propertyMetadata;
    }

    protected ConcreteBeanPropertyBase(ConcreteBeanPropertyBase concreteBeanPropertyBase) {
        this._metadata = concreteBeanPropertyBase._metadata;
        this._propertyFormat = concreteBeanPropertyBase._propertyFormat;
    }

    @Override
    public boolean isRequired() {
        return this._metadata.isRequired();
    }

    @Override
    public PropertyMetadata getMetadata() {
        return this._metadata;
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    @Deprecated
    public final JsonFormat.Value findFormatOverrides(AnnotationIntrospector annotationIntrospector) {
        AnnotatedMember annotatedMember;
        JsonFormat.Value value = null;
        if (annotationIntrospector != null && (annotatedMember = this.getMember()) != null) {
            value = annotationIntrospector.findFormat(annotatedMember);
        }
        if (value == null) {
            value = EMPTY_FORMAT;
        }
        return value;
    }

    @Override
    public JsonFormat.Value findPropertyFormat(MapperConfig<?> mapperConfig, Class<?> clazz) {
        JsonFormat.Value value = this._propertyFormat;
        if (value == null) {
            AnnotatedMember annotatedMember;
            JsonFormat.Value value2 = mapperConfig.getDefaultPropertyFormat(clazz);
            JsonFormat.Value value3 = null;
            AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
            if (annotationIntrospector != null && (annotatedMember = this.getMember()) != null) {
                value3 = annotationIntrospector.findFormat(annotatedMember);
            }
            value = value2 == null ? (value3 == null ? EMPTY_FORMAT : value3) : (value3 == null ? value2 : value2.withOverrides(value3));
            this._propertyFormat = value;
        }
        return value;
    }

    @Override
    public JsonInclude.Value findPropertyInclusion(MapperConfig<?> mapperConfig, Class<?> clazz) {
        JsonInclude.Value value = mapperConfig.getDefaultPropertyInclusion(clazz);
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        AnnotatedMember annotatedMember = this.getMember();
        if (annotationIntrospector == null || annotatedMember == null) {
            return value;
        }
        JsonInclude.Value value2 = annotationIntrospector.findPropertyInclusion(annotatedMember);
        if (value2 == null) {
            return value;
        }
        return value.withOverrides(value2);
    }
}

