/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.POJOPropertiesCollector;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.LRUMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

public class BasicClassIntrospector
extends ClassIntrospector
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final BasicBeanDescription STRING_DESC;
    protected static final BasicBeanDescription BOOLEAN_DESC;
    protected static final BasicBeanDescription INT_DESC;
    protected static final BasicBeanDescription LONG_DESC;
    @Deprecated
    public static final BasicClassIntrospector instance;
    protected final LRUMap<JavaType, BasicBeanDescription> _cachedFCA = new LRUMap(16, 64);

    @Override
    public BasicBeanDescription forSerialization(SerializationConfig serializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(javaType);
        if (basicBeanDescription == null) {
            basicBeanDescription = this._findStdJdkCollectionDesc(serializationConfig, javaType);
            if (basicBeanDescription == null) {
                basicBeanDescription = BasicBeanDescription.forSerialization(this.collectProperties(serializationConfig, javaType, mixInResolver, true, "set"));
            }
            this._cachedFCA.putIfAbsent(javaType, basicBeanDescription);
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forDeserialization(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(javaType);
        if (basicBeanDescription == null) {
            basicBeanDescription = this._findStdJdkCollectionDesc(deserializationConfig, javaType);
            if (basicBeanDescription == null) {
                basicBeanDescription = BasicBeanDescription.forDeserialization(this.collectProperties(deserializationConfig, javaType, mixInResolver, false, "set"));
            }
            this._cachedFCA.putIfAbsent(javaType, basicBeanDescription);
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forDeserializationWithBuilder(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = BasicBeanDescription.forDeserialization(this.collectPropertiesWithBuilder(deserializationConfig, javaType, mixInResolver, false));
        this._cachedFCA.putIfAbsent(javaType, basicBeanDescription);
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forCreation(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(javaType);
        if (basicBeanDescription == null && (basicBeanDescription = this._findStdJdkCollectionDesc(deserializationConfig, javaType)) == null) {
            basicBeanDescription = BasicBeanDescription.forDeserialization(this.collectProperties(deserializationConfig, javaType, mixInResolver, false, "set"));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forClassAnnotations(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(javaType);
        if (basicBeanDescription == null && (basicBeanDescription = this._cachedFCA.get(javaType)) == null) {
            AnnotatedClass annotatedClass = AnnotatedClass.construct(javaType, mapperConfig, mixInResolver);
            basicBeanDescription = BasicBeanDescription.forOtherUse(mapperConfig, javaType, annotatedClass);
            this._cachedFCA.put(javaType, basicBeanDescription);
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forDirectClassAnnotations(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(javaType);
        if (basicBeanDescription == null) {
            AnnotatedClass annotatedClass = AnnotatedClass.constructWithoutSuperTypes(javaType.getRawClass(), mapperConfig, mixInResolver);
            basicBeanDescription = BasicBeanDescription.forOtherUse(mapperConfig, javaType, annotatedClass);
        }
        return basicBeanDescription;
    }

    protected POJOPropertiesCollector collectProperties(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver, boolean bl, String string) {
        AnnotatedClass annotatedClass = AnnotatedClass.construct(javaType, mapperConfig, mixInResolver);
        return this.constructPropertyCollector(mapperConfig, annotatedClass, javaType, bl, string);
    }

    protected POJOPropertiesCollector collectPropertiesWithBuilder(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver, boolean bl) {
        boolean bl2 = mapperConfig.isAnnotationProcessingEnabled();
        AnnotationIntrospector annotationIntrospector = bl2 ? mapperConfig.getAnnotationIntrospector() : null;
        AnnotatedClass annotatedClass = AnnotatedClass.construct(javaType, mapperConfig, mixInResolver);
        JsonPOJOBuilder.Value value = annotationIntrospector == null ? null : annotationIntrospector.findPOJOBuilderConfig(annotatedClass);
        String string = value == null ? "with" : value.withPrefix;
        return this.constructPropertyCollector(mapperConfig, annotatedClass, javaType, bl, string);
    }

    protected POJOPropertiesCollector constructPropertyCollector(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, JavaType javaType, boolean bl, String string) {
        return new POJOPropertiesCollector(mapperConfig, bl, javaType, annotatedClass, string);
    }

    protected BasicBeanDescription _findStdTypeDesc(JavaType javaType) {
        Class<?> clazz = javaType.getRawClass();
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return BOOLEAN_DESC;
            }
            if (clazz == Integer.TYPE) {
                return INT_DESC;
            }
            if (clazz == Long.TYPE) {
                return LONG_DESC;
            }
        } else if (clazz == String.class) {
            return STRING_DESC;
        }
        return null;
    }

    protected boolean _isStdJDKCollection(JavaType javaType) {
        if (!javaType.isContainerType() || javaType.isArrayType()) {
            return false;
        }
        Class<?> clazz = javaType.getRawClass();
        String string = ClassUtil.getPackageName(clazz);
        return !(string == null || !string.startsWith("java.lang") && !string.startsWith("java.util") || !Collection.class.isAssignableFrom(clazz) && !Map.class.isAssignableFrom(clazz));
    }

    protected BasicBeanDescription _findStdJdkCollectionDesc(MapperConfig<?> mapperConfig, JavaType javaType) {
        if (this._isStdJDKCollection(javaType)) {
            AnnotatedClass annotatedClass = AnnotatedClass.construct(javaType, mapperConfig);
            return BasicBeanDescription.forOtherUse(mapperConfig, javaType, annotatedClass);
        }
        return null;
    }

    static {
        AnnotatedClass annotatedClass = AnnotatedClass.constructWithoutSuperTypes(String.class, null);
        STRING_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(String.class), annotatedClass);
        annotatedClass = AnnotatedClass.constructWithoutSuperTypes(Boolean.TYPE, null);
        BOOLEAN_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Boolean.TYPE), annotatedClass);
        annotatedClass = AnnotatedClass.constructWithoutSuperTypes(Integer.TYPE, null);
        INT_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Integer.TYPE), annotatedClass);
        annotatedClass = AnnotatedClass.constructWithoutSuperTypes(Long.TYPE, null);
        LONG_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Long.TYPE), annotatedClass);
        instance = new BasicClassIntrospector();
    }
}

