/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.util.Annotations;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;

public final class AnnotationMap
implements Annotations {
    protected HashMap<Class<?>, Annotation> _annotations;

    public AnnotationMap() {
    }

    private AnnotationMap(HashMap<Class<?>, Annotation> hashMap) {
        this._annotations = hashMap;
    }

    @Override
    public <A extends Annotation> A get(Class<A> clazz) {
        if (this._annotations == null) {
            return null;
        }
        return (A)this._annotations.get(clazz);
    }

    public boolean has(Class<?> clazz) {
        if (this._annotations == null) {
            return false;
        }
        return this._annotations.containsKey(clazz);
    }

    public boolean hasOneOf(Class<? extends Annotation>[] classArray) {
        if (this._annotations != null) {
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                if (!this._annotations.containsKey(classArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    public Iterable<Annotation> annotations() {
        if (this._annotations == null || this._annotations.size() == 0) {
            return Collections.emptyList();
        }
        return this._annotations.values();
    }

    public static AnnotationMap merge(AnnotationMap annotationMap, AnnotationMap annotationMap2) {
        if (annotationMap == null || annotationMap._annotations == null || annotationMap._annotations.isEmpty()) {
            return annotationMap2;
        }
        if (annotationMap2 == null || annotationMap2._annotations == null || annotationMap2._annotations.isEmpty()) {
            return annotationMap;
        }
        HashMap hashMap = new HashMap();
        for (Annotation annotation : annotationMap2._annotations.values()) {
            hashMap.put(annotation.annotationType(), annotation);
        }
        for (Annotation annotation : annotationMap._annotations.values()) {
            hashMap.put(annotation.annotationType(), annotation);
        }
        return new AnnotationMap(hashMap);
    }

    @Override
    public int size() {
        return this._annotations == null ? 0 : this._annotations.size();
    }

    public boolean addIfNotPresent(Annotation annotation) {
        if (this._annotations == null || !this._annotations.containsKey(annotation.annotationType())) {
            this._add(annotation);
            return true;
        }
        return false;
    }

    public boolean add(Annotation annotation) {
        return this._add(annotation);
    }

    public String toString() {
        if (this._annotations == null) {
            return "[null]";
        }
        return this._annotations.toString();
    }

    protected final boolean _add(Annotation annotation) {
        Annotation annotation2;
        if (this._annotations == null) {
            this._annotations = new HashMap();
        }
        return (annotation2 = this._annotations.put(annotation.annotationType(), annotation)) == null || !annotation2.equals(annotation);
    }
}

